/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.util.svg;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class GraphvizUtil {
    private GraphvizUtil() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String renderToSvg(String source) throws IOException {
        if (source == null || source.isEmpty()) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>(2);
        command.add(GraphvizUtil.getGraphvizPath());
        command.add("-Tsvg");
        Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.PIPE).start();
        StringBuilder sb = new StringBuilder();
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
            try {
                try (InputStreamReader reader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);){
                    int len;
                    writer.append(source);
                    writer.close();
                    char[] buf = new char[1024];
                    while ((len = reader.read(buf)) >= 0) {
                        sb.append(buf, 0, len);
                    }
                    reader.close();
                }
                if (writer == null) return sb.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            writer.close();
            return sb.toString();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void exportToFile(String source, String path) throws IOException {
        if (source == null || path == null || source.isEmpty() || path.isEmpty()) {
            return;
        }
        String ext = path.substring(path.lastIndexOf(46) + 1);
        if (ext == null || ext.isEmpty()) {
            return;
        }
        GraphvizUtil.runGraphviz(source, "-T" + ext, "-o", path);
    }

    public static void runGraphviz(String source, String ... args) throws IOException {
        if (source == null || source.isEmpty()) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>(args.length + 1);
        command.add(GraphvizUtil.getGraphvizPath());
        command.addAll(Arrays.asList(args));
        Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.PIPE).start();
        OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
        writer.append(source);
        writer.close();
    }

    private static String getGraphvizPath() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("net.sourceforge.plantuml.eclipse");
        String dotPath1 = prefs.get("graphvizPath", null);
        if (dotPath1 != null && !dotPath1.isEmpty()) {
            return dotPath1;
        }
        String dotPath2 = System.getenv("GRAPHVIZ_DOT");
        if (dotPath2 != null && !dotPath2.isEmpty()) {
            return dotPath2;
        }
        if (Platform.getOS().equals("win32")) {
            return "dot.exe";
        }
        return "dot";
    }
}

