/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.editor.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.zip.ZipInputStream;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea.model.editor.container.AmaltheaModelContainer;
import org.eclipse.app4mc.amalthea.model.editor.util.AmaltheaEditorUtil;
import org.eclipse.app4mc.amalthea.model.emf.AmaltheaResource;
import org.eclipse.app4mc.amalthea.model.io.AmaltheaFileHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;

public class UncompressHandler {
    private static final int BUFFER_SIZE = 2048;
    private static final long MAX_FILE_SIZE = 2000000000L;
    private static final String COMPRESS_ERROR = "Compress error";

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") IStructuredSelection selection, Shell shell, IDecoratorManager decoratorManager) {
        Object firstElement = selection.getFirstElement();
        if (firstElement instanceof IFile && AmaltheaFileHelper.isModelFileExtension((String)((IFile)firstElement).getFileExtension())) {
            IFile iFile = (IFile)firstElement;
            AmaltheaModelContainer modelContainer = AmaltheaEditorUtil.getModelContainer(iFile);
            if (modelContainer != null && modelContainer.getInitialModelFiles().contains(iFile)) {
                this.markResourceUnzipped(iFile, modelContainer);
                this.showInfoDialog();
            } else {
                this.unzipModelFile(iFile, shell, decoratorManager);
            }
        }
    }

    private void showInfoDialog() {
        Display.getDefault().asyncExec(() -> MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Uncompress", (String)"Resource successfully marked as \"expanded\".\n\nSave the model to persist changes."));
    }

    private void markResourceUnzipped(IFile iFile, AmaltheaModelContainer modelContainer) {
        ResourceSet resourceSet = modelContainer.getResourceSet();
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResources()) {
                if (!(resource instanceof AmaltheaResource) || !resource.getURI().lastSegment().equals(iFile.getName())) continue;
                ((AmaltheaResource)resource).setUseZip(false);
                resource.setModified(true);
                modelContainer.updateDirtyStateOfEditors();
                break;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unzipModelFile(IFile iFile, Shell shell, IDecoratorManager decoratorManager) {
        modelFile = new File(iFile.getLocationURI());
        modelFileTmp = new File(modelFile.getParentFile(), String.valueOf(modelFile.getName()) + ".tmp");
        try {
            var6_6 = null;
            var7_11 = null;
            try {
                inputStream = new ZipInputStream(new FileInputStream(modelFile));
                try {
                    outputStream = new FileOutputStream(modelFileTmp);
                    try {
                        zipEntry = inputStream.getNextEntry();
                        if (zipEntry == null || zipEntry.isDirectory()) ** GOTO lbl45
                        total = 0L;
                        bytes = new byte[2048];
                        ** GOTO lbl44
                    }
                    catch (Throwable var6_7) {
                        if (outputStream == null) throw var6_7;
                        outputStream.close();
                        throw var6_7;
                    }
lbl20:
                    // 1 sources

                    while (true) {
                        outputStream.close();
                        while (true) {
                            if (inputStream == null) return;
                            ** GOTO lbl40
                            break;
                        }
                        break;
                    }
                }
                catch (Throwable var7_12) {
                    if (var6_6 == null) {
                        var6_6 = var7_12;
                    } else if (var6_6 != var7_12) {
                        var6_6.addSuppressed(var7_12);
                    }
                    if (inputStream == null) throw var6_6;
                    inputStream.close();
                    throw var6_6;
                    while (true) {
                        if (total + (long)length > 2000000000L) {
                            MessageDialog.openError((Shell)shell, (String)"Compress error", (String)"File being unzipped is too big.");
                            if (outputStream == null) ** continue;
                            ** continue;
                        }
                        ** GOTO lbl-1000
                        break;
                    }
lbl40:
                    // 1 sources

                    inputStream.close();
                    return;
lbl-1000:
                    // 1 sources

                    {
                        outputStream.write(bytes, 0, length);
                        total += (long)length;
lbl44:
                        // 2 sources

                        if ((length = inputStream.read(bytes)) > 0) ** continue;
                    }
lbl45:
                    // 2 sources

                    if (outputStream != null) {
                        outputStream.close();
                    }
                    ** if (inputStream == null) goto lbl-1000
                }
lbl-1000:
                // 1 sources

                {
                    inputStream.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var7_13) {
                if (var6_6 == null) {
                    var6_6 = var7_13;
                    throw var6_6;
                }
                if (var6_6 == var7_13) throw var6_6;
                var6_6.addSuppressed(var7_13);
                throw var6_6;
            }
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)shell, (String)"Compress error", (String)("Failed to uncompress model file! " + e.getMessage()));
            return;
        }
        try {
            Files.delete(modelFile.toPath());
            Files.move(modelFileTmp.toPath(), modelFile.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)shell, (String)"Compress error", (String)("Failed to replace model file! " + e.getMessage()));
        }
        try {
            iFile.refreshLocal(2, null);
            decoratorManager.update("org.eclipse.app4mc.amalthea.file.compressed.decorator");
            return;
        }
        catch (CoreException e) {
            Platform.getLog(this.getClass()).error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

