/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.8.0", "output_model_version=0.8.1"}, service={IConverter.class})
public class HwConverter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HwConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.8.0 to 0.8.1 : Executing Hardware converter for model file : {}", (Object)targetFile.getName());
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.removeXAccessPattern(rootElement);
        this.updateQuartz(rootElement);
    }

    private void updateQuartz(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./hwModel/system//quartzes");
        List hwSystemElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./hwModel/system", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        List quartzElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        Element hwSystemElement = null;
        if (!hwSystemElements.isEmpty()) {
            hwSystemElement = (Element)hwSystemElements.get(0);
        }
        for (Element quartzElement : quartzElements) {
            boolean removedQuartzes;
            boolean removedPrescalers;
            boolean removedPorts;
            boolean removedNetworks;
            boolean removedMemories;
            Attribute nameAttribute;
            Parent parent = quartzElement.getParent();
            if (parent != null) {
                parent.removeContent((Content)quartzElement);
            }
            quartzElement.setName("quartzes");
            if (hwSystemElement != null) {
                hwSystemElement.addContent((Content)quartzElement);
            }
            String quartzName = (nameAttribute = quartzElement.getAttribute("name")) != null ? nameAttribute.getValue() : "";
            LOGGER.info("Moved Quartz element {} as a child element of HwSystem", (Object)quartzName);
            boolean removedComponents = quartzElement.removeChild("components");
            if (removedComponents) {
                LOGGER.warn("-- Removed all HwComponent objects defined inside Quartz : {}", (Object)quartzName);
            }
            if (removedMemories = quartzElement.removeChild("memories")) {
                LOGGER.warn("-- Removed all Memory objects defined inside Quartz : {}", (Object)quartzName);
            }
            if (removedNetworks = quartzElement.removeChild("networks")) {
                LOGGER.warn("-- Removed all Network objects defined inside Quartz : {}", (Object)quartzName);
            }
            if (removedPorts = quartzElement.removeChild("ports")) {
                LOGGER.warn("-- Removed all HwPort objects defined inside Quartz : {}", (Object)quartzName);
            }
            if (removedPrescalers = quartzElement.removeChild("prescaler")) {
                LOGGER.warn("-- Removed all Prescaler objects defined inside Quartz : {}", (Object)quartzName);
            }
            if (!(removedQuartzes = quartzElement.removeChild("quartzes"))) continue;
            LOGGER.warn("-- Moved all Quartz objects defined inside Quartz : {} as elements inside HwSystem", (Object)quartzName);
        }
    }

    private void removeXAccessPattern(Element rootElement) {
        List memoryTypeElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./hwModel/memoryTypes", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi")});
        for (Element memoryTypeElement : memoryTypeElements) {
            memoryTypeElement.removeAttribute("xAccessPattern");
            LOGGER.info("xAccessPattern attribute and its value are removed from MemoryType: {}", (Object)memoryTypeElement.getAttributeValue("name"));
        }
    }
}

