/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelperUtil {
    private static final String NO_NAME = "no-name";
    private static final String AMXMI = "amxmi";
    public static final Logger LOGGER = LoggerFactory.getLogger(HelperUtil.class);

    private HelperUtil() {
    }

    public static <T> List<T> getXpathResult(Document document, String xpath, Class<T> expectedType, Namespace ... nameSpaces) {
        XPathFactory xpfac = XPathFactory.instance();
        if (Attribute.class.isAssignableFrom(expectedType)) {
            XPathExpression xp = xpfac.compile(xpath, Filters.attribute(), null, nameSpaces);
            return xp.evaluate((Object)document);
        }
        if (Element.class.isAssignableFrom(expectedType)) {
            XPathExpression xp = xpfac.compile(xpath, Filters.element(), null, nameSpaces);
            return xp.evaluate((Object)document);
        }
        return null;
    }

    public static <T> List<T> getXpathResult(Element element, String xpath, Class<T> expectedType, Namespace ... nameSpaces) {
        XPathFactory xpfac = XPathFactory.instance();
        if (Attribute.class.isAssignableFrom(expectedType)) {
            XPathExpression xp = xpfac.compile(xpath, Filters.attribute(), null, nameSpaces);
            return xp.evaluate((Object)element);
        }
        if (Element.class.isAssignableFrom(expectedType)) {
            XPathExpression xp = xpfac.compile(xpath, Filters.element(), null, nameSpaces);
            return xp.evaluate((Object)element);
        }
        return null;
    }

    public static Element createAmaltheaElement(ModelVersion version) {
        Element amaltheaElement = new Element("Amalthea");
        amaltheaElement.setNamespace(AmaltheaNamespaceRegistry.getNamespace(version, "am"));
        amaltheaElement.addNamespaceDeclaration(AmaltheaNamespaceRegistry.getGenericNamespace("xsi"));
        amaltheaElement.addNamespaceDeclaration(AmaltheaNamespaceRegistry.getGenericNamespace("xmi"));
        Attribute attrib = new Attribute("version", "2.0");
        attrib.setNamespace(AmaltheaNamespaceRegistry.getGenericNamespace("xmi"));
        amaltheaElement.setAttribute(attrib);
        return amaltheaElement;
    }

    public static void updateRootElement_NameSpaces(Element rootElement, ModelVersion oldNsVersion, ModelVersion newNsVersion) {
        Namespace defaultNamespace = rootElement.getNamespace();
        if (AmaltheaNamespaceRegistry.isNamespaceAvailable(oldNsVersion, defaultNamespace)) {
            rootElement.setNamespace(null);
            rootElement.removeNamespaceDeclaration(defaultNamespace);
            rootElement.setNamespace(AmaltheaNamespaceRegistry.getNamespace(newNsVersion, "am"));
            ArrayList additionalNamespaces = new ArrayList();
            additionalNamespaces.addAll(rootElement.getAdditionalNamespaces());
            int i = 0;
            while (i < additionalNamespaces.size()) {
                Namespace ns = (Namespace)additionalNamespaces.get(i);
                if (AmaltheaNamespaceRegistry.isNamespaceAvailable(oldNsVersion, ns)) {
                    rootElement.removeNamespaceDeclaration(ns);
                }
                ++i;
            }
            rootElement.addNamespaceDeclaration(AmaltheaNamespaceRegistry.getGenericNamespace("xsi"));
            rootElement.addNamespaceDeclaration(AmaltheaNamespaceRegistry.getGenericNamespace("xmi"));
        }
    }

    public static void buildXMLDocumentsMap(File targetFile, Map<File, Document> map) throws Exception {
        if (map.containsKey(targetFile.getCanonicalFile())) {
            return;
        }
        if (!targetFile.exists()) {
            LOGGER.error("Referred file does not exists : {}", (Object)targetFile.getAbsolutePath());
            return;
        }
        if (!targetFile.getAbsolutePath().substring(targetFile.getAbsolutePath().lastIndexOf(46) + 1).contains(AMXMI)) {
            LOGGER.info("Non amalthea files will not be considered for model migration");
            return;
        }
        Document xmlDoc = HelperUtil.loadFile(targetFile.getAbsolutePath());
        map.put(targetFile.getCanonicalFile(), xmlDoc);
        List<Attribute> hrefs = HelperUtil.getXpathResult(xmlDoc.getRootElement(), ".//@href", Attribute.class, new Namespace[0]);
        HashSet<String> referredFilePaths = new HashSet<String>();
        for (Attribute attribute : hrefs) {
            String value = attribute.getValue();
            if (value.startsWith("amlt:/")) {
                File[] allFilesInDirectory;
                File[] fileArray = allFilesInDirectory = targetFile.getParentFile().listFiles((dir, name) -> name.endsWith(".amxmi"));
                int n = allFilesInDirectory.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    HelperUtil.buildXMLDocumentsMap(file, map);
                    ++n2;
                }
                continue;
            }
            int index = value.lastIndexOf(35);
            if (index == -1) continue;
            String fileName = value.substring(0, index);
            referredFilePaths.add(fileName);
        }
        for (String relativePath : referredFilePaths) {
            if (relativePath == null || relativePath.length() <= 0) continue;
            HelperUtil.buildXMLDocumentsMap(new File(String.valueOf(targetFile.getParent()) + File.separator + relativePath), map);
        }
    }

    public static Document loadFile(String path) throws JDOMException, IOException {
        Document doc;
        long start = System.currentTimeMillis();
        File file = new File(path);
        SAXBuilder sax = new SAXBuilder();
        sax.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
        sax.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", (Object)"");
        try {
            doc = sax.build(file);
        }
        catch (JDOMException e) {
            throw new JDOMException("Error occured while parsing file : " + path, (Throwable)e);
        }
        long end = System.currentTimeMillis();
        LOGGER.info("Total time taken to load file : {} : {} ms", (Object)path, (Object)(end - start));
        return doc;
    }

    public static void updateFileName(Map<File, Document> fileName2documentMap) {
        for (Map.Entry<File, Document> entry : fileName2documentMap.entrySet()) {
            Document document = entry.getValue();
            List<Attribute> hrefs = HelperUtil.getXpathResult(document.getRootElement(), ".//@href", Attribute.class, new Namespace[0]);
            for (Attribute attribute : hrefs) {
                String extension;
                String attributeValue = attribute.getValue();
                int indexOfHash = attributeValue.lastIndexOf(35);
                if (indexOfHash == -1 || indexOfHash + 1 >= attributeValue.length()) continue;
                String refRelativePath = attributeValue.substring(0, indexOfHash);
                int lastIndex = refRelativePath.lastIndexOf(47);
                String refFileName = "";
                if (lastIndex == -1) {
                    refFileName = refRelativePath;
                } else if (lastIndex != -1 && lastIndex + 1 < refRelativePath.length()) {
                    refFileName = refRelativePath.substring(lastIndex + 1);
                }
                if (refFileName.length() <= 0) continue;
                int indexOfDot = refFileName.indexOf(46);
                if (indexOfDot != -1 && (extension = refFileName.substring(indexOfDot + 1)).startsWith(AMXMI) && !extension.equals(AMXMI)) {
                    refFileName = String.valueOf(refFileName) + ".amxmi";
                }
                String attributeValue_part2 = attributeValue.substring(indexOfHash + 1);
                attribute.setValue(String.valueOf(refFileName) + "#" + attributeValue_part2);
            }
        }
    }

    public static void saveFile(Document doc, String outputFilePath, boolean prettyPrintXml) throws IOException {
        HelperUtil.saveFile(doc, outputFilePath, prettyPrintXml, false);
    }

    public static void saveFile(Document doc, String outputFilePath, boolean prettyPrintXml, boolean force) throws IOException {
        XMLOutputter xout = prettyPrintXml ? new XMLOutputter(Format.getPrettyFormat()) : new XMLOutputter();
        File file = new File(outputFilePath);
        if (force && !file.exists()) {
            file.getParentFile().mkdirs();
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (FileOutputStream out = new FileOutputStream(file);){
            xout.output(doc, (OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void saveFile(Document doc, File outputFile, boolean prettyPrintXml) throws IOException {
        HelperUtil.saveFile(doc, outputFile, prettyPrintXml, false);
    }

    public static void saveFile(Document doc, File outputFile, boolean prettyPrintXml, boolean force) throws IOException {
        XMLOutputter xout;
        XMLOutputter xMLOutputter = xout = prettyPrintXml ? new XMLOutputter(Format.getPrettyFormat()) : new XMLOutputter();
        if (force && !outputFile.exists()) {
            outputFile.getParentFile().mkdirs();
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            xout.output(doc, (OutputStream)out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Map.Entry<String, String> getSingleElementsNameandTypeFromAttributeOrChildeElement(String attributeOrTagName, Element element) {
        String hrefValue;
        String attributeValue = element.getAttributeValue(attributeOrTagName);
        if (attributeValue != null) {
            String name = HelperUtil.getElementNameFromReference(attributeValue);
            String type = HelperUtil.getElementTypeFromReference(attributeValue);
            return new AbstractMap.SimpleEntry<String, String>(name, type);
        }
        Element child = element.getChild(attributeOrTagName);
        if (child != null && (hrefValue = child.getAttributeValue("href")) != null) {
            String name = HelperUtil.getElementNameFromReference(hrefValue);
            String type = HelperUtil.getElementTypeFromReference(hrefValue);
            return new AbstractMap.SimpleEntry<String, String>(name, type);
        }
        return null;
    }

    public static String getSingleElementNameFromAttributeOrChildeElement(String attributeOrTagName, Element element) {
        String hrefValue;
        String attributeValue = element.getAttributeValue(attributeOrTagName);
        if (attributeValue != null) {
            return HelperUtil.getElementNameFromReference(attributeValue);
        }
        Element child = element.getChild(attributeOrTagName);
        if (child != null && (hrefValue = child.getAttributeValue("href")) != null) {
            return HelperUtil.getElementNameFromReference(hrefValue);
        }
        return null;
    }

    public static String getElementTypeFromReference(String reference) {
        if (reference == null || reference.length() == 0) {
            return "";
        }
        int startIndex = reference.indexOf("?type=");
        if (startIndex != -1) {
            return reference.substring(startIndex + 6);
        }
        return reference;
    }

    public static String getElementNameFromReference(String reference) {
        if (reference == null || reference.length() == 0) {
            return "";
        }
        int startIndex = reference.indexOf("?type=");
        if (startIndex != -1) {
            String name = reference.substring(0, startIndex);
            if (name.startsWith("amlt:/#")) {
                name = name.replaceFirst("amlt\\:\\/\\#", "");
                return name;
            }
            return name;
        }
        return reference;
    }

    public static Element getParentElementOfName(Element currentElement, String ... parentNames) {
        Element parentElement = currentElement.getParentElement();
        if (parentElement != null) {
            boolean contains = Arrays.stream(parentNames).anyMatch(parentElement.getName()::equals);
            if (contains) {
                return parentElement;
            }
            return HelperUtil.getParentElementOfName(parentElement, parentNames);
        }
        return null;
    }

    public static String getValueFromChildElement(Element element, String childElementName, String childElementAttributeName) {
        Element child = element.getChild(childElementName);
        if (child != null) {
            return child.getAttributeValue(childElementAttributeName);
        }
        return null;
    }

    public static void copyAllNameSpaces(Element source, Element target) {
        Namespace namespace = source.getNamespace();
        target.setNamespace(namespace);
        List additionalNamespaces = source.getAdditionalNamespaces();
        for (Namespace additionalNS : additionalNamespaces) {
            target.addNamespaceDeclaration(additionalNS);
        }
    }

    public static void copyElement_Attribute_or_Element(Element sourceElement, Element targetElement, String childNodeOrAttributeName) {
        Attribute attribute = sourceElement.getAttribute(childNodeOrAttributeName);
        Element childElement = sourceElement.getChild(childNodeOrAttributeName);
        if (attribute != null) {
            targetElement.setAttribute(attribute.clone());
        } else if (childElement != null) {
            targetElement.setContent((Content)childElement.clone());
        }
    }

    public static void removeDefaultAttribs(Element element) {
        element.setNamespace(null);
        element.removeNamespaceDeclaration(Namespace.getNamespace((String)"http://www.omg.org/XMI"));
        element.removeNamespaceDeclaration(Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance"));
        element.removeAttribute("version", Namespace.getNamespace((String)"xmi", (String)"http://www.omg.org/XMI"));
    }

    public static Map<String, String> getMultipleElementsNameandTypeFromAttributeOrChildeElement(String attributeOrTagName, Element element) {
        String attributeValue = element.getAttributeValue(attributeOrTagName);
        if (attributeValue != null) {
            String[] references;
            HashMap<String, String> map = new HashMap<String, String>();
            String[] stringArray = references = attributeValue.split("\\s");
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                String reference = stringArray[n2];
                String name = HelperUtil.getElementNameFromReference(reference);
                String type = HelperUtil.getElementTypeFromReference(reference);
                map.put(name, type);
                ++n2;
            }
            return map;
        }
        List children = element.getChildren(attributeOrTagName);
        if (!children.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Element child : children) {
                String hrefValue = child.getAttributeValue("href");
                if (hrefValue == null) continue;
                String name = HelperUtil.getElementNameFromReference(hrefValue);
                String type = HelperUtil.getElementTypeFromReference(hrefValue);
                map.put(name, type);
            }
            return map;
        }
        return new HashMap<String, String>();
    }

    public static String encodeName(String name) {
        String result;
        if (name == null || name.length() == 0) {
            return NO_NAME;
        }
        try {
            result = URLEncoder.encode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            result = name;
        }
        return result;
    }

    public static String decodeName(String name) {
        String result;
        if (name == null || name.length() == 0) {
            return NO_NAME;
        }
        try {
            result = URLDecoder.decode(name, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            result = name;
        }
        return result;
    }

    public static String encodeNameForReference(String name) {
        return HelperUtil.encodeName(name);
    }
}

