/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.tokens;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.ITokenDiagnosticProvider;
import org.eclipse.xtext.serializer.tokens.IValueSerializer;

public class ValueSerializer
implements IValueSerializer {
    @Inject
    private IValueConverterService converter;
    @Inject
    protected ITokenDiagnosticProvider diagnostics;
    @Inject
    protected TokenUtil tokenUtil;

    public boolean isValid(EObject context, RuleCall ruleCall, Object value, ISerializationDiagnostic.Acceptor errors) {
        block5: {
            try {
                String str = this.converter.toString(value, ruleCall.getRule().getName());
                if (str == null) break block5;
                return true;
            }
            catch (Throwable e) {
                if (errors != null) {
                    errors.accept(this.diagnostics.getValueConversionExceptionDiagnostic(context, ruleCall, value, e));
                }
                return false;
            }
        }
        if (errors != null) {
            errors.accept(this.diagnostics.getNullNotAllowedDiagnostic(context, ruleCall));
        }
        return false;
    }

    protected String serialize(INode node) {
        if (node instanceof ILeafNode) {
            return ((ILeafNode)node).getText();
        }
        StringBuilder builder = new StringBuilder(node.getLength());
        boolean hiddenSeen = false;
        for (ILeafNode leaf : node.getLeafNodes()) {
            if (!leaf.isHidden()) {
                if (hiddenSeen && builder.length() > 0) {
                    builder.append(' ');
                }
                builder.append(leaf.getText());
                hiddenSeen = false;
                continue;
            }
            hiddenSeen = true;
        }
        return builder.toString();
    }

    public String serializeAssignedValue(EObject context, RuleCall ruleCall, Object value, INode node, ISerializationDiagnostic.Acceptor errors) {
        Object converted;
        if (node != null && (converted = this.converter.toValue(this.serialize(node), ruleCall.getRule().getName(), node)) != null && converted.equals(value)) {
            return this.tokenUtil.serializeNode(node);
        }
        try {
            String str = this.converter.toString(value, ruleCall.getRule().getName());
            if (str != null) {
                return str;
            }
            if (errors != null) {
                errors.accept(this.diagnostics.getNullNotAllowedDiagnostic(context, ruleCall));
            }
            return null;
        }
        catch (Throwable e) {
            if (errors != null) {
                errors.accept(this.diagnostics.getValueConversionExceptionDiagnostic(context, ruleCall, value, e));
            }
            return null;
        }
    }
}

