/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.serializer.analysis.IGrammarConstraintProvider;
import org.eclipse.xtext.serializer.sequencer.IContextFinder;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextFinder
implements IContextFinder {
    protected List<IGrammarConstraintProvider.IConstraintContext> constraintContexts;
    protected Map<Pair<EObject, EClass>, IGrammarConstraintProvider.IConstraint> constraints;
    @Inject
    protected IGrammarAccess grammarAccess;
    @Inject
    protected IGrammarConstraintProvider grammarConstraintProvider;

    protected Iterable<EObject> findContexts(EObject semanitcObject) {
        EClass cls = semanitcObject.eClass();
        HashSet result = Sets.newHashSet();
        block0: for (IGrammarConstraintProvider.IConstraintContext cc : this.constraintContexts) {
            for (IGrammarConstraintProvider.IConstraint c : cc.getConstraints()) {
                if (c.getType() != cls) continue;
                result.add(cc.getContext());
                continue block0;
            }
        }
        return result;
    }

    @Override
    public Iterable<EObject> findContextsByContents(EObject semanitcObject, Iterable<EObject> contextCandidates) {
        this.initConstraints();
        if (contextCandidates == null) {
            return this.findContexts(semanitcObject);
        }
        EClass cls = semanitcObject.eClass();
        HashSet result = Sets.newHashSet();
        for (EObject candidate : contextCandidates) {
            if (this.getConstraint(candidate, cls) == null) continue;
            result.add(candidate);
        }
        return result;
    }

    @Override
    public Iterable<EObject> findContextsByContentsAndContainer(EObject semanitcObject, Iterable<EObject> contextCandidates) {
        return this.findContextsByContents(semanitcObject, contextCandidates);
    }

    protected IGrammarConstraintProvider.IConstraint getConstraint(EObject context, EClass type) {
        return this.constraints.get(Tuples.create((Object)context, (Object)type));
    }

    protected void initConstraints() {
        if (this.constraintContexts == null) {
            this.constraints = Maps.newHashMap();
            this.constraintContexts = this.grammarConstraintProvider.getConstraints(this.grammarAccess.getGrammar());
            for (IGrammarConstraintProvider.IConstraintContext ctx : this.constraintContexts) {
                for (IGrammarConstraintProvider.IConstraint constraint : ctx.getConstraints()) {
                    this.constraints.put((Pair<EObject, EClass>)Tuples.create((Object)ctx.getContext(), (Object)constraint.getType()), constraint);
                }
            }
        }
    }
}

