/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.sequencer;

import com.google.inject.Inject;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.EnumRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.impl.TokenUtil;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISyntacticSequenceAcceptor;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.diagnostic.ISyntacticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.sequencer.EmitterNodeFinder;
import org.eclipse.xtext.serializer.sequencer.EmitterNodeIterator;
import org.eclipse.xtext.serializer.sequencer.ISyntacticSequencer;
import org.eclipse.xtext.serializer.sequencer.RuleCallStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSyntacticSequencer
implements ISyntacticSequencer,
ISemanticSequenceAcceptor {
    protected Stack<SyntacticalContext> contexts = new Stack();
    protected ISyntacticSequenceAcceptor delegate;
    @Inject
    protected ISyntacticSequencerDiagnosticProvider diagnosticProvider;
    protected ISerializationDiagnostic.Acceptor errorAcceptor;
    @Inject
    protected ISyntacticSequencerPDAProvider pdaProvider;
    @Inject
    protected TokenUtil tokenUtil;

    protected void accept(INode fromNode, List<ISyntacticSequencerPDAProvider.ISynState> path, RuleCallStack stack) {
        if (path.isEmpty()) {
            return;
        }
        EmitterNodeFinder nodes = new EmitterNodeFinder(fromNode);
        for (ISyntacticSequencerPDAProvider.ISynState emitter : path) {
            this.accept(emitter, nodes.next(emitter.getGrammarElement()), stack);
        }
    }

    protected void accept(ISyntacticSequencerPDAProvider.ISynState emitter, INode node, RuleCallStack stack) {
        switch (emitter.getType()) {
            case UNASSIGNED_PARSER_RULE_ENTER: {
                RuleCall rc1 = (RuleCall)emitter.getGrammarElement();
                this.delegate.enterUnassignedParserRuleCall(rc1);
                stack.push(rc1);
                return;
            }
            case UNASSIGNED_PARSER_RULE_EXIT: {
                RuleCall rc2 = (RuleCall)emitter.getGrammarElement();
                this.delegate.leaveUnssignedParserRuleCall(rc2);
                RuleCall lastRc = (RuleCall)stack.pop();
                if (lastRc != rc2 && this.errorAcceptor != null) {
                    this.errorAcceptor.accept(this.diagnosticProvider.createUnexpectedStackStateDiagnostic(((SyntacticalContext)this.contexts.get((int)(this.contexts.size() - 1))).semanticObject, stack, lastRc, emitter));
                }
                return;
            }
            case UNASSIGEND_ACTION_CALL: {
                this.delegate.acceptUnassignedAction((Action)emitter.getGrammarElement());
                return;
            }
            case UNASSIGEND_KEYWORD: {
                Keyword keyword = (Keyword)emitter.getGrammarElement();
                this.delegate.acceptUnassignedKeyword(keyword, (ILeafNode)node);
                return;
            }
            case UNASSIGNED_DATATYPE_RULE_CALL: {
                RuleCall rc3 = (RuleCall)emitter.getGrammarElement();
                String value3 = this.getUnassignedRuleCallToken(rc3, node);
                this.delegate.acceptUnassignedDatatype(rc3, value3, (ICompositeNode)node);
                return;
            }
            case UNASSIGNED_TERMINAL_RULE_CALL: {
                RuleCall rc4 = (RuleCall)emitter.getGrammarElement();
                String value4 = this.getUnassignedRuleCallToken(rc4, node);
                this.delegate.acceptUnassignedTerminal(rc4, value4, (ILeafNode)node);
                return;
            }
        }
        throw new RuntimeException("invalid state for emitting: " + emitter + " (" + (Object)((Object)emitter.getType()) + ")");
    }

    @Override
    public void acceptAssignedCrossRefDatatype(RuleCall datatypeRC, String token, EObject value, int index, ICompositeNode node) {
        this.navigateToAbsorber(datatypeRC, node);
        this.delegate.acceptAssignedCrossRefDatatype(datatypeRC, token, value, index, node);
    }

    @Override
    public void acceptAssignedCrossRefEnum(RuleCall enumRC, String token, EObject value, int index, ICompositeNode node) {
        this.navigateToAbsorber(enumRC, node);
        this.delegate.acceptAssignedCrossRefEnum(enumRC, token, value, index, node);
    }

    @Override
    public void acceptAssignedCrossRefTerminal(RuleCall terminalRC, String token, EObject value, int index, ILeafNode node) {
        this.navigateToAbsorber(terminalRC, node);
        this.delegate.acceptAssignedCrossRefTerminal(terminalRC, token, value, index, node);
    }

    @Override
    public void acceptAssignedDatatype(RuleCall datatypeRC, String token, Object value, int index, ICompositeNode node) {
        this.navigateToAbsorber(datatypeRC, node);
        this.delegate.acceptAssignedDatatype(datatypeRC, token, value, index, node);
    }

    @Override
    public void acceptAssignedEnum(RuleCall enumRC, String token, Object value, int index, ICompositeNode node) {
        this.navigateToAbsorber(enumRC, node);
        this.delegate.acceptAssignedEnum(enumRC, token, value, index, node);
    }

    @Override
    public void acceptAssignedKeyword(Keyword keyword, String token, Boolean value, int index, ILeafNode node) {
        this.navigateToAbsorber(keyword, node);
        this.delegate.acceptAssignedKeyword(keyword, token, value, index, node);
    }

    @Override
    public void acceptAssignedKeyword(Keyword keyword, String token, String value, int index, ILeafNode node) {
        this.navigateToAbsorber(keyword, node);
        this.delegate.acceptAssignedKeyword(keyword, token, value, index, node);
    }

    @Override
    public void acceptAssignedTerminal(RuleCall terminalRC, String token, Object value, int index, ILeafNode node) {
        this.navigateToAbsorber(terminalRC, node);
        this.delegate.acceptAssignedTerminal(terminalRC, token, value, index, node);
    }

    protected void acceptNode(INode node) {
        EObject ge = node.getGrammarElement();
        if (ge instanceof Keyword) {
            this.acceptUnassignedKeyword((Keyword)ge, (ILeafNode)node);
        } else if (ge instanceof RuleCall) {
            RuleCall rc = (RuleCall)ge;
            if (rc.getRule() instanceof TerminalRule) {
                this.acceptUnassignedTerminal(rc, node.getText(), (ILeafNode)node);
            } else if (rc.getRule() instanceof ParserRule) {
                this.acceptUnassignedDatatype(rc, node.getText(), (ICompositeNode)node);
            } else if (rc.getRule() instanceof EnumRule) {
                this.acceptUnassignedEnum(rc, node.getText(), (ICompositeNode)node);
            }
        } else if (ge instanceof Action) {
            this.acceptUnassignedAction((Action)ge);
        } else {
            throw new RuntimeException("Unexpected grammar element: " + node.getGrammarElement());
        }
    }

    protected void acceptNodes(ISyntacticSequencerPDAProvider.ISynNavigable fromState, INode fromNode, INode toNode) {
        RuleCallStack stack = (RuleCallStack)this.contexts.peek().stack.clone();
        EmitterNodeIterator ni = new EmitterNodeIterator(fromNode, toNode, false, false);
        while (ni.hasNext()) {
            INode next = ni.next();
            List<ISyntacticSequencerPDAProvider.ISynState> path = fromState.getShortestPathTo((AbstractElement)next.getGrammarElement(), stack);
            if (path == null) continue;
            if (!(path.get(path.size() - 1) instanceof ISyntacticSequencerPDAProvider.ISynEmitterState)) {
                return;
            }
            fromState = (ISyntacticSequencerPDAProvider.ISynEmitterState)path.get(path.size() - 1);
            this.acceptNode(next);
        }
    }

    public void acceptUnassignedAction(Action action) {
        SyntacticalContext i = this.contexts.peek();
        i.lastState = this.navigateToEmitter(i.lastState, i.getLastNode(), action, null, i.stack);
        this.delegate.acceptUnassignedAction(action);
    }

    public void acceptUnassignedDatatype(RuleCall datatypeRC, String value, ICompositeNode node) {
        this.navigateToEmitter(datatypeRC, node);
        this.delegate.acceptUnassignedDatatype(datatypeRC, value, node);
    }

    public void acceptUnassignedEnum(RuleCall enumRC, String value, ICompositeNode node) {
        this.navigateToEmitter(enumRC, node);
        this.delegate.acceptUnassignedEnum(enumRC, value, node);
    }

    public void acceptUnassignedKeyword(Keyword keyword, ILeafNode node) {
        this.navigateToEmitter(keyword, node);
        this.delegate.acceptUnassignedKeyword(keyword, node);
    }

    public void acceptUnassignedTerminal(RuleCall terminalRC, String value, ILeafNode node) {
        this.navigateToEmitter(terminalRC, node);
        this.delegate.acceptUnassignedTerminal(terminalRC, value, node);
    }

    protected abstract void emitUnassignedTokens(EObject var1, ISyntacticSequencerPDAProvider.ISynTransition var2, INode var3, INode var4);

    @Override
    public boolean enterAssignedAction(Action action, EObject semanticChild, ICompositeNode node) {
        this.navigateToAbsorber(action, node);
        boolean shouldEnter = this.delegate.enterAssignedAction(action, semanticChild, node);
        if (shouldEnter) {
            ISyntacticSequencerPDAProvider.ISynAbsorberState pda = this.pdaProvider.getPDA(action, semanticChild.eClass());
            SyntacticalContext j = new SyntacticalContext(action, semanticChild, pda, node);
            this.contexts.push(j);
        }
        return shouldEnter;
    }

    @Override
    public boolean enterAssignedParserRuleCall(RuleCall rc, EObject semanticChild, ICompositeNode node) {
        this.navigateToAbsorber(rc, node);
        boolean shouldEnter = this.delegate.enterAssignedParserRuleCall(rc, semanticChild, node);
        if (shouldEnter) {
            ISyntacticSequencerPDAProvider.ISynAbsorberState pda = this.pdaProvider.getPDA(rc.getRule(), semanticChild.eClass());
            SyntacticalContext j = new SyntacticalContext(rc.getRule(), semanticChild, pda, node);
            this.contexts.push(j);
        }
        return shouldEnter;
    }

    protected ISyntacticSequencerPDAProvider.ISynTransition findTransition(EObject context, EObject semanticObject, ISyntacticSequencerPDAProvider.ISynFollowerOwner fromState, INode fromNode, AbstractElement toEle, INode toNode, RuleCallStack stack) {
        if (fromState == null) {
            return null;
        }
        if (fromState instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
            ISyntacticSequencerPDAProvider.ISynAbsorberState fromAbsorber = (ISyntacticSequencerPDAProvider.ISynAbsorberState)fromState;
            ISyntacticSequencerPDAProvider.ISynTransition transition = fromAbsorber.getOutTransitionsByElement().get(toEle);
            if (transition == null) {
                if (this.errorAcceptor != null) {
                    this.errorAcceptor.accept(this.diagnosticProvider.createInvalidFollowingAbsorberDiagnostic(context, semanticObject, fromAbsorber, toEle));
                }
                return null;
            }
            return transition;
        }
        return null;
    }

    @Override
    public void finish() {
        this.navigateToAbsorber(null, null);
        this.delegate.finish();
    }

    protected INode getLastLeaf(INode node) {
        INode result = node;
        while (result instanceof ICompositeNode) {
            result = ((ICompositeNode)result).getLastChild();
        }
        return result != null ? result : node;
    }

    protected String getTokenText(INode node) {
        return this.tokenUtil.serializeNode(node);
    }

    protected abstract String getUnassignedRuleCallToken(RuleCall var1, INode var2);

    @Override
    public void init(EObject context, EObject semanticObject, ISyntacticSequenceAcceptor sequenceAcceptor, ISerializationDiagnostic.Acceptor errorAcceptor) {
        ICompositeNode node = NodeModelUtils.findActualNodeFor(semanticObject);
        SyntacticalContext acceptor = new SyntacticalContext(context, semanticObject, this.pdaProvider.getPDA(context, semanticObject.eClass()), node);
        this.contexts.push(acceptor);
        this.delegate = sequenceAcceptor;
        this.errorAcceptor = errorAcceptor;
    }

    @Override
    public void leaveAssignedAction(Action action, EObject semanticChild) {
        this.contexts.pop();
    }

    @Override
    public void leaveAssignedParserRuleCall(RuleCall rc, EObject semanticChild) {
        this.contexts.pop();
    }

    protected void navigateToAbsorber(AbstractElement ele, INode node) {
        SyntacticalContext ctx = this.contexts.peek();
        ctx.lastState = this.findTransition(ctx.context, ctx.semanticObject, ctx.lastState, ctx.getLastNode(), ele, node, ctx.stack);
        this.emitUnassignedTokens(ctx.semanticObject, (ISyntacticSequencerPDAProvider.ISynTransition)ctx.lastState, ctx.getLastNode(), node);
        ctx.lastState = this.navigateToAbsorber(ctx.lastState, ctx.getLastNode(), null, ctx.stack);
        ctx.setLastNode(this.getLastLeaf(node));
    }

    protected ISyntacticSequencerPDAProvider.ISynAbsorberState navigateToAbsorber(ISyntacticSequencerPDAProvider.ISynFollowerOwner fromState, INode fromNode, INode toNode, RuleCallStack stack) {
        if (fromState instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
            return (ISyntacticSequencerPDAProvider.ISynAbsorberState)fromState;
        }
        if (fromState instanceof ISyntacticSequencerPDAProvider.ISynNavigable) {
            ISyntacticSequencerPDAProvider.ISynNavigable fromEmitter = (ISyntacticSequencerPDAProvider.ISynNavigable)fromState;
            if (fromEmitter.hasEmitters()) {
                this.accept(fromNode, fromEmitter.getShortestStackpruningPathToAbsorber(stack), stack);
            }
            return fromEmitter.getTarget();
        }
        return null;
    }

    protected void navigateToEmitter(AbstractElement ele, INode node) {
        SyntacticalContext ctx = this.contexts.peek();
        ctx.lastState = this.navigateToEmitter(ctx.lastState, ctx.getLastNode(), ele, node, ctx.stack);
        ctx.setLastNode(node);
    }

    protected ISyntacticSequencerPDAProvider.ISynFollowerOwner navigateToEmitter(ISyntacticSequencerPDAProvider.ISynFollowerOwner fromState, INode fromNode, AbstractElement toEle, INode toNode, RuleCallStack stack) {
        if (fromState instanceof ISyntacticSequencerPDAProvider.ISynAbsorberState) {
            return fromState;
        }
        if (fromState instanceof ISyntacticSequencerPDAProvider.ISynNavigable) {
            ISyntacticSequencerPDAProvider.ISynNavigable fromEmitter = (ISyntacticSequencerPDAProvider.ISynNavigable)fromState;
            if (!fromEmitter.hasEmitters()) {
                return fromEmitter.getTarget();
            }
            List<ISyntacticSequencerPDAProvider.ISynState> pathAndElement = fromEmitter.getShortestPathTo(toEle, stack);
            if (pathAndElement == null) {
                if (this.errorAcceptor != null) {
                    this.errorAcceptor.accept(this.diagnosticProvider.createUnexpectedEmitterDiagnostic(fromEmitter, toEle, stack));
                }
                return null;
            }
            List<ISyntacticSequencerPDAProvider.ISynState> path = pathAndElement.subList(0, pathAndElement.size() - 1);
            this.accept(fromNode, path, stack);
            return pathAndElement.get(pathAndElement.size() - 1);
        }
        return null;
    }

    protected static class SyntacticalContext {
        protected EObject context;
        private INode lastNode;
        protected ISyntacticSequencerPDAProvider.ISynFollowerOwner lastState;
        protected EObject semanticObject;
        protected RuleCallStack stack;

        public SyntacticalContext(EObject context, EObject semanticObject, ISyntacticSequencerPDAProvider.ISynAbsorberState previousState, INode previousNode) {
            this.context = context;
            this.semanticObject = semanticObject;
            this.lastState = previousState;
            this.lastNode = previousNode;
            this.stack = new RuleCallStack();
        }

        protected INode getLastNode() {
            return this.lastNode;
        }

        protected void setLastNode(INode lastNode) {
            this.lastNode = lastNode;
        }
    }
}

