/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.reconciler;

import org.apache.log4j.Logger;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.reconciler.XtextReconcilerUnitOfWork;

public class XtextDocumentReconcileStrategy
implements IReconcilingStrategy {
    private static final Logger log = Logger.getLogger(XtextDocumentReconcileStrategy.class);
    private XtextDocument document;

    public void reconcile(IRegion region) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("reconcile region: " + region), (Throwable)new Exception());
        }
        this.document.internalModify(new XtextReconcilerUnitOfWork(region, this.document));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void setDocument(IDocument document) {
        if (!(document instanceof XtextDocument)) {
            throw new IllegalArgumentException("Document must be an " + XtextDocument.class.getSimpleName());
        }
        this.document = (XtextDocument)document;
    }
}

