/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.tools.ConvertProjectToPluginOperation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ConvertedProjectsPage
extends WizardPage {
    private CheckboxTableViewer projectViewer;
    private TablePart tablePart;
    private IProject[] fSelected;
    private IProject[] fUnconverted;

    public ConvertedProjectsPage(IProject[] projects, Vector initialSelection) {
        super("convertedProjects");
        this.setTitle(PDEUIMessages.ConvertedProjectWizard_title);
        this.setDescription(PDEUIMessages.ConvertedProjectWizard_desc);
        this.tablePart = new TablePart(PDEUIMessages.ConvertedProjectWizard_projectList);
        this.fSelected = initialSelection.toArray(new IProject[initialSelection.size()]);
        this.fUnconverted = projects;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.projectViewer = this.tablePart.getTableViewer();
        this.projectViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectViewer.setInput((Object)PDEPlugin.getWorkspace());
        this.tablePart.setSelection(this.fSelected);
        this.tablePart.updateCounter(this.fSelected.length);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.converted_projects");
    }

    public boolean finish() {
        Object[] selected = this.tablePart.getSelection();
        IProject[] projectsToConvert = this.castSelectionToProjects(selected);
        try {
            ConvertProjectToPluginOperation convertOperation = new ConvertProjectToPluginOperation(projectsToConvert);
            this.getContainer().run(false, true, (IRunnableWithProgress)convertOperation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    private IProject[] castSelectionToProjects(Object[] selected) {
        if (selected instanceof IProject[]) {
            return (IProject[])selected;
        }
        IProject[] projects = new IProject[selected.length];
        int i = 0;
        while (i < selected.length) {
            projects[i] = (IProject)selected[i];
            ++i;
        }
        return projects;
    }

    public class ProjectContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            if (ConvertedProjectsPage.this.fUnconverted != null) {
                return ConvertedProjectsPage.this.fUnconverted;
            }
            return new Object[0];
        }
    }

    public class ProjectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            if (index == 0) {
                return ((IProject)obj).getName();
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            ConvertedProjectsPage.this.setPageComplete(count > 0);
        }
    }
}

