/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.chart;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.FillChooserComposite;
import org.eclipse.birt.chart.ui.swt.composites.FontDefinitionComposite;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierDialog;
import org.eclipse.birt.chart.ui.swt.composites.FormatSpecifierPreview;
import org.eclipse.birt.chart.ui.swt.composites.InsetsComposite;
import org.eclipse.birt.chart.ui.swt.composites.LineAttributesComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;

public class LegendTextSheet
extends AbstractPopupSheet
implements Listener {
    private transient Composite cmpContent = null;
    private transient FontDefinitionComposite fdcFont = null;
    private transient LineAttributesComposite lineSeparator;
    private transient FillChooserComposite fccBackground;
    private transient FillChooserComposite fccShadow;
    private transient LineAttributesComposite outlineText;
    private transient InsetsComposite icText;
    private transient FormatSpecifierPreview fsp;
    private transient Button btnFormatSpecifier;
    private Spinner spnEllipsis;
    private boolean isByCategory = this.getChart().getLegend().getItemType() != LegendItemType.SERIES_LITERAL;
    private boolean containsYOG = ChartUtil.containsYOptionalGrouping((Chart)this.getChart());

    public LegendTextSheet(String title, ChartWizardContext context) {
        super(title, context, true);
    }

    protected Composite getComponent(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.LegendBlock_ID");
        this.cmpContent = new Composite(parent, 0);
        GridLayout glMain = new GridLayout();
        glMain.horizontalSpacing = 5;
        glMain.verticalSpacing = 5;
        glMain.marginHeight = 7;
        glMain.marginWidth = 7;
        this.cmpContent.setLayout((Layout)glMain);
        Group grpTxtArea = new Group(this.cmpContent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        grpTxtArea.setLayout((Layout)layout);
        grpTxtArea.setLayoutData((Object)new GridData(1808));
        grpTxtArea.setText(Messages.getString("MoreOptionsChartLegendSheet.Label.TextArea"));
        Label lblFormat = new Label((Composite)grpTxtArea, 0);
        lblFormat.setText(Messages.getString("DialLabelSheet.Label.Format"));
        Composite cmpFormat = new Composite((Composite)grpTxtArea, 2048);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginWidth = 0;
        layout2.marginHeight = 0;
        layout2.horizontalSpacing = 0;
        cmpFormat.setLayout((Layout)layout2);
        cmpFormat.setLayoutData((Object)new GridData(768));
        cmpFormat.setBackground(cmpFormat.getDisplay().getSystemColor(1));
        this.fsp = new FormatSpecifierPreview(cmpFormat, 0, false);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 0x1000000;
        this.fsp.setLayoutData(gd);
        this.fsp.updatePreview(this.getChart().getLegend().getFormatSpecifier());
        this.btnFormatSpecifier = new Button(cmpFormat, 8);
        gd = new GridData();
        this.btnFormatSpecifier.setLayoutData((Object)gd);
        this.btnFormatSpecifier.setToolTipText(Messages.getString("BaseDataDefinitionComponent.Text.EditFormat"));
        this.btnFormatSpecifier.setText(Messages.getString("Format.Button.Lbl&"));
        this.btnFormatSpecifier.addListener(13, (Listener)this);
        new Label((Composite)grpTxtArea, 0).setText(Messages.getString("LegendTextSheet.Label.Font"));
        this.fdcFont = new FontDefinitionComposite((Composite)grpTxtArea, 0, this.getContext(), this.getLegend().getText().getFont(), this.getLegend().getText().getColor(), false);
        GridData gdFDCFont = new GridData(768);
        gdFDCFont.widthHint = this.fdcFont.getPreferredSize().x;
        gdFDCFont.grabExcessVerticalSpace = false;
        this.fdcFont.setLayoutData(gdFDCFont);
        this.fdcFont.addListener(this);
        new Label((Composite)grpTxtArea, 0).setText(Messages.getString("LegendTextSheet.Label.Ellipsis"));
        this.spnEllipsis = new Spinner((Composite)grpTxtArea, 2048);
        GridData gd2 = new GridData(768);
        this.spnEllipsis.setLayoutData((Object)gd2);
        this.spnEllipsis.setMinimum(0);
        this.spnEllipsis.setSelection(this.getLegend().getEllipsis());
        this.spnEllipsis.setToolTipText(Messages.getString("LegendTextSheet.Tooltip.Ellipsis"));
        this.spnEllipsis.addListener(13, (Listener)this);
        Label lblShadow = new Label((Composite)grpTxtArea, 0);
        GridData gdLBLShadow = new GridData();
        lblShadow.setLayoutData((Object)gdLBLShadow);
        lblShadow.setText(Messages.getString("ClientAreaAttributeComposite.Lbl.Shadow"));
        this.fccShadow = new FillChooserComposite((Composite)grpTxtArea, 0, this.getContext(), (Fill)this.getLegend().getClientArea().getShadowColor(), false, false, false);
        GridData gdFCCShadow = new GridData(768);
        this.fccShadow.setLayoutData(gdFCCShadow);
        this.fccShadow.addListener(this);
        Label lblBackground = new Label((Composite)grpTxtArea, 0);
        lblBackground.setText(Messages.getString("Shared.mne.Background_K"));
        this.fccBackground = new FillChooserComposite((Composite)grpTxtArea, 12, this.getContext(), this.getChart().getLegend().getClientArea().getBackground(), true, true);
        GridData gridData = new GridData(768);
        this.fccBackground.setLayoutData(gridData);
        this.fccBackground.addListener(this);
        Group grpOutline = new Group((Composite)grpTxtArea, 0);
        GridData gdGRPOutline = new GridData(768);
        gdGRPOutline.horizontalSpan = 2;
        grpOutline.setLayoutData((Object)gdGRPOutline);
        grpOutline.setLayout((Layout)new FillLayout());
        grpOutline.setText(Messages.getString("MoreOptionsChartLegendSheet.Label.Outline"));
        this.outlineText = new LineAttributesComposite((Composite)grpOutline, 0, this.getContext(), this.getLegend().getClientArea().getOutline(), true, true, true);
        this.outlineText.addListener(this);
        this.outlineText.setAttributesEnabled(true);
        this.icText = new InsetsComposite((Composite)grpTxtArea, 0, this.getLegend().getClientArea().getInsets(), this.getChart().getUnits(), this.getContext().getUIServiceProvider());
        GridData gdInsets = new GridData(768);
        gdInsets.horizontalSpan = 2;
        this.icText.setLayoutData(gdInsets);
        this.icText.addListener(this);
        Group grpSeparator = new Group(this.cmpContent, 0);
        GridLayout layout3 = new GridLayout();
        layout3.marginHeight = 0;
        layout3.marginWidth = 5;
        grpSeparator.setLayout((Layout)layout3);
        grpSeparator.setLayoutData((Object)new GridData(768));
        grpSeparator.setText(Messages.getString("LegendTextSheet.Label.Separator"));
        this.lineSeparator = new LineAttributesComposite((Composite)grpSeparator, 0, this.getContext(), this.getLegend().getSeparator(), true, true, true);
        this.lineSeparator.setLayoutData(new GridData(768));
        this.lineSeparator.addListener(this);
        this.lineSeparator.setAttributesEnabled(true);
        return this.cmpContent;
    }

    public void handleEvent(Event event) {
        FormatSpecifierDialog editor;
        if (event.widget.equals((Object)this.fdcFont)) {
            this.getLegend().getText().setFont((FontDefinition)((Object[])event.data)[0]);
            this.getLegend().getText().setColor((ColorDefinition)((Object[])event.data)[1]);
        } else if (event.widget == this.spnEllipsis) {
            this.getLegend().setEllipsis(this.spnEllipsis.getSelection());
        } else if (event.widget.equals((Object)this.fccShadow)) {
            this.getLegend().getClientArea().setShadowColor((ColorDefinition)event.data);
        } else if (event.widget.equals((Object)this.fccBackground)) {
            this.getLegend().getClientArea().setBackground((Fill)event.data);
        } else if (event.widget.equals((Object)this.icText)) {
            this.getLegend().getClientArea().setInsets((Insets)event.data);
        } else if (event.widget.equals((Object)this.outlineText)) {
            switch (event.type) {
                case 1: {
                    this.getLegend().getClientArea().getOutline().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.getLegend().getClientArea().getOutline().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.getLegend().getClientArea().getOutline().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    this.getLegend().getClientArea().getOutline().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        } else if (event.widget.equals((Object)this.lineSeparator)) {
            switch (event.type) {
                case 1: {
                    this.getLegend().getSeparator().setStyle((LineStyle)event.data);
                    break;
                }
                case 2: {
                    this.getLegend().getSeparator().setThickness(((Integer)event.data).intValue());
                    break;
                }
                case 3: {
                    this.getLegend().getSeparator().setColor((ColorDefinition)event.data);
                    break;
                }
                case 4: {
                    this.getLegend().getSeparator().setVisible(((Boolean)event.data).booleanValue());
                }
            }
        } else if (event.widget.equals(this.btnFormatSpecifier) && (editor = new FormatSpecifierDialog(this.cmpContent.getShell(), this.getChart().getLegend().getFormatSpecifier(), this.getEntryType(), Messages.getString("BaseDataDefinitionComponent.Text.EditFormat"))).open() == 0) {
            this.getChart().getLegend().setFormatSpecifier(editor.getFormatSpecifier());
            this.fsp.updatePreview(editor.getFormatSpecifier());
        }
    }

    private Legend getLegend() {
        return this.getChart().getLegend();
    }

    private AxisType getEntryType() {
        DataType type = DataType.TEXT_LITERAL;
        if (this.isByCategory) {
            type = this.getCategoryQueryType();
        } else if (this.containsYOG) {
            type = this.getContext().getDataServiceProvider().getDataType(ChartUtil.getYOptoinalExpressions((Chart)this.getChart())[0]);
        }
        if (type == DataType.NUMERIC_LITERAL) {
            return AxisType.LINEAR_LITERAL;
        }
        if (type == DataType.DATE_TIME_LITERAL) {
            return AxisType.DATE_TIME_LITERAL;
        }
        return AxisType.TEXT_LITERAL;
    }

    private DataType getCategoryQueryType() {
        String query = ChartUIUtil.getDataQuery((SeriesDefinition)((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)this.getChart()).get(0)), (int)0).getDefinition();
        return this.getContext().getDataServiceProvider().getDataType(query);
    }
}

