/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing.ares.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.amp.amf.testing.aTest.Constraint;
import org.eclipse.amp.amf.testing.ares.AresPackage;
import org.eclipse.amp.amf.testing.ares.ConstraintTest;
import org.eclipse.amp.amf.testing.ares.Issue;
import org.eclipse.amp.amf.testing.ares.provider.AresEditPlugin;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ConstraintTestItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ConstraintTestItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addConstraintPropertyDescriptor(object);
            this.addIssuePropertyDescriptor(object);
            this.addActualValuePropertyDescriptor(object);
            this.addFailurePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addConstraintPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ConstraintTest_constraint_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ConstraintTest_constraint_feature", "_UI_ConstraintTest_type"), (EStructuralFeature)AresPackage.Literals.CONSTRAINT_TEST__CONSTRAINT, true, false, true, null, null, null));
    }

    protected void addIssuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ConstraintTest_issue_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ConstraintTest_issue_feature", "_UI_ConstraintTest_type"), (EStructuralFeature)AresPackage.Literals.CONSTRAINT_TEST__ISSUE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addActualValuePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ConstraintTest_actualValue_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ConstraintTest_actualValue_feature", "_UI_ConstraintTest_type"), (EStructuralFeature)AresPackage.Literals.CONSTRAINT_TEST__ACTUAL_VALUE, true, false, false, ItemPropertyDescriptor.REAL_VALUE_IMAGE, null, null));
    }

    protected void addFailurePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ConstraintTest_failure_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ConstraintTest_failure_feature", "_UI_ConstraintTest_type"), (EStructuralFeature)AresPackage.Literals.CONSTRAINT_TEST__FAILURE, false, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        ConstraintTest item = (ConstraintTest)object;
        if (item.getIssue() == Issue.ABOVE_RANGE) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/MaxExclusive"));
        }
        if (item.getIssue() == Issue.BELOW_RANGE) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/MinExclusive"));
        }
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Success"));
    }

    public String getText(Object object) {
        ConstraintTest item = (ConstraintTest)object;
        Constraint constraint = item.getConstraint();
        String label = constraint.getMeasure() != null ? constraint.getMeasure() + " " : "";
        label = String.valueOf(label) + (constraint.getAttribute() != null ? String.valueOf(constraint.getAttribute().getLabel()) + " " : "");
        label = String.valueOf(label) + (constraint.getQualifier() != null ? String.valueOf(constraint.getQualifier().getLabel()) + " " : "");
        label = String.valueOf(label) + item.getActualValue() + " ";
        label = item.getIssue() == Issue.NONE ? String.valueOf(label) + "IN [" : (item.getIssue() == Issue.ABOVE_RANGE ? String.valueOf(label) + "> [" : (item.getIssue() == Issue.BELOW_RANGE ? String.valueOf(label) + "< [" : String.valueOf(label) + "ERROR"));
        label = String.valueOf(label) + (constraint.getMinValue() != null ? constraint.getMinValue() + ", " : "");
        label = String.valueOf(label) + (constraint.getMaxValue() != null ? constraint.getMaxValue() + "]" : "");
        return label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ConstraintTest.class)) {
            case 1: 
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return AresEditPlugin.INSTANCE;
    }
}

