/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.matcher;

import java.util.Collection;
import java.util.List;

public interface IMatchesName<T> {
    public static final IMatchesName<List<String>> NAME_MATCHER = new IMatchesName<List<String>>(){

        @Override
        public boolean match(Collection<String> identifers, List<String> scopes) {
            if (scopes.size() < identifers.size()) {
                return false;
            }
            IntegerHolder lastIndex = new IntegerHolder();
            return identifers.stream().allMatch(identifier -> {
                int i = integerHolder.value;
                while (i < scopes.size()) {
                    if (this.scopesAreMatching((String)scopes.get(i), (String)identifier)) {
                        integerHolder.value = i + 1;
                        return true;
                    }
                    ++i;
                }
                return false;
            });
        }

        private boolean scopesAreMatching(String thisScopeName, String scopeName) {
            if (thisScopeName == null) {
                return false;
            }
            if (thisScopeName.equals(scopeName)) {
                return true;
            }
            int len = scopeName.length();
            return thisScopeName.length() > len && thisScopeName.substring(0, len).equals(scopeName) && thisScopeName.charAt(len) == '.';
        }
    };

    public boolean match(Collection<String> var1, T var2);

    public static class IntegerHolder {
        public int value = 0;
    }
}

