/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import java.util.List;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.ScopeStack;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceSerializer;

public abstract class AbstractStringBuilderBasedAppendable
implements IAppendable {
    private StringBuilder builder = new StringBuilder(8192);
    private int indentationlevel = 0;
    private String indentation = "  ";
    private String lineSeparator = "\n";
    private boolean isJava;
    private GeneratorConfig generatorConfig;
    private LightweightTypeReferenceSerializer lightweightTypeReferenceSerializer;
    private ScopeStack scopes = new ScopeStack();

    public AbstractStringBuilderBasedAppendable(String indentation, String lineSeparator, boolean isJava) {
        this.indentation = indentation;
        this.lineSeparator = lineSeparator;
        this.isJava = isJava;
        this.lightweightTypeReferenceSerializer = this.createLightweightTypeReferenceSerializer();
        this.openScope();
    }

    public AbstractStringBuilderBasedAppendable(boolean isJava) {
        this.isJava = isJava;
        this.lightweightTypeReferenceSerializer = this.createLightweightTypeReferenceSerializer();
        this.openScope();
    }

    @Override
    public boolean isJava() {
        return this.isJava;
    }

    @Override
    public IAppendable append(JvmType type) {
        this.appendType(type, this.builder);
        return this;
    }

    public IAppendable append(Class<?> type) {
        this.appendType(type, this.builder);
        return this;
    }

    @Override
    public IAppendable append(LightweightTypeReference typeRef) {
        typeRef.accept(this.lightweightTypeReferenceSerializer);
        return this;
    }

    protected LightweightTypeReferenceSerializer createLightweightTypeReferenceSerializer() {
        return new LightweightTypeReferenceSerializer(this);
    }

    @Override
    public IAppendable append(CharSequence string) {
        String replaced = string.toString().replace(this.lineSeparator, this.getIndentationString());
        this.builder.append(replaced);
        return this;
    }

    @Override
    public IAppendable newLine() {
        this.builder.append(this.getIndentationString());
        return this;
    }

    protected CharSequence getIndentationString() {
        StringBuilder sb = new StringBuilder(10);
        sb.append(this.lineSeparator);
        int i = 0;
        while (i < this.indentationlevel) {
            sb.append(this.indentation);
            ++i;
        }
        return sb.toString();
    }

    protected int getIndentationLevel() {
        return this.indentationlevel;
    }

    @Override
    public String toString() {
        return this.builder.toString();
    }

    @Override
    public String getContent() {
        return this.toString();
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public IAppendable increaseIndentation() {
        ++this.indentationlevel;
        return this;
    }

    @Override
    public IAppendable decreaseIndentation() {
        if (this.indentationlevel == 0) {
            throw new IllegalStateException("Can't reduce indentation level. It's already zero.");
        }
        --this.indentationlevel;
        return this;
    }

    public void setScopeStack(ScopeStack scopes) {
        this.scopes = scopes;
    }

    @Override
    public void openScope() {
        this.scopes.openScope(false);
    }

    @Override
    public void openPseudoScope() {
        this.scopes.openScope(true);
    }

    @Override
    public String declareVariable(Object key, String proposedName) {
        return this.scopes.declareVariable(key, proposedName, false, false);
    }

    @Override
    public String declareSyntheticVariable(Object key, String proposedName) {
        return this.scopes.declareVariable(key, proposedName, true, false);
    }

    @Override
    public String declareUniqueNameVariable(Object key, String proposedName) {
        return this.scopes.declareVariable(key, proposedName, false, true);
    }

    @Override
    public void closeScope() {
        this.scopes.closeScope();
    }

    @Override
    public String removeName(Object key) {
        return this.scopes.removeName(key);
    }

    protected abstract void appendType(JvmType var1, StringBuilder var2);

    protected abstract void appendType(Class<?> var1, StringBuilder var2);

    @Override
    @Deprecated
    public abstract List<String> getImports();

    @Override
    public String getName(Object key) {
        String result = this.scopes.getName(key);
        if (result == null) {
            throw new IllegalStateException("Cannot get name for " + String.valueOf(key));
        }
        return result;
    }

    @Override
    public boolean hasName(Object key) {
        return this.scopes.getName(key) != null;
    }

    @Override
    public Object getObject(String name) {
        Object result = this.scopes.get(name);
        if (result == null) {
            throw new IllegalStateException("Cannot get object for " + name);
        }
        return result;
    }

    @Override
    public boolean hasObject(String name) {
        return this.scopes.get(name) != null;
    }

    protected String getLineSeparator() {
        return this.lineSeparator;
    }

    public char charAt(int index) {
        return this.builder.charAt(index);
    }

    public CharSequence subSequence(int start, int end) {
        return this.builder.subSequence(start, end);
    }

    @Override
    public GeneratorConfig getGeneratorConfig() {
        return this.generatorConfig;
    }

    public void setGeneratorConfig(GeneratorConfig config) {
        this.generatorConfig = config;
    }
}

