/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.CFBInstanceImpl;
import org.eclipse.fordiac.ide.model.libraryElement.impl.SubAppImpl;

public class Utils {
    private Utils() {
    }

    public static Map<String, Set<String>> collectAllPorts(Device device) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Resource resource : device.getResource()) {
            result.put(resource.getName(), new HashSet());
            Utils.collectAllPorts(resource, result);
        }
        for (Application application : device.getAutomationSystem().getApplication()) {
            Utils.collectAllPorts(application, result);
        }
        return result;
    }

    private static void collectAllPorts(Resource resource, Map<String, Set<String>> result) {
        Utils.collectAllPorts(resource.getFBNetwork(), result);
    }

    private static void collectAllPorts(Application application, Map<String, Set<String>> result) {
        Utils.collectAllPorts(application.getFBNetwork(), result);
    }

    private static void collectAllPorts(FBNetwork network, Map<String, Set<String>> result) {
        if (network == null) {
            return;
        }
        network.getBlockFBNetworkElements().forEach(networkElement -> {
            Utils.collectAllPorts(networkElement.getInterface(), result);
            if (networkElement instanceof CFBInstanceImpl) {
                CFBInstanceImpl composite = (CFBInstanceImpl)networkElement;
                Utils.collectAllPorts(composite.loadCFBNetwork(), result);
            } else if (networkElement instanceof SubAppImpl) {
                SubAppImpl subApp = (SubAppImpl)networkElement;
                Utils.collectAllPorts(subApp.loadSubAppNetwork(), result);
            }
        });
    }

    private static void collectAllPorts(InterfaceList interfaceList, Map<String, Set<String>> result) {
        String deviceName = interfaceList.getBlockFBNetworkElement().getResource().getDevice().getName();
        String resourceName = interfaceList.getBlockFBNetworkElement().getResource().getName();
        String prefix = deviceName + "." + resourceName + ".";
        for (Event event : interfaceList.getEventInputs()) {
            Utils.addElementToResult((INamedElement)event, result.get(resourceName), prefix);
        }
        for (Event event : interfaceList.getEventOutputs()) {
            Utils.addElementToResult((INamedElement)event, result.get(resourceName), prefix);
        }
        for (VarDeclaration variable : interfaceList.getInputVars()) {
            Utils.addElementToResult((INamedElement)variable, result.get(resourceName), prefix);
        }
        for (VarDeclaration variable : interfaceList.getOutputVars()) {
            Utils.addElementToResult((INamedElement)variable, result.get(resourceName), prefix);
        }
    }

    private static void addElementToResult(INamedElement element, Set<String> result, String prefix) {
        String toAdd = element.getQualifiedName();
        if (toAdd.startsWith(prefix)) {
            toAdd = toAdd.substring(prefix.length());
        }
        result.add(toAdd);
    }
}

