/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.application.commands.NewSubAppCommand;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.ChangeContractCommand;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.change.ToggleSubAppRepresentationCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateConnectionAtSubappInterfaceCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.MappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.gef.commands.Command;

public class PrepareContractCommand
extends Command {
    private static final String ATTRIBUTE_NAME = "_SUBAPP_CONTRACT";
    private static final int NEW_SUBAPP_WIDTH = 900;
    private static final int NEW_SUBAPP_HEIGHT = 400;
    private final FBNetworkElement fbNetworkElement;
    private final List<Event> iPins;
    private final List<Event> oPins;
    private final String contract;
    private NewSubAppCommand subappcmd;
    private ChangeContractCommand contractcmd;
    private ToggleSubAppRepresentationCommand togglecmd;
    private Command mappingcmd;
    private List<Command> connectioncmds;

    public PrepareContractCommand(FBNetworkElement fbNetworkElement, List<Event> iPins, List<Event> oPins, String contract) {
        this.fbNetworkElement = fbNetworkElement;
        this.iPins = iPins;
        this.oPins = oPins;
        this.contract = contract;
    }

    public void execute() {
        SubApp subapp = this.createNewSubapp();
        String oldContract = subapp.getAttributeValue(ATTRIBUTE_NAME);
        String ctrct = this.contract;
        if (oldContract != null && !oldContract.isEmpty()) {
            StringBuilder sb = new StringBuilder(oldContract);
            sb.append(System.lineSeparator());
            sb.append(ctrct);
            ctrct = sb.toString();
        }
        this.contractcmd = new ChangeContractCommand(subapp, ctrct);
        if (this.contractcmd.canExecute()) {
            this.contractcmd.execute();
        }
    }

    public void undo() {
        this.contractcmd.undo();
        if (this.mappingcmd != null) {
            this.mappingcmd.undo();
        }
        if (this.connectioncmds != null) {
            for (Command cmd : this.connectioncmds) {
                cmd.undo();
            }
        }
        if (this.togglecmd != null) {
            this.togglecmd.undo();
        }
        if (this.subappcmd != null) {
            this.subappcmd.undo();
        }
    }

    public void redo() {
        if (this.subappcmd != null) {
            this.subappcmd.redo();
        }
        if (this.togglecmd != null) {
            this.togglecmd.redo();
        }
        if (this.connectioncmds != null) {
            for (Command cmd : this.connectioncmds) {
                cmd.undo();
            }
        }
        if (this.mappingcmd != null) {
            this.mappingcmd.redo();
        }
        this.contractcmd.redo();
    }

    private SubApp createNewSubapp() {
        SubApp subapp;
        SubApp s;
        FBNetworkElement fBNetworkElement = this.fbNetworkElement;
        if (fBNetworkElement instanceof SubApp && !(s = (SubApp)fBNetworkElement).isTyped()) {
            subapp = s;
        } else if (this.fbNetworkElement.isNestedInSubApp()) {
            subapp = (SubApp)this.fbNetworkElement.eContainer().eContainer();
            this.createConnectionsToSubApp(subapp);
        } else {
            Resource resource;
            FBNetwork network = this.fbNetworkElement.getFbNetwork();
            Position pos = this.fbNetworkElement.getPosition();
            ArrayList<FBNetworkElement> list = new ArrayList<FBNetworkElement>();
            list.add(this.fbNetworkElement);
            this.subappcmd = new NewSubAppCommand(network, list, pos);
            if (this.subappcmd.canExecute()) {
                this.subappcmd.execute();
            }
            subapp = this.subappcmd.getElement();
            subapp.setWidth(CoordinateConverter.INSTANCE.screenToIEC61499(900));
            subapp.setHeight(CoordinateConverter.INSTANCE.screenToIEC61499(400));
            this.createConnectionsToSubApp(subapp);
            Resource resource2 = resource = this.fbNetworkElement.isMapped() ? this.fbNetworkElement.getResource() : null;
            if (resource != null) {
                this.mappingcmd = MapToCommand.createMapToCommand((FBNetworkElement)subapp, (MappingTarget)resource);
                if (this.mappingcmd.canExecute()) {
                    this.mappingcmd.execute();
                }
            }
        }
        if (!subapp.isUnfolded()) {
            this.togglecmd = new ToggleSubAppRepresentationCommand(subapp);
            if (this.togglecmd.canExecute()) {
                this.togglecmd.execute();
            }
        }
        return subapp;
    }

    private void createConnectionsToSubApp(SubApp subapp) {
        this.connectioncmds = new ArrayList<Command>();
        this.createConnectionsHelper(this.iPins, subapp);
        this.createConnectionsHelper(this.oPins, subapp);
    }

    private void createConnectionsHelper(List<Event> events, SubApp subapp) {
        for (Event event : events) {
            if (subapp.getInterface().getEvent(event.getName()) != null) continue;
            CreateConnectionAtSubappInterfaceCommand ccc = new CreateConnectionAtSubappInterfaceCommand((IInterfaceElement)event, subapp);
            if (ccc.canExecute()) {
                ccc.execute();
            }
            this.connectioncmds.add((Command)ccc);
        }
    }
}

