/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.ViewPaneRenderingMgr;
import org.eclipse.debug.internal.ui.views.memory.renderings.CreateRendering;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.debug.ui.memory.IResettableMemoryRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class RenderingViewPane
extends AbstractMemoryViewPane
implements IMemoryRenderingContainer {
    public static final String RENDERING_VIEW_PANE_ID = DebugUIPlugin.getUniqueIdentifier() + ".MemoryView.RenderingViewPane";
    private Hashtable<IMemoryBlock, CTabFolder> fTabFolderForMemoryBlock = new Hashtable();
    private Hashtable<CTabFolder, IMemoryBlock> fMemoryBlockFromTabFolder = new Hashtable();
    private ViewPaneRenderingMgr fRenderingMgr;
    private IMemoryRenderingSite fRenderingSite;
    private final Set<IMemoryRendering> fAddedRenderings = new HashSet<IMemoryRendering>();
    private final Set<IMemoryBlock> fAddedMemoryBlocks = new HashSet<IMemoryBlock>();
    private boolean fCanAddRendering = true;
    private boolean fCanRemoveRendering = true;

    public RenderingViewPane(IViewPart parent) {
        super(parent);
        if (parent instanceof IMemoryRenderingSite) {
            this.fRenderingSite = (IMemoryRenderingSite)parent;
        } else {
            DebugUIPlugin.logErrorMessage("Parent for the rendering view pane is invalid.");
        }
    }

    @Override
    public void memoryBlocksAdded(IMemoryBlock[] memoryBlocks) {
        Display.getDefault().asyncExec(() -> {
            if (this.isDisposed()) {
                return;
            }
            if (memoryBlocks == null || memoryBlocks.length <= 0) {
                return;
            }
            IMemoryBlock[] iMemoryBlockArray2 = memoryBlocks;
            int n = memoryBlocks.length;
            int n2 = 0;
            while (n2 < n) {
                IMemoryBlock memory = iMemoryBlockArray2[n2];
                if (!this.fTabFolderForMemoryBlock.containsKey(memory)) {
                    this.createFolderForMemoryBlock(memory);
                }
                this.fAddedMemoryBlocks.add(memory);
                this.updateToolBarActionsEnablement();
                ++n2;
            }
        });
    }

    @Override
    public void memoryBlocksRemoved(IMemoryBlock[] memoryBlocks) {
        Display.getDefault().asyncExec(() -> {
            IMemoryBlock[] iMemoryBlockArray2 = memoryBlocks;
            int n = memoryBlocks.length;
            int n2 = 0;
            while (n2 < n) {
                IMemoryRendering[] renderings;
                IMemoryBlock mbRemoved = iMemoryBlockArray2[n2];
                if (this.fTabFolderForMemoryBlock == null) {
                    return;
                }
                IMemoryRendering[] iMemoryRenderingArray = renderings = this.fRenderingMgr.getRenderingsFromMemoryBlock(mbRemoved);
                int n3 = renderings.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemoryRendering rendering = iMemoryRenderingArray[n4];
                    this.removeMemoryRendering(rendering);
                    ++n4;
                }
                CTabFolder tabFolder = this.fTabFolderForMemoryBlock.get(mbRemoved);
                if (tabFolder != null) {
                    this.fTabFolderForMemoryBlock.remove(mbRemoved);
                    this.fMemoryBlockFromTabFolder.remove(tabFolder);
                    IMemoryBlockRetrieval retrieve = MemoryViewUtil.getMemoryBlockRetrieval(mbRemoved);
                    if (retrieve != null && this.fTabFolderForDebugView.contains(tabFolder)) {
                        this.fTabFolderForDebugView.remove(MemoryViewUtil.getHashCode(retrieve));
                    }
                    if (!tabFolder.isDisposed()) {
                        CTabItem[] items;
                        CTabItem[] cTabItemArray = items = tabFolder.getItems();
                        int n5 = items.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            CTabItem item = cTabItemArray[n6];
                            this.disposeTab(item);
                            ++n6;
                        }
                        tabFolder.dispose();
                        if (tabFolder == this.fStackLayout.topControl) {
                            ISelection selection = DebugUIPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.MemoryView");
                            IMemoryBlock mbToSelect = this.getMemoryBlock(selection);
                            if (mbToSelect != null) {
                                if (mbToSelect != mbRemoved) {
                                    this.handleMemoryBlockSelection(null, mbToSelect);
                                } else if (MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve).length > 0) {
                                    mbToSelect = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve)[0];
                                    this.handleMemoryBlockSelection(null, mbToSelect);
                                } else {
                                    this.emptyFolder();
                                }
                            } else if (MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve).length > 0) {
                                mbToSelect = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve)[0];
                                this.handleMemoryBlockSelection(null, mbToSelect);
                            } else {
                                this.emptyFolder();
                            }
                        }
                    }
                    this.fAddedMemoryBlocks.remove(mbRemoved);
                    this.updateToolBarActionsEnablement();
                }
                ++n2;
            }
        });
    }

    @Override
    public void selectionChanged(final IWorkbenchPart part, final ISelection selection) {
        if (this.isDisposed()) {
            return;
        }
        if (part == this) {
            return;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        if (selection == AbstractMemoryViewPane.EMPTY) {
            return;
        }
        UIJob job = new UIJob("RenderingViewPane selectionChanged"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (RenderingViewPane.this.isDisposed()) {
                        return Status.OK_STATUS;
                    }
                    if (selection.isEmpty()) {
                        if (part.getSite().getId().equals("org.eclipse.debug.ui.MemoryView") && part == RenderingViewPane.this.getMemoryRenderingSite().getSite().getPart()) {
                            IMemoryViewTab lastViewTab = RenderingViewPane.this.getTopMemoryTab();
                            if (lastViewTab != null) {
                                lastViewTab.setEnabled(false);
                            }
                            RenderingViewPane.this.emptyFolder();
                        }
                        return Status.OK_STATUS;
                    }
                    IMemoryViewTab lastViewTab = RenderingViewPane.this.getTopMemoryTab();
                    if (!(selection instanceof IStructuredSelection)) {
                        return Status.OK_STATUS;
                    }
                    Object elem = ((IStructuredSelection)selection).getFirstElement();
                    if (elem instanceof IMemoryBlock) {
                        IMemoryBlock memBlock = (IMemoryBlock)elem;
                        if (part == RenderingViewPane.this.getMemoryRenderingSite()) {
                            if (RenderingViewPane.this.fTabFolderForMemoryBlock == null) {
                                if (lastViewTab != null) {
                                    lastViewTab.setEnabled(false);
                                }
                                RenderingViewPane.this.emptyFolder();
                                return Status.OK_STATUS;
                            }
                            RenderingViewPane.this.handleMemoryBlockSelection(lastViewTab, memBlock);
                        }
                    }
                }
                catch (SWTException se) {
                    DebugUIPlugin.log(se);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void handleMemoryBlockSelection(IMemoryViewTab lastViewTab, IMemoryBlock memBlock) {
        IMemoryViewTab viewTab;
        IMemoryBlock currentBlk;
        CTabFolder currentFolder = (CTabFolder)this.fStackLayout.topControl;
        if (currentFolder != null && !currentFolder.isDisposed() && (currentBlk = this.fMemoryBlockFromTabFolder.get(currentFolder)) != null && currentBlk == memBlock) {
            return;
        }
        if (this.getTopMemoryTab() != null && this.getTopMemoryTab().getRendering().getMemoryBlock() == memBlock) {
            return;
        }
        if (this.fTabFolderForMemoryBlock.containsKey(memBlock)) {
            if (this.fStackLayout.topControl != this.fTabFolderForMemoryBlock.get(memBlock)) {
                this.setTabFolder(this.fTabFolderForMemoryBlock.get(memBlock));
                this.fViewPaneCanvas.layout();
            }
        } else {
            CTabFolder folder = this.createTabFolder(this.fViewPaneCanvas);
            this.fTabFolderForMemoryBlock.put(memBlock, folder);
            this.fMemoryBlockFromTabFolder.put(folder, memBlock);
            this.setTabFolder(this.fTabFolderForMemoryBlock.get(memBlock));
            this.fViewPaneCanvas.layout();
            this.fAddedMemoryBlocks.add(memBlock);
            this.newCreateRenderingForFolder(memBlock, folder);
        }
        IMemoryRendering[] renderings = this.fRenderingMgr.getRenderingsFromMemoryBlock(memBlock);
        CTabFolder toDisplay = (CTabFolder)this.fStackLayout.topControl;
        if (this.isRestoreViewTabs(toDisplay)) {
            this.restoreViewTabs(renderings);
        }
        IMemoryViewTab newViewTab = this.getTopMemoryTab();
        if (lastViewTab != null && lastViewTab != newViewTab) {
            lastViewTab.setEnabled(false);
        }
        if (newViewTab != null && !newViewTab.isEnabled() && this.fVisible) {
            newViewTab.setEnabled(this.fVisible);
        }
        if ((viewTab = this.getTopMemoryTab()) != null) {
            this.setRenderingSelection(viewTab.getRendering());
        }
        this.updateToolBarActionsEnablement();
    }

    private boolean isRestoreViewTabs(CTabFolder folder) {
        if (this.canAddRendering()) {
            return folder.getItemCount() == 1 && this.getTopMemoryTab().getRendering() instanceof CreateRendering;
        }
        return folder.getItemCount() == 0;
    }

    private int getIndexOfCreateRenderingTab(CTabFolder folder) {
        int i = 0;
        while (i < folder.getItemCount()) {
            if (folder.getItem(i).getData() instanceof MemoryViewTab && ((MemoryViewTab)folder.getItem(i).getData()).getRendering() instanceof CreateRendering) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void memoryBlockRenderingAdded(IMemoryRendering rendering) {
        Display.getDefault().asyncExec(() -> {
            if (this.isDisposed()) {
                return;
            }
            if (this.fAddedRenderings.contains(rendering)) {
                return;
            }
            IMemoryBlock memoryblk = rendering.getMemoryBlock();
            CTabFolder tabFolder = this.fTabFolderForMemoryBlock.get(memoryblk);
            if (tabFolder == null) {
                tabFolder = this.createFolderForMemoryBlock(memoryblk);
            }
            if (tabFolder == this.fStackLayout.topControl && this.getTopMemoryTab() != null) {
                this.deactivateRendering(this.getTopMemoryTab());
                this.getTopMemoryTab().setEnabled(false);
            }
            this.fAddedRenderings.add(rendering);
            int index = this.getIndexOfCreateRenderingTab(tabFolder);
            if (index < 0) {
                index = 0;
            }
            CTabItem tab = this.createTab(tabFolder, index);
            MemoryViewTab viewTab = new MemoryViewTab(tab, rendering, this.getInstance());
            tabFolder.setSelection(tabFolder.indexOf(tab));
            if (tabFolder == this.fStackLayout.topControl) {
                this.setRenderingSelection(viewTab.getRendering());
                IMemoryViewTab top = this.getTopMemoryTab();
                if (top != null) {
                    top.setEnabled(this.fVisible);
                }
            } else {
                this.deactivateRendering(viewTab);
                viewTab.setEnabled(false);
            }
            this.updateToolBarActionsEnablement();
        });
    }

    public void memoryBlockRenderingRemoved(IMemoryRendering rendering) {
        IMemoryBlock memory = rendering.getMemoryBlock();
        Display.getDefault().asyncExec(() -> {
            IMemoryViewTab top;
            if (!this.fAddedRenderings.contains(rendering)) {
                return;
            }
            this.fAddedRenderings.remove(rendering);
            CTabFolder tabFolder = (CTabFolder)this.fStackLayout.topControl;
            if (tabFolder.isDisposed()) {
                return;
            }
            CTabItem[] tabs = tabFolder.getItems();
            boolean foundTab = false;
            CTabItem[] cTabItemArray = tabs;
            int n = tabs.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem tab = cTabItemArray[n2];
                IMemoryViewTab viewTab1 = (IMemoryViewTab)tab.getData();
                if (!tab.isDisposed() && viewTab1.getRendering().getMemoryBlock() == memory && viewTab1.getRendering() == rendering) {
                    foundTab = true;
                    this.disposeTab(tab);
                    break;
                }
                ++n2;
            }
            if (!foundTab) {
                Enumeration<CTabFolder> enumeration = this.fTabFolderForMemoryBlock.elements();
                block1: while (enumeration.hasMoreElements()) {
                    CTabFolder otherTabFolder = enumeration.nextElement();
                    tabs = otherTabFolder.getItems();
                    IMemoryViewTab viewTab2 = null;
                    CTabItem[] cTabItemArray2 = tabs;
                    int n3 = tabs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CTabItem tab = cTabItemArray2[n4];
                        viewTab2 = (IMemoryViewTab)tab.getData();
                        if (viewTab2.getRendering().getMemoryBlock() == memory && viewTab2.getRendering() == rendering) {
                            foundTab = true;
                            this.disposeTab(tab);
                            continue block1;
                        }
                        ++n4;
                    }
                }
            }
            if ((top = this.getTopMemoryTab()) != null) {
                this.setRenderingSelection(top.getRendering());
            }
            this.updateToolBarActionsEnablement();
        });
    }

    protected void setRenderingSelection(IMemoryRendering rendering) {
        if (rendering != null) {
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)rendering));
        }
    }

    private void restoreViewTabs(IMemoryRendering[] renderings) {
        IMemoryRendering[] iMemoryRenderingArray = renderings;
        int n = renderings.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRendering rendering = iMemoryRenderingArray[n2];
            this.memoryBlockRenderingAdded(rendering);
            ++n2;
        }
    }

    private void handleDebugElementSelection(IMemoryViewTab lastViewTab, IAdaptable element) {
        IMemoryBlockRetrieval retrieve;
        IMemoryBlockRetrieval currentRetrieve = null;
        CTabFolder tabFolder = (CTabFolder)this.fStackLayout.topControl;
        IMemoryBlock currentBlock = this.fMemoryBlockFromTabFolder.get(tabFolder);
        if (currentBlock != null && (currentRetrieve = MemoryViewUtil.getMemoryBlockRetrieval(currentBlock)) != null && tabFolder != null) {
            this.fTabFolderForDebugView.put(MemoryViewUtil.getHashCode(currentRetrieve), tabFolder);
        }
        if ((retrieve = MemoryViewUtil.getMemoryBlockRetrieval(element)) != null && retrieve != currentRetrieve) {
            Integer key = MemoryViewUtil.getHashCode(retrieve);
            CTabFolder folder = (CTabFolder)this.fTabFolderForDebugView.get(key);
            if (folder != null) {
                this.setTabFolder(folder);
                this.fTabFolderForDebugView.put(key, folder);
                this.fViewPaneCanvas.layout();
            } else {
                IMemoryBlock[] blocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve);
                if (blocks.length > 0) {
                    this.handleMemoryBlockSelection(null, blocks[0]);
                } else {
                    this.emptyFolder();
                    this.fTabFolderForDebugView.put(key, this.fEmptyTabFolder);
                    this.fViewPaneCanvas.layout();
                }
            }
        }
        IMemoryViewTab newViewTab = this.getTopMemoryTab();
        if (lastViewTab != null && lastViewTab != newViewTab) {
            lastViewTab.setEnabled(false);
        }
        if (newViewTab != null) {
            if (!newViewTab.isEnabled() && this.fVisible) {
                newViewTab.setEnabled(this.fVisible);
            }
            if (lastViewTab != newViewTab) {
                this.setRenderingSelection(newViewTab.getRendering());
            }
        }
        this.updateToolBarActionsEnablement();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.fParent.getSite().getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    @Override
    protected void removeListeners() {
        super.removeListeners();
        this.fParent.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.getTopMemoryTab() == null) {
            return;
        }
        IMemoryRendering rendering = this.getTopMemoryTab().getRendering();
        if (rendering != null) {
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)rendering));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    public Object getCurrentSelection() {
        if (this.getTopMemoryTab() != null && this.getTopMemoryTab().getRendering() != null) {
            return this.getTopMemoryTab().getRendering();
        }
        return null;
    }

    @Override
    public IMemoryViewTab[] getAllViewTabs() {
        CTabFolder folder = (CTabFolder)this.fStackLayout.topControl;
        CTabItem[] items = folder.getItems();
        IMemoryViewTab[] viewTabs = new IMemoryViewTab[folder.getItemCount()];
        int i = 0;
        while (i < items.length) {
            viewTabs[i] = (IMemoryViewTab)items[i].getData();
            ++i;
        }
        return viewTabs;
    }

    @Override
    public void moveToTop(IMemoryViewTab viewTab) {
        IMemoryViewTab lastViewTab = this.getTopMemoryTab();
        if (viewTab == lastViewTab) {
            return;
        }
        CTabFolder folder = (CTabFolder)this.fStackLayout.topControl;
        CTabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            IMemoryViewTab tab = (IMemoryViewTab)items[i].getData();
            if (viewTab == tab) {
                boolean isEnabled = lastViewTab.isEnabled();
                lastViewTab.setEnabled(false);
                folder.setSelection(i);
                this.setRenderingSelection(tab.getRendering());
                this.getTopMemoryTab().setEnabled(isEnabled && this.fVisible);
                break;
            }
            ++i;
        }
    }

    private CTabFolder createTabFolder(Composite parent) {
        CTabFolder folder = new CTabFolder(parent, 0x900008);
        ColorRegistry reg = JFaceResources.getColorRegistry();
        Color c1 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START");
        Color c2 = reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END");
        folder.setSelectionBackground(new Color[]{c1, c2}, new int[]{100}, true);
        folder.setSelectionForeground(reg.get("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR"));
        folder.setBorderVisible(true);
        folder.setFont(this.fViewPaneCanvas.getFont());
        folder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (event.item.getData() instanceof MemoryViewTab) {
                    RenderingViewPane.this.removeMemoryRendering(((MemoryViewTab)event.item.getData()).getRendering());
                }
                event.doit = false;
            }
        });
        return folder;
    }

    @Override
    public void restoreViewPane() {
        IMemoryBlock[] blocks;
        IMemoryBlockRetrieval retrieval;
        IAdaptable context;
        ISelection selection = null;
        if (this.fParent.getSite().getSelectionProvider() != null) {
            selection = this.fParent.getSite().getSelectionProvider().getSelection();
        }
        IMemoryBlock memoryBlock = null;
        if (selection != null) {
            memoryBlock = this.getMemoryBlock(selection);
        }
        if (memoryBlock == null && MemoryViewUtil.isValidSelection(selection = this.fSelectionProvider.getSelection())) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (!(elem instanceof IMemoryBlock)) {
                return;
            }
            memoryBlock = (IMemoryBlock)elem;
        }
        if (memoryBlock == null && (context = DebugUITools.getPartDebugContext(this.fParent.getSite())) != null && (retrieval = MemoryViewUtil.getMemoryBlockRetrieval(context)) != null && (blocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval)).length > 0) {
            memoryBlock = blocks[0];
        }
        if (memoryBlock != null) {
            IMemoryViewTab top;
            CTabFolder toDisplay;
            if (!this.fTabFolderForMemoryBlock.containsKey(memoryBlock)) {
                CTabFolder folder = this.createTabFolder(this.fViewPaneCanvas);
                this.fTabFolderForMemoryBlock.put(memoryBlock, folder);
                this.fMemoryBlockFromTabFolder.put(folder, memoryBlock);
                this.setTabFolder(this.fTabFolderForMemoryBlock.get(memoryBlock));
                retrieval = MemoryViewUtil.getMemoryBlockRetrieval(memoryBlock);
                if (retrieval != null) {
                    this.fTabFolderForDebugView.put(MemoryViewUtil.getHashCode(retrieval), this.fTabFolderForMemoryBlock.get(memoryBlock));
                } else {
                    DebugUIPlugin.logErrorMessage("Memory block retrieval for memory block is null.");
                }
                this.fViewPaneCanvas.layout();
                this.fAddedMemoryBlocks.add(memoryBlock);
                this.newCreateRenderingForFolder(memoryBlock, folder);
            }
            if (this.fTabFolderForMemoryBlock.containsKey(memoryBlock) && (toDisplay = this.fTabFolderForMemoryBlock.get(memoryBlock)) != null) {
                this.setTabFolder(toDisplay);
                retrieval = MemoryViewUtil.getMemoryBlockRetrieval(memoryBlock);
                if (retrieval != null) {
                    this.fTabFolderForDebugView.put(MemoryViewUtil.getHashCode(retrieval), toDisplay);
                } else {
                    DebugUIPlugin.logErrorMessage("Memory block retrieval is null for memory block.");
                }
                this.fViewPaneCanvas.layout();
                IMemoryRendering[] renderings = this.fRenderingMgr.getRenderingsFromMemoryBlock(memoryBlock);
                if (this.isRestoreViewTabs(toDisplay)) {
                    this.restoreViewTabs(renderings);
                }
            }
            if ((top = this.getTopMemoryTab()) != null) {
                top.setEnabled(this.fVisible);
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fTabFolderForMemoryBlock.clear();
        this.fTabFolderForMemoryBlock = null;
        this.fMemoryBlockFromTabFolder.clear();
        this.fMemoryBlockFromTabFolder = null;
        this.fRenderingMgr.dispose();
        this.fRenderingMgr = null;
        this.fAddedMemoryBlocks.clear();
        this.fAddedRenderings.clear();
    }

    public Control createViewPane(Composite parent, String paneId, String label, boolean canAddRendering, boolean canRemoveRendering) {
        return this.doCreateViewPane(parent, paneId, label, canAddRendering, canRemoveRendering);
    }

    @Override
    public Control createViewPane(Composite parent, String paneId, String label) {
        return this.doCreateViewPane(parent, paneId, label, true, true);
    }

    private Control doCreateViewPane(Composite parent, String paneId, String label, boolean canAddRendering, boolean canRemoveRendering) {
        Control control = super.createViewPane(parent, paneId, label);
        this.fCanAddRendering = canAddRendering;
        this.fCanRemoveRendering = canRemoveRendering;
        this.fRenderingMgr = new ViewPaneRenderingMgr(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.debug.ui.MemoryRenderingView_context");
        return control;
    }

    @Override
    public IAction[] getActions() {
        return new IAction[0];
    }

    protected void updateToolBarActionsEnablement() {
    }

    @Override
    protected void emptyFolder() {
        super.emptyFolder();
        this.updateToolBarActionsEnablement();
        this.fSelectionProvider.setSelection((ISelection)AbstractMemoryViewPane.EMPTY);
    }

    @Override
    public void addMemoryRendering(IMemoryRendering rendering) {
        if (rendering == null) {
            return;
        }
        this.memoryBlockRenderingAdded(rendering);
        this.fRenderingMgr.addMemoryBlockRendering(rendering);
    }

    @Override
    public void removeMemoryRendering(IMemoryRendering rendering) {
        if (rendering == null) {
            return;
        }
        this.memoryBlockRenderingRemoved(rendering);
        if (this.fRenderingMgr != null) {
            this.fRenderingMgr.removeMemoryBlockRendering(rendering);
        }
    }

    private RenderingViewPane getInstance() {
        return this;
    }

    private IMemoryBlock getMemoryBlock(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        if (selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return null;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (elem instanceof IMemoryBlock) {
            return (IMemoryBlock)elem;
        }
        if (elem instanceof IMemoryRendering) {
            return ((IMemoryRendering)elem).getMemoryBlock();
        }
        return null;
    }

    private void deactivateRendering(IMemoryViewTab viewTab) {
        if (viewTab == null) {
            return;
        }
        if (!viewTab.isDisposed()) {
            viewTab.getRendering().deactivated();
        }
    }

    @Override
    public IMemoryRenderingSite getMemoryRenderingSite() {
        return this.fRenderingSite;
    }

    @Override
    public String getId() {
        return this.getPaneId();
    }

    @Override
    public IMemoryRendering[] getRenderings() {
        return this.fRenderingMgr.getRenderings();
    }

    @Override
    public IMemoryRendering getActiveRendering() {
        if (this.getTopMemoryTab() == null) {
            return null;
        }
        return this.getTopMemoryTab().getRendering();
    }

    public void resetRenderings(IMemoryBlock memoryBlock, boolean resetVisible) {
        if (resetVisible && !this.isVisible()) {
            return;
        }
        if (resetVisible) {
            IMemoryRendering rendering = this.getActiveRendering();
            if (rendering != null && rendering.getMemoryBlock() == memoryBlock && rendering instanceof IResettableMemoryRendering) {
                IResettableMemoryRendering resettableRendering = (IResettableMemoryRendering)rendering;
                try {
                    resettableRendering.resetRendering();
                }
                catch (DebugException debugException) {}
            }
        } else {
            IMemoryRendering[] renderings = this.fRenderingMgr.getRenderingsFromMemoryBlock(memoryBlock);
            IMemoryRendering originalProvider = null;
            IMemoryRenderingSynchronizationService service = this.getMemoryRenderingSite().getSynchronizationService();
            if (service != null) {
                originalProvider = service.getSynchronizationProvider();
            }
            IMemoryRendering[] iMemoryRenderingArray = renderings;
            int n = renderings.length;
            int n2 = 0;
            while (n2 < n) {
                IMemoryRendering rendering = iMemoryRenderingArray[n2];
                if (rendering instanceof IResettableMemoryRendering) {
                    try {
                        if (service != null) {
                            service.setSynchronizationProvider(rendering);
                        }
                        ((IResettableMemoryRendering)rendering).resetRendering();
                    }
                    catch (DebugException debugException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (service != null) {
                service.setSynchronizationProvider(originalProvider);
            }
        }
    }

    public void showCreateRenderingTab() {
        IMemoryRendering activeRendering = this.getActiveRendering();
        if (activeRendering == null) {
            return;
        }
        IMemoryBlock memoryblk = activeRendering.getMemoryBlock();
        CTabFolder tabFolder = this.fTabFolderForMemoryBlock.get(memoryblk);
        if (tabFolder != null) {
            Display.getDefault().asyncExec(() -> {
                int index = this.getIndexOfCreateRenderingTab(tabFolder);
                if (index >= 0) {
                    tabFolder.setSelection(index);
                }
            });
        }
    }

    public void contextActivated(final ISelection selection) {
        UIJob job = new UIJob("contextActivated"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (RenderingViewPane.this.isDisposed()) {
                    return Status.OK_STATUS;
                }
                IMemoryViewTab lastViewTab = RenderingViewPane.this.getTopMemoryTab();
                if (MemoryViewUtil.isValidSelection(selection)) {
                    if (!(selection instanceof IStructuredSelection)) {
                        return Status.OK_STATUS;
                    }
                    Object elem = ((IStructuredSelection)selection).getFirstElement();
                    if (elem instanceof IAdaptable) {
                        RenderingViewPane.this.handleDebugElementSelection(lastViewTab, (IAdaptable)elem);
                    }
                } else {
                    if (lastViewTab != null) {
                        lastViewTab.setEnabled(false);
                    }
                    if (RenderingViewPane.this.fStackLayout.topControl != RenderingViewPane.this.fEmptyTabFolder) {
                        RenderingViewPane.this.emptyFolder();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private CTabFolder createFolderForMemoryBlock(IMemoryBlock memory) {
        CTabFolder folder = this.createTabFolder(this.fViewPaneCanvas);
        this.fTabFolderForMemoryBlock.put(memory, folder);
        this.fMemoryBlockFromTabFolder.put(folder, memory);
        IMemoryBlockRetrieval retrieval = MemoryViewUtil.getMemoryBlockRetrieval(memory);
        if (retrieval != null) {
            this.fTabFolderForDebugView.put(MemoryViewUtil.getHashCode(retrieval), folder);
        } else {
            DebugUIPlugin.logErrorMessage("Memory block retrieval for memory block is null");
        }
        this.newCreateRenderingForFolder(memory, folder);
        return folder;
    }

    private void newCreateRenderingForFolder(IMemoryBlock memory, CTabFolder folder) {
        if (!this.canAddRendering()) {
            return;
        }
        CTabItem newItem = new CTabItem(folder, 0);
        CreateRendering rendering = new CreateRendering(this.getInstance());
        rendering.init(this.getInstance(), memory);
        new MemoryViewTab(newItem, rendering, this.getInstance());
        folder.setSelection(0);
    }

    @Override
    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.contextActivated(event.getContext());
        }
    }

    public boolean canAddRendering() {
        return this.fCanAddRendering;
    }

    public boolean canRemoveRendering() {
        return this.fCanRemoveRendering;
    }

    private CTabItem createTab(CTabFolder tabFolder, int index) {
        int swtStyle = 64;
        if (!this.canRemoveRendering()) {
            swtStyle = 0;
        }
        CTabItem tab = new CTabItem(tabFolder, swtStyle, index);
        return tab;
    }
}

