/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p4nodes.LinearSegmentsNodePlacer;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegmentDependency;

public final class DotDebugUtil {
    private DotDebugUtil() {
    }

    public static String createDebugGraph(LGraph lgraph) {
        StringWriter writer = new StringWriter();
        writer.write("digraph {\n");
        writer.write("    rankdir=LR;\n");
        DotDebugUtil.writeLayer(writer, -1, lgraph.getLayerlessNodes());
        int layerNumber = -1;
        for (Layer layer : lgraph) {
            DotDebugUtil.writeLayer(writer, ++layerNumber, layer.getNodes());
        }
        writer.write("}\n");
        return writer.toString();
    }

    public static String createDebugGraph(LGraph layeredGraph, List<LinearSegmentsNodePlacer.LinearSegment> segmentList, List<List<LinearSegmentsNodePlacer.LinearSegment>> outgoingList) {
        StringWriter writer = new StringWriter();
        writer.write("digraph {\n");
        Iterator<LinearSegmentsNodePlacer.LinearSegment> segmentIterator = segmentList.iterator();
        Iterator<List<LinearSegmentsNodePlacer.LinearSegment>> successorsIterator = outgoingList.iterator();
        while (segmentIterator.hasNext()) {
            LinearSegmentsNodePlacer.LinearSegment segment = segmentIterator.next();
            List<LinearSegmentsNodePlacer.LinearSegment> successors = successorsIterator.next();
            writer.write("  " + segment.hashCode() + "[label=\"" + String.valueOf(segment) + "\"]\n");
            for (LinearSegmentsNodePlacer.LinearSegment successor : successors) {
                writer.write("  " + segment.hashCode() + "->" + successor.hashCode() + "\n");
            }
        }
        writer.write("}\n");
        return writer.toString();
    }

    public static String createDebugGraph(LGraph layeredGraph, List<HyperEdgeSegment> hypernodes) {
        StringWriter writer = new StringWriter();
        writer.write("digraph {\n");
        for (HyperEdgeSegment hypernode : hypernodes) {
            writer.write("  " + hypernode.hashCode() + "[label=\"" + hypernode.toString() + "\"]\n");
        }
        for (HyperEdgeSegment hypernode : hypernodes) {
            for (HyperEdgeSegmentDependency dependency : hypernode.getOutgoingSegmentDependencies()) {
                writer.write("  " + hypernode.hashCode() + "->" + dependency.getTarget().hashCode() + "[label=\"" + dependency.getType().name() + " (" + dependency.getWeight() + ")\"]\n");
            }
        }
        writer.write("}\n");
        return writer.toString();
    }

    private static void writeLayer(StringWriter writer, int layerNumber, List<LNode> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        int nodeNumber = -1;
        for (LNode node : nodes) {
            ++nodeNumber;
            writer.write("        " + ((Object)((Object)node)).hashCode());
            StringBuffer options = new StringBuffer();
            options.append("label=\"");
            if (node.getType() == LNode.NodeType.NORMAL) {
                if (node.getDesignation() != null) {
                    options.append(node.getDesignation().replace("\"", "\\\"") + " ");
                }
            } else {
                Object origin;
                if (node.getDesignation() != null) {
                    options.append(node.getDesignation().replace("\"", "\\\"") + " ");
                } else {
                    options.append("n_" + node.id + " ");
                }
                if (node.getType() == LNode.NodeType.NORTH_SOUTH_PORT && (origin = node.getProperty(InternalProperties.ORIGIN)) instanceof LNode) {
                    options.append("(" + ((LNode)((Object)origin)).toString() + ")");
                }
            }
            options.append("(" + layerNumber + "," + nodeNumber + ")\",");
            if (node.getType() == LNode.NodeType.NORMAL) {
                options.append("shape=box,");
            } else {
                options.append("style=\"rounded,filled\",");
                String color = node.getType().getColor();
                if (color != null) {
                    options.append("color=\"" + color + "\",");
                }
            }
            options.deleteCharAt(options.length() - 1);
            if (options.length() > 0) {
                writer.write("[" + String.valueOf(options) + "]");
            }
            writer.write(";\n");
        }
        for (LNode node : nodes) {
            for (LPort port : node.getPorts()) {
                for (LEdge edge : port.getOutgoingEdges()) {
                    writer.write("    " + ((Object)((Object)node)).hashCode() + " -> " + ((Object)((Object)edge.getTarget().getNode())).hashCode());
                    writer.write(";\n");
                }
            }
        }
    }
}

