/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.hierarchymanager.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.Level;
import org.eclipse.fordiac.ide.hierarchymanager.model.hierarchy.RootLevel;
import org.eclipse.fordiac.ide.hierarchymanager.ui.handlers.AbstractHierarchyHandler;
import org.eclipse.fordiac.ide.hierarchymanager.ui.operations.CreateLevelOperation;
import org.eclipse.fordiac.ide.hierarchymanager.ui.view.PlantHierarchyView;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CreateLevel
extends AbstractHierarchyHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String newName;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        EObject parent = CreateLevel.getParent(selection, event);
        if (parent != null && (newName = CreateLevel.showCreateDialog()) != null) {
            CreateLevel.executeOperation(new CreateLevelOperation(parent, newName));
        }
        return Status.OK_STATUS;
    }

    private static EObject getParent(ISelection selection, ExecutionEvent event) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection sel = (StructuredSelection)selection;
            Object firstElement = sel.getFirstElement();
            if (firstElement instanceof Level) {
                Level level = (Level)firstElement;
                return level;
            }
            if (firstElement == null) {
                return CreateLevel.getParentFromPart(HandlerUtil.getActivePart((ExecutionEvent)event));
            }
        }
        return null;
    }

    private static EObject getParentFromPart(IWorkbenchPart activePart) {
        PlantHierarchyView phView;
        Object object;
        if (activePart instanceof PlantHierarchyView && (object = (phView = (PlantHierarchyView)activePart).getCommonViewer().getInput()) instanceof RootLevel) {
            RootLevel root = (RootLevel)object;
            return root;
        }
        return null;
    }

    private static String showCreateDialog() {
        InputDialog dialog = new InputDialog(Display.getDefault().getActiveShell(), "Create Level", "Enter new level name", "", null);
        int ret = dialog.open();
        if (ret == 0) {
            return dialog.getValue();
        }
        return null;
    }
}

