/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.emf.compare.MatchEngine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class FordiacIdentifierEObjectMatcher
implements IEObjectMatcher {
    private final Optional<IEObjectMatcher> delegate;
    private Function<EObject, String> idComputation = new DefaultIDFunction();
    private BasicDiagnostic diagnostic;

    public FordiacIdentifierEObjectMatcher() {
        this(null, new DefaultIDFunction());
    }

    public FordiacIdentifierEObjectMatcher(IEObjectMatcher delegateWhenNoID) {
        this(delegateWhenNoID, new DefaultIDFunction());
    }

    public FordiacIdentifierEObjectMatcher(Function<EObject, String> idComputation) {
        this(null, idComputation);
    }

    public FordiacIdentifierEObjectMatcher(IEObjectMatcher delegateWhenNoID, Function<EObject, String> idComputation) {
        this.delegate = Optional.ofNullable(delegateWhenNoID);
        this.idComputation = idComputation;
    }

    public void createMatches(Comparison comparison, Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, Monitor monitor) {
        if (monitor.isCanceled()) {
            throw new ComparisonCanceledException();
        }
        ArrayList<EObject> leftEObjectsNoID = new ArrayList<EObject>();
        ArrayList<EObject> rightEObjectsNoID = new ArrayList<EObject>();
        ArrayList<EObject> originEObjectsNoID = new ArrayList<EObject>();
        this.diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.compare", 0, EMFCompareMessages.getString((String)"IdentifierEObjectMatcher.diagnosticMessage"), null);
        Set<Match> matches = this.matchPerId(leftEObjects, rightEObjects, originEObjects, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID);
        this.addDiagnostic(comparison);
        comparison.getMatches().addAll(matches);
        if (!(leftEObjectsNoID.isEmpty() && rightEObjectsNoID.isEmpty() && originEObjectsNoID.isEmpty())) {
            if (this.delegate.isPresent()) {
                this.doDelegation(comparison, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID, monitor);
            } else {
                Match match;
                for (EObject eObject : leftEObjectsNoID) {
                    if (monitor.isCanceled()) {
                        throw new ComparisonCanceledException();
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setLeft(eObject);
                    matches.add(match);
                }
                for (EObject eObject : rightEObjectsNoID) {
                    if (monitor.isCanceled()) {
                        throw new ComparisonCanceledException();
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setRight(eObject);
                    matches.add(match);
                }
                for (EObject eObject : originEObjectsNoID) {
                    if (monitor.isCanceled()) {
                        throw new ComparisonCanceledException();
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setOrigin(eObject);
                    matches.add(match);
                }
            }
        }
    }

    protected void doDelegation(Comparison comparison, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID, Monitor monitor) {
        this.delegate.get().createMatches(comparison, leftEObjectsNoID.iterator(), rightEObjectsNoID.iterator(), originEObjectsNoID.iterator(), monitor);
    }

    protected Set<Match> matchPerId(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID) {
        MatchComputation computation = new MatchComputation(leftEObjects, rightEObjects, originEObjects, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID);
        computation.compute();
        return computation.getMatches();
    }

    protected static EObject getParentEObject(EObject eObject) {
        EObject parent = eObject != null ? eObject.eContainer() : null;
        return parent;
    }

    private void reportDuplicateID(EObjectIndex.Side side, EObject eObject) {
        String duplicateID = this.idComputation.apply(eObject);
        String sideName = side.name().toLowerCase();
        String uriString = FordiacIdentifierEObjectMatcher.getUriString(eObject);
        String message = uriString != null ? EMFCompareMessages.getString((String)"IdentifierEObjectMatcher.duplicateIdWithResource", (Object[])new Object[]{duplicateID, sideName, uriString}) : EMFCompareMessages.getString((String)"IdentifierEObjectMatcher.duplicateId", (Object[])new Object[]{duplicateID, sideName});
        this.diagnostic.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.emf.compare", 0, message, null));
    }

    private static String getUriString(EObject eObject) {
        String uriString = null;
        Resource resource = eObject.eResource();
        if (resource != null && resource.getURI() != null) {
            URI uri = resource.getURI();
            uriString = uri.isPlatform() ? uri.toPlatformString(true) : uri.toString();
        }
        return uriString;
    }

    private void addDiagnostic(Comparison comparison) {
        if (comparison.getDiagnostic() == null) {
            comparison.setDiagnostic((Diagnostic)this.diagnostic);
        } else {
            ((BasicDiagnostic)comparison.getDiagnostic()).merge((Diagnostic)this.diagnostic);
        }
    }

    public static class DefaultIDFunction
    implements Function<EObject, String> {
        @Override
        public String apply(EObject eObject) {
            String identifier;
            if (eObject == null) {
                identifier = null;
            } else if (eObject.eIsProxy()) {
                identifier = ((InternalEObject)eObject).eProxyURI().fragment();
            } else {
                Resource eObjectResource = eObject.eResource();
                String xmiID = eObjectResource instanceof XMIResource ? ((XMIResource)eObjectResource).getID(eObject) : null;
                identifier = xmiID != null ? xmiID : EcoreUtil.getID((EObject)eObject);
            }
            return identifier;
        }
    }

    private class MatchComputation {
        private final Set<Match> matches = new LinkedHashSet<Match>();
        private final Map<EObject, Match> leftEObjectsToMatch = new HashMap<EObject, Match>();
        private final Map<EObject, Match> rightEObjectsToMatch = new HashMap<EObject, Match>();
        private final Map<EObject, Match> originEObjectsToMatch = new HashMap<EObject, Match>();
        private final Iterator<? extends EObject> leftEObjects;
        private final Iterator<? extends EObject> rightEObjects;
        private final Iterator<? extends EObject> originEObjects;
        private final List<EObject> leftEObjectsNoID;
        private final List<EObject> rightEObjectsNoID;
        private final List<EObject> originEObjectsNoID;
        private final SwitchMap<String, Match> idProxyMap;

        MatchComputation(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID) {
            this.idProxyMap = new SwitchMap();
            this.leftEObjects = leftEObjects;
            this.rightEObjects = rightEObjects;
            this.originEObjects = originEObjects;
            this.leftEObjectsNoID = leftEObjectsNoID;
            this.rightEObjectsNoID = rightEObjectsNoID;
            this.originEObjectsNoID = originEObjectsNoID;
        }

        public Set<Match> getMatches() {
            return this.matches;
        }

        public void compute() {
            this.computeLeftSide();
            this.computeRightSide();
            this.computeOriginSide();
            this.reorganizeMatches();
        }

        private void computeLeftSide() {
            while (this.leftEObjects.hasNext()) {
                EObject left = this.leftEObjects.next();
                String identifier = FordiacIdentifierEObjectMatcher.this.idComputation.apply(left);
                if (identifier != null) {
                    Match match = CompareFactory.eINSTANCE.createMatch();
                    match.setLeft(left);
                    EObject parentEObject = FordiacIdentifierEObjectMatcher.getParentEObject(left);
                    Match parent = this.leftEObjectsToMatch.get(parentEObject);
                    if (parent != null) {
                        ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    } else {
                        this.matches.add(match);
                    }
                    boolean isAlreadyContained = this.idProxyMap.put(left.eIsProxy(), identifier, match);
                    if (isAlreadyContained) {
                        if (match.getLeft().hashCode() == this.idProxyMap.get(left.eIsProxy(), identifier).getLeft().hashCode()) {
                            FordiacIdentifierEObjectMatcher.this.reportDuplicateID(EObjectIndex.Side.LEFT, left);
                        } else {
                            System.out.println("Something wrong with; " + match.getLeft().toString());
                        }
                    }
                    this.leftEObjectsToMatch.put(left, match);
                    continue;
                }
                this.leftEObjectsNoID.add(left);
            }
        }

        private void computeRightSide() {
            while (this.rightEObjects.hasNext()) {
                EObject right = this.rightEObjects.next();
                String identifier = FordiacIdentifierEObjectMatcher.this.idComputation.apply(right);
                if (identifier != null) {
                    Match match = this.idProxyMap.get(right.eIsProxy(), identifier);
                    if (match != null) {
                        if (match.getRight() != null) {
                            FordiacIdentifierEObjectMatcher.this.reportDuplicateID(EObjectIndex.Side.RIGHT, right);
                        }
                        match.setRight(right);
                        this.rightEObjectsToMatch.put(right, match);
                        continue;
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setRight(right);
                    EObject parentEObject = FordiacIdentifierEObjectMatcher.getParentEObject(right);
                    Match parent = this.rightEObjectsToMatch.get(parentEObject);
                    if (parent != null) {
                        ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    } else {
                        this.matches.add(match);
                    }
                    this.rightEObjectsToMatch.put(right, match);
                    this.idProxyMap.put(right.eIsProxy(), identifier, match);
                    continue;
                }
                this.rightEObjectsNoID.add(right);
            }
        }

        private void computeOriginSide() {
            while (this.originEObjects.hasNext()) {
                EObject origin = this.originEObjects.next();
                String identifier = FordiacIdentifierEObjectMatcher.this.idComputation.apply(origin);
                if (identifier != null) {
                    Match match = this.idProxyMap.get(origin.eIsProxy(), identifier);
                    if (match != null) {
                        if (match.getOrigin() != null) {
                            FordiacIdentifierEObjectMatcher.this.reportDuplicateID(EObjectIndex.Side.ORIGIN, origin);
                        }
                        match.setOrigin(origin);
                        this.originEObjectsToMatch.put(origin, match);
                        continue;
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setOrigin(origin);
                    EObject parentEObject = FordiacIdentifierEObjectMatcher.getParentEObject(origin);
                    Match parent = this.originEObjectsToMatch.get(parentEObject);
                    if (parent != null) {
                        ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    } else {
                        this.matches.add(match);
                    }
                    this.idProxyMap.put(origin.eIsProxy(), identifier, match);
                    this.originEObjectsToMatch.put(origin, match);
                    continue;
                }
                this.originEObjectsNoID.add(origin);
            }
        }

        private void reorganizeMatches() {
            for (Match match : Set.copyOf(this.matches)) {
                EObject parentEObject = FordiacIdentifierEObjectMatcher.getParentEObject(match.getLeft());
                Match parent = this.leftEObjectsToMatch.get(parentEObject);
                if (parent != null) {
                    this.matches.remove(match);
                    ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    continue;
                }
                parentEObject = FordiacIdentifierEObjectMatcher.getParentEObject(match.getRight());
                parent = this.rightEObjectsToMatch.get(parentEObject);
                if (parent != null) {
                    this.matches.remove(match);
                    ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    continue;
                }
                parentEObject = FordiacIdentifierEObjectMatcher.getParentEObject(match.getOrigin());
                parent = this.originEObjectsToMatch.get(parentEObject);
                if (parent == null) continue;
                this.matches.remove(match);
                ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
            }
        }
    }

    private class SwitchMap<K, V> {
        final Map<K, V> trueMap = new HashMap();
        final Map<K, V> falseMap = new HashMap();

        private SwitchMap() {
        }

        public boolean put(boolean switcher, K key, V value) {
            Map<K, V> selectedMap = this.getMap(switcher);
            boolean isContained = selectedMap.containsKey(key);
            selectedMap.put(key, value);
            return isContained;
        }

        public V get(boolean switcher, K key) {
            Map<K, V> selectedMap = this.getMap(switcher);
            return selectedMap.get(key);
        }

        private Map<K, V> getMap(boolean switcher) {
            if (switcher) {
                return this.falseMap;
            }
            return this.trueMap;
        }
    }
}

