/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.breakpoint;

import java.util.Optional;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public final class DeploymentWatchpointUtil {
    public static Optional<DeploymentWatchpoint> findExistingWatchpoint(IResource resource, INamedElement element) {
        return DeploymentWatchpointUtil.findExistingWatchpoint(resource, element.getQualifiedName());
    }

    public static Optional<DeploymentWatchpoint> findExistingWatchpoint(IResource resource, String qualifiedName) {
        IBreakpoint[] breakpoints;
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] iBreakpointArray = breakpoints = manager.getBreakpoints("org.eclipse.fordiac.ide.deployment.debug.model");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            DeploymentWatchpoint watchpoint;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof DeploymentWatchpoint && (watchpoint = (DeploymentWatchpoint)breakpoint).getMarker().getResource().equals((Object)resource) && watchpoint.getLocation().equals(qualifiedName)) {
                return Optional.of(watchpoint);
            }
            ++n2;
        }
        return Optional.empty();
    }

    private DeploymentWatchpointUtil() {
        throw new UnsupportedOperationException();
    }
}

