/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts.model;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.contracts.exceptions.AssumptionExeption;
import org.eclipse.fordiac.ide.contracts.exceptions.ContractExeption;
import org.eclipse.fordiac.ide.contracts.model.AssumptionWithOffset;
import org.eclipse.fordiac.ide.contracts.model.Contract;
import org.eclipse.fordiac.ide.contracts.model.ContractElement;
import org.eclipse.fordiac.ide.contracts.model.Instant;
import org.eclipse.fordiac.ide.contracts.model.Interval;
import org.eclipse.fordiac.ide.contracts.model.helpers.ContractUtils;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;

public class Assumption
extends ContractElement {
    private static final int POS_OCCURS = 2;
    private static final int POS_TIME = 4;
    private static final int POS_EVERY = 3;
    private static final int ASSUMPTION_LENGTH = 5;
    private static final int POSITION_NO = 4;

    Assumption() {
    }

    Assumption(String inputEvent, Interval interval) {
        super(inputEvent, interval);
    }

    static Assumption createAssumption(String line) throws ContractExeption {
        if (line.contains("offset")) {
            return AssumptionWithOffset.createAssumptionWithOffset(line);
        }
        String[] parts = line.split(" ");
        if (!Assumption.isCorrectAssumption(parts)) {
            throw new AssumptionExeption("Error with Assumption: " + line);
        }
        return Assumption.createAssumptionFrom(parts);
    }

    private static Assumption createAssumptionFrom(String[] parts) {
        Assumption assumption = new Assumption();
        assumption.setInputEvent(parts[1]);
        if (ContractUtils.isInterval(parts, 4, ",")) {
            assumption.setRangeFromInterval(parts, 4);
            return assumption;
        }
        assumption.setTime(new Instant(Integer.parseInt(parts[4].substring(0, parts[4].length() - "ms".length()))));
        return assumption;
    }

    private static boolean isCorrectAssumption(String[] parts) {
        if (parts.length != 5) {
            return false;
        }
        if (!"occurs".equals(parts[2])) {
            return false;
        }
        if (!"every".equals(parts[3])) {
            return false;
        }
        return "ms".equals(parts[4].substring(ContractUtils.getStartPosition(parts, 4), parts[4].length()));
    }

    @Override
    boolean isValid() {
        if (!this.hasValidOwner()) {
            return false;
        }
        EList fBNetworkElements = ((SubApp)this.getContract().getOwner()).getSubAppNetwork().getNetworkElements();
        List<SubApp> containedSubapps = fBNetworkElements.parallelStream().filter(ContractUtils::isContractSubapp).map(el -> (SubApp)el).toList();
        List<FB> containedfBs = fBNetworkElements.parallelStream().filter(FB.class::isInstance).map(FB.class::cast).toList();
        EList inputEvents = this.getContract().getOwner().getInterface().getEventInputs();
        return this.hasMatchingEvents(containedSubapps, containedfBs, (EList<Event>)inputEvents);
    }

    private boolean hasMatchingEvents(List<SubApp> containedSubapps, List<FB> containedfBs, EList<Event> inputEvents) {
        if (containedfBs.size() == 1) {
            inputEvents = containedfBs.get(0).getInterface().getEventInputs();
        }
        if (!containedSubapps.isEmpty() || containedfBs.size() == 1) {
            for (Event inputE : inputEvents) {
                if (!inputE.getName().equals(this.getInputEvent())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCompatibleWith(EList<Assumption> assumptions) {
        for (Assumption assumption : assumptions) {
            if (!(assumption instanceof AssumptionWithOffset)) continue;
            return AssumptionWithOffset.isCompatibleWithOffset(assumptions);
        }
        return Contract.isTimeConsistent(assumptions);
    }

    @Override
    public String asString() {
        Assumption assumption = this;
        if (assumption instanceof AssumptionWithOffset) {
            AssumptionWithOffset withOffset = (AssumptionWithOffset)assumption;
            return withOffset.asString();
        }
        StringBuilder comment = new StringBuilder();
        if (this.getMax() == -1 || this.getMax() == this.getMin()) {
            comment.append(ContractUtils.createAssumptionString(this.getInputEvent(), String.valueOf(this.getMin())));
        } else {
            comment.append(ContractUtils.createAssumptionString(this.getInputEvent(), ContractUtils.createInterval(this)));
        }
        comment.append(System.lineSeparator());
        return comment.toString();
    }
}

