/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.fordiac.ide.application.actions.FBNetworkElementInsertAction;
import org.eclipse.fordiac.ide.application.actions.PasteEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.UpdateFBTypeAction;
import org.eclipse.fordiac.ide.application.editors.FBNetworkEditor;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.FordiacContextMenuProvider;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class FBNetworkContextMenuProvider
extends FordiacContextMenuProvider {
    private final TypeLibrary typeLib;
    private final DiagramEditorWithFlyoutPalette editor;
    private org.eclipse.swt.graphics.Point invocationLocation;
    private boolean useChangeFBType;

    public FBNetworkContextMenuProvider(DiagramEditorWithFlyoutPalette editor, ActionRegistry registry, ZoomManager zoomManager, TypeLibrary typeLib) {
        super((EditPartViewer)editor.getViewer(), zoomManager, registry);
        this.typeLib = typeLib;
        this.editor = editor;
        editor.getViewer().getControl().addMenuDetectListener(e -> {
            org.eclipse.swt.graphics.Point point = this.invocationLocation = this.getViewer().getControl().toControl(e.x, e.y);
        });
    }

    public Point getTranslatedAndZoomedPoint() {
        FigureCanvas viewerControl = (FigureCanvas)this.editor.getViewer().getControl();
        Point location = viewerControl.getViewport().getViewLocation();
        return new Point(this.invocationLocation.x + location.x, this.invocationLocation.y + location.y).scale(1.0 / this.getZoomManager().getZoom());
    }

    public org.eclipse.swt.graphics.Point getPoint() {
        return this.invocationLocation;
    }

    public void buildContextMenu(IMenuManager menu) {
        super.buildContextMenu(menu);
        IAction action = this.getRegistry().getAction((Object)"org.eclipse.fordiac.ide.model.ui.OpenAction");
        if (action != null && action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        if ((action = this.getRegistry().getAction((Object)"org.eclipse.gef.direct_edit")) != null && action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        menu.appendToGroup("org.eclipse.gef.group.rest", (IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        action = this.getRegistry().getAction((Object)ActionFactory.CUT.getId());
        menu.appendToGroup("org.eclipse.gef.group.copy", action);
        action = this.getRegistry().getAction((Object)ActionFactory.COPY.getId());
        menu.appendToGroup("org.eclipse.gef.group.copy", action);
        action = this.getRegistry().getAction((Object)ActionFactory.PASTE.getId());
        if (action instanceof PasteEditPartsAction) {
            PasteEditPartsAction pasteAction = (PasteEditPartsAction)action;
            pasteAction.setPastRefPosition(this.getTranslatedAndZoomedPoint());
        }
        menu.appendToGroup("org.eclipse.gef.group.copy", action);
        action = this.getRegistry().getAction((Object)ActionFactory.DELETE.getId());
        menu.appendToGroup("org.eclipse.gef.group.copy", action);
    }

    public void buildFBInsertMenu(IMenuManager menu, org.eclipse.swt.graphics.Point point, boolean useChangeFBType) {
        this.invocationLocation = point;
        this.useChangeFBType = useChangeFBType;
        this.fillMenuForFolder(menu, (IContainer)this.typeLib.getProject());
    }

    private void fillMenuForFolder(IMenuManager submenu, IContainer container) {
        try {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res = iResourceArray[n2];
                if (res instanceof IFolder) {
                    IFolder folder = (IFolder)res;
                    this.createSubMenu(submenu, folder);
                } else if (res instanceof IFile) {
                    IFile file = (IFile)res;
                    this.createFBMenuEntry(submenu, file);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    private void createSubMenu(IMenuManager parent, IFolder res) {
        MenuManager submenu = new MenuManager(res.getName());
        this.fillMenuForFolder((IMenuManager)submenu, (IContainer)res);
        if (!submenu.isEmpty()) {
            submenu.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER"));
            parent.add((IContributionItem)submenu);
        }
    }

    private void createFBMenuEntry(IMenuManager submenu, IFile typeFile) {
        TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(typeFile);
        if (entry instanceof FBTypeEntry || entry instanceof SubAppTypeEntry) {
            Action action = this.getActionForTypeEntry(entry);
            FBNetworkContextMenuProvider.setActionIcon(action, entry);
            submenu.add((IAction)action);
        }
    }

    private Action getActionForTypeEntry(TypeEntry entry) {
        Object action = this.useChangeFBType ? (Action)this.getRegistry().getAction((Object)entry.getFile().getFullPath().toString().concat("_").concat("UpdateFBTypeAction")) : (Action)this.getRegistry().getAction((Object)entry.getFile().getFullPath().toString());
        if (action == null) {
            action = this.useChangeFBType ? this.createChangeFBTypeAction(entry) : this.createFBInsertAction(entry);
        }
        return action;
    }

    private static void setActionIcon(Action action, TypeEntry entry) {
        ImageDescriptor image = null;
        image = entry.getType() instanceof SubAppType ? FordiacImage.ICON_SUB_APP_TYPE.getImageDescriptor() : (entry.getType() instanceof BasicFBType ? FordiacImage.ICON_BASIC_FB.getImageDescriptor() : (entry.getType() instanceof SimpleFBType ? FordiacImage.ICON_SIMPLE_FB.getImageDescriptor() : (entry.getType() instanceof CompositeFBType ? FordiacImage.ICON_COMPOSITE_FB.getImageDescriptor() : FordiacImage.ICON_SIFB.getImageDescriptor())));
        action.setImageDescriptor(image);
    }

    private UpdateFBTypeAction createChangeFBTypeAction(TypeEntry entry) {
        UpdateFBTypeAction action = new UpdateFBTypeAction((IWorkbenchPart)this.editor, entry);
        this.getRegistry().registerAction((IAction)action);
        this.editor.getSelActions().add(action.getId());
        action.update();
        return action;
    }

    private FBNetworkElementInsertAction createFBInsertAction(TypeEntry entry) {
        FBNetworkElementInsertAction action = new FBNetworkElementInsertAction((IWorkbenchPart)this.editor, entry, ((FBNetworkEditor)this.editor).getModel());
        this.getRegistry().registerAction((IAction)action);
        return action;
    }

    public void setInvocationLocation(org.eclipse.swt.graphics.Point invocationLocation) {
        this.invocationLocation = invocationLocation;
    }
}

