/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.Activator;
import org.eclipse.fordiac.ide.model.LibraryElementTags;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.Palette.AdapterTypePaletteEntry;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.CompilableElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.ImportUtils;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.ReferencedTypeNotFoundException;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterEvent;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ECAction;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.ECState;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OtherAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.PositionableElement;
import org.eclipse.fordiac.ide.model.libraryElement.STAlgorithm;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterfaceFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FBTImporter
implements LibraryElementTags {
    public Map<String, VarDeclaration> variables = new HashMap<String, VarDeclaration>();
    public Map<String, VarDeclaration> internalVariables = new HashMap<String, VarDeclaration>();
    public Map<String, Event> inputEvents = new HashMap<String, Event>();
    public Map<String, Event> outputEvents = new HashMap<String, Event>();
    public Map<String, AdapterDeclaration> adapters = new HashMap<String, AdapterDeclaration>();
    public Map<String, PositionableElement> adapterPositions = new HashMap<String, PositionableElement>();
    public Map<String, ArrayList<ECAction>> algorithmNameECActionMapping = new HashMap<String, ArrayList<ECAction>>();
    public Map<String, ECState> ecStates = new HashMap<String, ECState>();
    protected FBType type;
    private IFile file;
    protected Palette palette;

    public FBType importType(IFile fbtFile, Palette palette) {
        this.palette = palette;
        this.file = fbtFile;
        this.prepareParseDataBuffers();
        try {
            Document document = this.createDocument();
            if (document != null) {
                Element rootNode = document.getDocumentElement();
                this.type = this.createType();
                this.configureType();
                return this.parseType(rootNode);
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return null;
    }

    protected void configureType() {
        Service service = LibraryElementFactory.eINSTANCE.createService();
        this.type.setService(service);
    }

    protected FBType createType() {
        return LibraryElementFactory.eINSTANCE.createFBType();
    }

    protected void prepareParseDataBuffers() {
        this.algorithmNameECActionMapping.clear();
        this.inputEvents.clear();
        this.outputEvents.clear();
        this.variables.clear();
        this.ecStates.clear();
        this.adapters.clear();
        this.adapterPositions.clear();
    }

    protected Document createDocument() throws ParserConfigurationException, SAXException, IOException, CoreException {
        if (this.file.exists()) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(false);
            dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
            DocumentBuilder db = dbf.newDocumentBuilder();
            return db.parse(this.file.getContents());
        }
        return null;
    }

    protected FBType parseType(Node rootNode) throws TypeImportException, ReferencedTypeNotFoundException, ParseException {
        if (rootNode.getNodeName().equals("FBType")) {
            CommonElementImporter.readNameCommentAttributes(this.type, rootNode.getAttributes());
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("Identification")) {
                    this.type.setIdentification(CommonElementImporter.parseIdentification(this.type, n));
                }
                if (n.getNodeName().equals("VersionInfo")) {
                    this.type.getVersionInfo().add((Object)CommonElementImporter.parseVersionInfo(this.type, n));
                }
                if (n.getNodeName().equals("CompilerInfo")) {
                    this.type.setCompilerInfo(CompilableElementImporter.parseCompilerInfo(this.type, n));
                }
                if (n.getNodeName().equals("InterfaceList")) {
                    this.type.setInterfaceList(this.parseInterfaceList(n));
                }
                if (n.getNodeName().equals("BasicFB")) {
                    this.type = FBTImporter.convertoToBasicType(this.type);
                    this.parseBasicFB((BasicFBType)this.type, n);
                }
                if (n.getNodeName().equals("FBNetwork")) {
                    this.type = FBTImporter.convertToCompositeType(this.type);
                    this.parseFBNetwork((CompositeFBType)this.type, n);
                }
                if (n.getNodeName().equals("Service")) {
                    this.parseService(this.type, n);
                }
                ++i;
            }
            if (this.type instanceof BasicFBType || this.type instanceof CompositeFBType || this.type instanceof ServiceInterfaceFBType) {
                return this.type;
            }
            this.type = FBTImporter.convertToServiceInterfaceType(this.type);
            return this.type;
        }
        throw new ParseException(Messages.FBTImporter_PARSE_FBTYPE_PARSEEXCEPTION, 0);
    }

    public void parseService(FBType type, Node n) throws TypeImportException {
        NodeList childNodes = n.getChildNodes();
        NamedNodeMap map = n.getAttributes();
        Node rightInterface = map.getNamedItem("RightInterface");
        if (rightInterface == null) {
            throw new TypeImportException(Messages.FBTImporter_SERVICE_INTERFACE_RIGHTINTERFACE_EXCEPTION);
        }
        ServiceInterface rightInter = LibraryElementFactory.eINSTANCE.createServiceInterface();
        rightInter.setName(rightInterface.getNodeValue());
        type.getService().setRightInterface(rightInter);
        Node leftInterface = map.getNamedItem("LeftInterface");
        if (leftInterface == null) {
            throw new TypeImportException(Messages.FBTImporter_SERVICE_INTERFACE_LEFTINTERFACE_EXCEPTION);
        }
        ServiceInterface leftInter = LibraryElementFactory.eINSTANCE.createServiceInterface();
        leftInter.setName(leftInterface.getNodeValue());
        type.getService().setLeftInterface(leftInter);
        Node comment = map.getNamedItem("Comment");
        if (comment != null) {
            type.setComment(comment.getNodeValue());
        }
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeName().equals("ServiceSequence")) {
                this.parseServiceSequence(type, node);
            }
            ++i;
        }
    }

    private void parseServiceSequence(FBType type, Node node) throws TypeImportException {
        ServiceSequence serviceSequence = LibraryElementFactory.eINSTANCE.createServiceSequence();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("ServiceTransaction")) {
                this.parseServiceTransaction(serviceSequence, n, type);
            }
            ++i;
        }
        NamedNodeMap map = node.getAttributes();
        CommonElementImporter.readNameCommentAttributes(serviceSequence, map);
        type.getService().getServiceSequence().add((Object)serviceSequence);
    }

    private void parseServiceTransaction(ServiceSequence serviceSequence, Node node, FBType type) throws TypeImportException {
        ServiceTransaction serviceTransaction = LibraryElementFactory.eINSTANCE.createServiceTransaction();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("InputPrimitive")) {
                this.parseInputPrimitive(serviceTransaction, n, type);
            }
            if (n.getNodeName().equals("OutputPrimitive")) {
                this.parseOutputPrimitive(serviceTransaction, n, type);
            }
            serviceSequence.getServiceTransaction().add((Object)serviceTransaction);
            ++i;
        }
    }

    private void parseOutputPrimitive(ServiceTransaction serviceTransaction, Node n, FBType type) throws TypeImportException {
        OutputPrimitive outputPrimitive = LibraryElementFactory.eINSTANCE.createOutputPrimitive();
        NamedNodeMap map = n.getAttributes();
        Node interFace = map.getNamedItem("Interface");
        if (interFace != null) {
            if (interFace.getNodeValue().equals(type.getService().getLeftInterface().getName())) {
                outputPrimitive.setInterface(type.getService().getLeftInterface());
            } else if (interFace.getNodeValue().equals(type.getService().getRightInterface().getName())) {
                outputPrimitive.setInterface(type.getService().getRightInterface());
            }
        } else {
            throw new TypeImportException(Messages.FBTImporter_OUTPUT_PRIMITIVE_EXCEPTION);
        }
        Node event = map.getNamedItem(this.getEventElement());
        if (event == null) {
            throw new TypeImportException(Messages.FBTImporter_OUTPUT_PRIMITIVE_EVENT_EXCEPTION);
        }
        outputPrimitive.setEvent(event.getNodeValue());
        Node parameters = map.getNamedItem("Parameters");
        if (parameters != null) {
            outputPrimitive.setParameters(parameters.getNodeValue());
        }
        serviceTransaction.getOutputPrimitive().add((Object)outputPrimitive);
    }

    private void parseInputPrimitive(ServiceTransaction serviceTransaction, Node n, FBType type) throws TypeImportException {
        InputPrimitive inputPrimitive = LibraryElementFactory.eINSTANCE.createInputPrimitive();
        NamedNodeMap map = n.getAttributes();
        Node interFace = map.getNamedItem("Interface");
        if (interFace != null) {
            if (interFace.getNodeValue().equals(type.getService().getLeftInterface().getName())) {
                inputPrimitive.setInterface(type.getService().getLeftInterface());
            } else if (interFace.getNodeValue().equals(type.getService().getRightInterface().getName())) {
                inputPrimitive.setInterface(type.getService().getRightInterface());
            }
        } else {
            throw new TypeImportException(Messages.FBTImporter_INPUT_PRIMITIVE_EXCEPTION);
        }
        Node event = map.getNamedItem(this.getEventElement());
        if (event == null) {
            throw new TypeImportException(Messages.FBTImporter_INPUT_PRIMITIVE_EVENT_EXCEPTION);
        }
        inputPrimitive.setEvent(event.getNodeValue());
        Node parameters = map.getNamedItem("Parameters");
        if (parameters != null) {
            inputPrimitive.setParameters(parameters.getNodeValue());
        }
        serviceTransaction.setInputPrimitive(inputPrimitive);
    }

    private static FBType convertToServiceInterfaceType(FBType type) {
        ServiceInterfaceFBType serviceType = LibraryElementFactory.eINSTANCE.createServiceInterfaceFBType();
        FBTImporter.copyBasicTypeInformation(serviceType, type);
        return serviceType;
    }

    private static void copyBasicTypeInformation(FBType dstType, FBType srcType) {
        dstType.setName(srcType.getName());
        dstType.setComment(srcType.getComment());
        dstType.setCompilerInfo(srcType.getCompilerInfo());
        dstType.setInterfaceList(srcType.getInterfaceList());
        dstType.setIdentification(srcType.getIdentification());
        dstType.getVersionInfo().addAll(srcType.getVersionInfo());
        dstType.setService(srcType.getService());
    }

    private void parseFBNetwork(CompositeFBType type, Node node) throws TypeImportException, ReferencedTypeNotFoundException {
        FBNetwork fbNetwork = LibraryElementFactory.eINSTANCE.createFBNetwork();
        if (this.adapters.size() > 0) {
            for (AdapterDeclaration adapter : this.adapters.values()) {
                if (!(adapter.getType() instanceof AdapterType)) continue;
                this.addAdapterFB(fbNetwork, adapter, this.palette);
            }
        }
        FBNetworkImporter fbnInmporter = new FBNetworkImporter(this.palette, fbNetwork, type.getInterfaceList());
        type.setFBNetwork(fbnInmporter.parseFBNetwork(node));
    }

    private void addAdapterFB(FBNetwork fbNetwork, AdapterDeclaration adapter, Palette palette) {
        AdapterFB aFB = LibraryElementFactory.eINSTANCE.createAdapterFB();
        aFB.setPaletteEntry(FBTImporter.getAdapterPaletEntry(adapter.getTypeName(), palette));
        aFB.setAdapterDecl(adapter);
        aFB.setName(adapter.getName());
        PositionableElement position = this.adapterPositions.get(adapter.getName());
        if (position == null) {
            aFB.setX(0);
            aFB.setY(0);
        } else {
            aFB.setX(position.getX());
            aFB.setY(position.getY());
        }
        aFB.setInterface((InterfaceList)EcoreUtil.copy((EObject)aFB.getType().getInterfaceList()));
        fbNetwork.getNetworkElements().add((Object)aFB);
    }

    private static AdapterTypePaletteEntry getAdapterPaletEntry(String name, Palette palette) {
        PaletteEntry entry = palette.getTypeEntry(name);
        return entry instanceof AdapterTypePaletteEntry ? (AdapterTypePaletteEntry)entry : null;
    }

    private static FBType convertToCompositeType(FBType type) {
        CompositeFBType compositeType = LibraryElementFactory.eINSTANCE.createCompositeFBType();
        FBTImporter.copyBasicTypeInformation(compositeType, type);
        return compositeType;
    }

    private void parseBasicFB(BasicFBType type, Node node) throws TypeImportException, ReferencedTypeNotFoundException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("InternalVars")) {
                this.parseInternalVars(type, n);
            }
            if (n.getNodeName().equals("ECC")) {
                this.parseECC(type, n);
            }
            if (n.getNodeName().equals("Algorithm")) {
                this.parseAlgorithm(type, n, this.palette);
            }
            ++i;
        }
    }

    private void parseAlgorithm(BasicFBType type, Node n, Palette palette) throws TypeImportException, ReferencedTypeNotFoundException {
        NamedNodeMap map = n.getAttributes();
        Node nameNode = map.getNamedItem("Name");
        Node commentNode = map.getNamedItem("Comment");
        String name = null;
        String comment = null;
        if (nameNode != null) {
            name = nameNode.getNodeValue();
        }
        if (commentNode != null) {
            comment = commentNode.getNodeValue();
        }
        NodeList childNodes = n.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            ArrayList<ECAction> list;
            Node node = childNodes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("FBD")) {
                throw new TypeImportException("Algorithm: Unsupported Algorithmtype (only ST and Other possible)!");
            }
            if (nodeName.equals("ST")) {
                STAlgorithm sT = LibraryElementFactory.eINSTANCE.createSTAlgorithm();
                sT.setName(name);
                sT.setComment(comment);
                FBTImporter.parseST(sT, node);
                type.getAlgorithm().add((Object)sT);
                list = this.algorithmNameECActionMapping.get(sT.getName());
                if (list != null) {
                    for (ECAction action : list) {
                        action.setAlgorithm(sT);
                    }
                }
            } else {
                if (nodeName.equals("LD")) {
                    throw new TypeImportException("Algorithm: Unsupported Algorithmtype (only ST and Other possible)!");
                }
                if (nodeName.equals("Other")) {
                    OtherAlgorithm other = LibraryElementFactory.eINSTANCE.createOtherAlgorithm();
                    other.setName(name);
                    other.setComment(comment);
                    FBTImporter.parseOtherAlg(other, node);
                    type.getAlgorithm().add((Object)other);
                    list = this.algorithmNameECActionMapping.get(other.getName());
                    if (list != null) {
                        for (ECAction action : list) {
                            action.setAlgorithm(other);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private static void parseOtherAlg(OtherAlgorithm other, Node node) throws TypeImportException {
        NamedNodeMap map = node.getAttributes();
        Node language = map.getNamedItem("Language");
        if (language == null) {
            throw new TypeImportException(Messages.FBTImporter_OTHER_ALG_MISSING_LANG_EXCEPTION);
        }
        other.setLanguage(language.getNodeValue());
        Node text = map.getNamedItem("Text");
        if (text == null) {
            throw new TypeImportException(Messages.FBTImporter_OTHER_ALG_MISSING_TEXT_EXCEPTION);
        }
        other.setText(text.getNodeValue());
    }

    private static void parseST(STAlgorithm st, Node node) throws TypeImportException {
        NamedNodeMap map = node.getAttributes();
        Node text = map.getNamedItem("Text");
        if (text == null) {
            throw new TypeImportException(Messages.FBTImporter_ST_TEXTNOTSET_EXCEPTION);
        }
        st.setText(text.getNodeValue());
    }

    private void parseECC(BasicFBType type, Node n) throws TypeImportException {
        NodeList childNodes = n.getChildNodes();
        ECC ecc = LibraryElementFactory.eINSTANCE.createECC();
        boolean first = true;
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeName().equals("ECState")) {
                this.parseECState(ecc, node, first);
                first = false;
            }
            if (node.getNodeName().equals("ECTransition")) {
                this.parseECTransition(ecc, node);
            }
            ++i;
        }
        type.setECC(ecc);
    }

    private void parseECTransition(ECC ecc, Node node) throws TypeImportException {
        NamedNodeMap map = node.getAttributes();
        ECTransition ecTransition = LibraryElementFactory.eINSTANCE.createECTransition();
        ecc.getECTransition().add((Object)ecTransition);
        Node source = map.getNamedItem("Source");
        if (source != null) {
            ECState state = this.ecStates.get(source.getNodeValue());
            if (state != null) {
                ecTransition.setSource(state);
            }
        } else {
            throw new TypeImportException(Messages.FBTImporter_ECTRANSITION_SOURCE_EXCEPTION);
        }
        Node destination = map.getNamedItem("Destination");
        if (destination != null) {
            ECState state = this.ecStates.get(destination.getNodeValue());
            if (state != null) {
                ecTransition.setDestination(state);
            }
        } else {
            throw new TypeImportException(Messages.FBTImporter_ECTRANSITION_DEST_EXCEPTION);
        }
        Node condition = map.getNamedItem("Condition");
        if (condition == null) {
            throw new TypeImportException(Messages.FBTImporter_ECTRANASITION_CONDITION_EXCEPTION);
        }
        this.validateTransitionCondition(ecTransition, condition.getNodeValue());
        Node comment = map.getNamedItem("Comment");
        if (comment != null) {
            ecTransition.setComment(comment.getNodeValue());
        }
        CommonElementImporter.getXandY(map, ecTransition);
    }

    private void validateTransitionCondition(ECTransition ecTransition, String condition) throws TypeImportException {
        String[] split = condition.split("&", 2);
        Event event = this.inputEvents.get(split[0].trim());
        String expression = event != null ? (split.length > 1 ? split[1].trim() : "") : ((event = this.inputEvents.get((split = condition.split("\\[", 2))[0].trim())) != null ? (split.length > 1 ? split[1].substring(0, split[1].lastIndexOf(93)).trim() : "") : (condition.startsWith("[") ? condition.substring(1, condition.lastIndexOf(93)) : condition));
        ecTransition.setConditionEvent(event);
        ecTransition.setConditionExpression(expression);
    }

    private void parseECState(ECC ecc, Node node, Boolean initialState) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        ECState state = LibraryElementFactory.eINSTANCE.createECState();
        ecc.getECState().add((Object)state);
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("ECAction")) {
                this.parseECAction(state, n);
            }
            ++i;
        }
        NamedNodeMap map = node.getAttributes();
        CommonElementImporter.readNameCommentAttributes(state, map);
        CommonElementImporter.getXandY(map, state);
        this.ecStates.put(state.getName(), state);
        if (initialState.booleanValue()) {
            ecc.setStart(state);
        }
    }

    private void parseECAction(ECState type, Node n) {
        Event outp;
        Node output;
        NamedNodeMap map = n.getAttributes();
        ECAction ecAction = LibraryElementFactory.eINSTANCE.createECAction();
        type.getECAction().add((Object)ecAction);
        Node algorithm = map.getNamedItem("Algorithm");
        if (algorithm != null) {
            if (this.algorithmNameECActionMapping.containsKey(algorithm.getNodeValue())) {
                this.algorithmNameECActionMapping.get(algorithm.getNodeValue()).add(ecAction);
            } else {
                ArrayList<ECAction> temp = new ArrayList<ECAction>();
                temp.add(ecAction);
                this.algorithmNameECActionMapping.put(algorithm.getNodeValue(), temp);
            }
        }
        if ((output = map.getNamedItem("Output")) != null && (outp = this.outputEvents.get(output.getNodeValue())) != null) {
            ecAction.setOutput(outp);
        }
    }

    private void parseInternalVars(BasicFBType type, Node n) throws TypeImportException {
        NodeList childNodes = n.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node.getNodeName().equals("VarDeclaration")) {
                VarDeclaration v = ImportUtils.parseVarDeclaration(node);
                type.getInternalVars().add((Object)v);
                this.internalVariables.put(v.getName(), v);
            }
            ++i;
        }
    }

    private static FBType convertoToBasicType(FBType type) {
        BasicFBType basicType = LibraryElementFactory.eINSTANCE.createBasicFBType();
        FBTImporter.copyBasicTypeInformation(basicType, type);
        return basicType;
    }

    protected InterfaceList parseInterfaceList(Node node) throws TypeImportException {
        InterfaceList interfaceList = LibraryElementFactory.eINSTANCE.createInterfaceList();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            List<VarDeclaration> vars;
            Node n = childNodes.item(i);
            if (n.getNodeName().equals(this.getEventInputElement())) {
                this.parseEventInputs(interfaceList, n);
            }
            if (n.getNodeName().equals(this.getEventOutputElement())) {
                this.parseEventOutputs(interfaceList, n);
            }
            if (n.getNodeName().equals("InputVars")) {
                vars = ImportUtils.parseInputVariables(n);
                for (VarDeclaration v : vars) {
                    interfaceList.getInputVars().add((Object)v);
                    this.variables.put(v.getName(), v);
                }
            }
            if (n.getNodeName().equals("OutputVars")) {
                vars = ImportUtils.parseOutputVariables(n);
                for (VarDeclaration v : vars) {
                    interfaceList.getOutputVars().add((Object)v);
                    this.variables.put(v.getName(), v);
                }
            }
            if (n.getNodeName().equals("Sockets")) {
                this.parseSockets(interfaceList, n, this.palette);
            }
            if (n.getNodeName().equals("Plugs")) {
                this.parsePlugs(interfaceList, n, this.palette);
            }
            ++i;
        }
        this.parseWithConstructs(childNodes);
        return interfaceList;
    }

    protected String getEventOutputElement() {
        return "EventOutputs";
    }

    protected String getEventInputElement() {
        return "EventInputs";
    }

    private void parsePlugs(InterfaceList interfaceList, Node node, Palette palette) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("AdapterDeclaration")) {
                AdapterDeclaration a = this.parseAdapterDeclaration(n, palette);
                a.setIsInput(false);
                this.adapters.put(a.getName(), a);
                interfaceList.getPlugs().add((Object)a);
                if (a.getType() instanceof AdapterType) {
                    this.addAdapterEventInputs(((AdapterType)a.getType()).getInterfaceList().getEventInputs(), a);
                    this.addAdapterEventOutputs(((AdapterType)a.getType()).getInterfaceList().getEventOutputs(), a);
                }
            }
            ++i;
        }
    }

    private void addAdapterEventOutputs(EList<Event> eventOutputs, AdapterDeclaration a) {
        for (Event event : eventOutputs) {
            AdapterEvent ae = ImportUtils.createAdapterEvent(event, a);
            this.outputEvents.put(ae.getName(), ae);
        }
    }

    private void addAdapterEventInputs(EList<Event> eventInputs, AdapterDeclaration a) {
        for (Event event : eventInputs) {
            AdapterEvent ae = ImportUtils.createAdapterEvent(event, a);
            this.inputEvents.put(ae.getName(), ae);
        }
    }

    private void parseSockets(InterfaceList interfaceList, Node node, Palette palette) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals("AdapterDeclaration")) {
                AdapterDeclaration a = this.parseAdapterDeclaration(n, palette);
                a.setIsInput(true);
                this.adapters.put(a.getName(), a);
                interfaceList.getSockets().add((Object)a);
                if ((AdapterType)a.getType() != null && ((AdapterType)a.getType()).getInterfaceList() != null) {
                    this.addAdapterEventInputs(((AdapterType)a.getType()).getInterfaceList().getEventOutputs(), a);
                }
                if ((AdapterType)a.getType() != null && ((AdapterType)a.getType()).getInterfaceList() != null) {
                    this.addAdapterEventOutputs(((AdapterType)a.getType()).getInterfaceList().getEventInputs(), a);
                }
            }
            ++i;
        }
    }

    private AdapterDeclaration parseAdapterDeclaration(Node node, Palette palette) throws TypeImportException {
        AdapterDeclaration a = LibraryElementFactory.eINSTANCE.createAdapterDeclaration();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            n.getNodeName().equals("Parameter");
            ++i;
        }
        NamedNodeMap map = node.getAttributes();
        CommonElementImporter.readNameCommentAttributes(a, map);
        Node typeName = map.getNamedItem("Type");
        if (typeName != null) {
            AdapterTypePaletteEntry entry = FBTImporter.getAdapterPaletEntry(typeName.getNodeValue(), palette);
            a.setPaletteEntry(entry);
            AdapterType dataType = null;
            if (entry != null) {
                dataType = entry.getAdapterType();
            }
            a.setTypeName(typeName.getNodeValue());
            if (dataType != null) {
                a.setType(dataType);
            }
        } else {
            throw new TypeImportException(Messages.FBTImporter_ADAPTER_DECLARATION_TYPE_EXCEPTION);
        }
        PositionableElement pos = LibraryElementFactory.eINSTANCE.createPositionableElement();
        CommonElementImporter.getXandY(map, pos);
        this.adapterPositions.put(a.getName(), pos);
        return a;
    }

    private void parseWithConstructs(NodeList childNodes) {
        this.parseWithConstructs(childNodes, this.inputEvents, this.outputEvents, this.variables);
    }

    public void parseWithConstructs(NodeList childNodes, Map<String, Event> eventInputs, Map<String, Event> eventOutputs, Map<String, VarDeclaration> variables) {
        int i = 0;
        while (i < childNodes.getLength()) {
            VarDeclaration v;
            With withConstruct;
            NamedNodeMap withAttributes;
            Node var;
            Node with;
            int k;
            NodeList withs;
            Event e;
            Node name;
            NamedNodeMap map;
            Node eventNode;
            int j;
            Node n = childNodes.item(i);
            if (n.getNodeName().equals(this.getEventInputElement())) {
                NodeList inputEventNodes = n.getChildNodes();
                j = 0;
                while (j < inputEventNodes.getLength()) {
                    eventNode = inputEventNodes.item(j);
                    if (eventNode.getNodeName().equals(this.getEventElement())) {
                        map = eventNode.getAttributes();
                        name = map.getNamedItem("Name");
                        e = eventInputs.get(name.getNodeValue());
                        withs = eventNode.getChildNodes();
                        k = 0;
                        while (k < withs.getLength()) {
                            with = withs.item(k);
                            if (with.getNodeName().equals("With") && (var = (withAttributes = with.getAttributes()).getNamedItem("Var")) != null) {
                                withConstruct = LibraryElementFactory.eINSTANCE.createWith();
                                e.getWith().add((Object)withConstruct);
                                v = variables.get(var.getNodeValue());
                                withConstruct.setVariables(v);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            if (n.getNodeName().equals(this.getEventOutputElement())) {
                NodeList outputEventNodes = n.getChildNodes();
                j = 0;
                while (j < outputEventNodes.getLength()) {
                    eventNode = outputEventNodes.item(j);
                    if (eventNode.getNodeName().equals(this.getEventElement())) {
                        map = eventNode.getAttributes();
                        name = map.getNamedItem("Name");
                        e = eventOutputs.get(name.getNodeValue());
                        withs = eventNode.getChildNodes();
                        k = 0;
                        while (k < withs.getLength()) {
                            with = withs.item(k);
                            if (with.getNodeName().equals("With") && (var = (withAttributes = with.getAttributes()).getNamedItem("Var")) != null) {
                                withConstruct = LibraryElementFactory.eINSTANCE.createWith();
                                e.getWith().add((Object)withConstruct);
                                v = variables.get(var.getNodeValue());
                                withConstruct.setVariables(v);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void parseEventInputs(InterfaceList interfaceList, Node node) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals(this.getEventElement())) {
                Event e = ImportUtils.parseEvent(n);
                e.setIsInput(true);
                this.inputEvents.put(e.getName(), e);
                interfaceList.getEventInputs().add((Object)e);
            }
            ++i;
        }
    }

    protected String getEventElement() {
        return "Event";
    }

    private void parseEventOutputs(InterfaceList interfaceList, Node node) throws TypeImportException {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node n = childNodes.item(i);
            if (n.getNodeName().equals(this.getEventElement())) {
                Event e = ImportUtils.parseEvent(n);
                this.outputEvents.put(e.getName(), e);
                e.setIsInput(false);
                interfaceList.getEventOutputs().add((Object)e);
            }
            ++i;
        }
    }

    public static List<String> getReferencedDataTypes(File file) {
        ArrayList<String> references = new ArrayList<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(file);
            Element rootNode = document.getDocumentElement();
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("VarDeclaration")) {
                    String dataType = "";
                    dataType = n.getAttributes().getNamedItem("Type").getNodeValue();
                    references.add(dataType);
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return references;
    }

    public static List<String> getReferencedFBTypes(File file) {
        ArrayList<String> references = new ArrayList<String>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(file);
            Element rootNode = document.getDocumentElement();
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node n = childNodes.item(i);
                if (n.getNodeName().equals("FBNetwork")) {
                    int j = 0;
                    while (j < n.getChildNodes().getLength()) {
                        Node node = n.getChildNodes().item(j);
                        if (node.getNodeName().equals("FB")) {
                            String fbType = "";
                            fbType = node.getAttributes().getNamedItem("Type").getNodeValue();
                            references.add(fbType);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return references;
    }
}

