/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.commands.Command;

public class ChangeTypeCommand
extends Command {
    private final VarDeclaration interfaceElement;
    private final DataType dataType;
    private DataType oldDataType;
    private UpdateFBTypeCommand cmd = null;

    public ChangeTypeCommand(VarDeclaration interfaceElement, DataType dataType) {
        this.interfaceElement = interfaceElement;
        this.dataType = dataType;
    }

    public void execute() {
        this.oldDataType = this.interfaceElement.getType();
        this.setNewType();
        if (this.dataType instanceof AdapterType && this.interfaceElement.eContainer().eContainer() instanceof CompositeFBType) {
            AdapterDeclaration adpDecl = (AdapterDeclaration)this.interfaceElement;
            this.cmd = new UpdateFBTypeCommand((FB)adpDecl.getAdapterFB(), adpDecl.getType().getPaletteEntry());
            this.cmd.execute();
        }
    }

    public void undo() {
        this.interfaceElement.setType(this.oldDataType);
        this.interfaceElement.setTypeName(this.oldDataType.getName());
        if (this.cmd != null) {
            this.cmd.undo();
        }
    }

    public void redo() {
        this.setNewType();
        if (this.cmd != null) {
            this.cmd.redo();
        }
    }

    private void setNewType() {
        this.interfaceElement.setType(this.dataType);
        this.interfaceElement.setTypeName(this.dataType.getName());
    }
}

