# frozen_string_literal: true

class IndexVulnerabilityReadsOnStateReportTypeSeverityTraversalIdsArchived < Gitlab::Database::Migration[2.2]
  disable_ddl_transaction!
  milestone '16.11'

  INDEX_NAME = 'index_vulnerability_reads_common_attrs_and_detection_for_groups'
  COLUMNS = %i[resolved_on_default_branch state report_type severity traversal_ids vulnerability_id].freeze

  def up
    add_concurrent_index :vulnerability_reads, COLUMNS, name: INDEX_NAME, where: 'archived = false'
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
