---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
type: reference, howto
---

# Available CI/CD variables

These CI/CD variables are specific to the browser-based DAST analyzer. They can be used to customize the behavior of
DAST to your requirements.
For authentication CI/CD variables, see [Authentication](authentication.md).

| CI/CD variable                              | Type                                                     | Example                                | Description                                                                                                                                                                                                                                                                   |
|:--------------------------------------------|:---------------------------------------------------------|----------------------------------------|:------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `DAST_ADVERTISE_SCAN`                       | boolean                                                  | `true`                                 | Set to `true` to add a `Via` header to every request sent, advertising that the request was sent as part of a GitLab DAST scan. [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/334947) in GitLab 14.1.                                                            |
| `DAST_AUTH_COOKIES`                            | string                                    |  | Set to a comma-separated list of cookie names to specify which cookies are used for authentication.                                                                                                                                                                                             |
| `DAST_AUTH_DISABLE_CLEAR_FIELDS`               | boolean                                   |  | Disables clearing of username and password fields before attempting manual login. Set to `false` by default. |
| `DAST_AUTH_REPORT`                             | boolean                                   |  | Set to `true` to generate a report detailing steps taken during the authentication process. You must also define `gl-dast-debug-auth-report.html` as a CI job artifact to be able to access the generated report. The report's content aids when debugging authentication failures.             |
| `DAST_AUTH_TYPE`                        | string                                    |  | The authentication type to use. Example: `basic-digest`.                                                                                                                                                                                                                                        |
| `DAST_AUTH_URL`                      | URL                                       |  | The URL of the page containing the login form on the target website. `DAST_USERNAME` and `DAST_PASSWORD` are submitted with the login form to create an authenticated scan. Example: `https://login.example.com`.                                                                               |
| `DAST_AUTH_VERIFICATION_LOGIN_FORM`            | boolean                                   |  | Verifies successful authentication by checking for the absence of a login form after the login form has been submitted.                                                                                                                                                                         |
| `DAST_AUTH_VERIFICATION_SELECTOR`              | [selector](authentication.md#finding-an-elements-selector) |  | A selector describing an element whose presence is used to determine if authentication has succeeded after the login form is submitted. Example: `css:.user-photo`.                                                                                                                             |
| `DAST_AUTH_VERIFICATION_URL`      | URL                                       |  | A URL that is compared to the URL in the browser to determine if authentication has succeeded after the login form is submitted. Example: `"https://example.com/loggedin_page"`. [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/207335) in GitLab 13.8.                             |
| `DAST_BROWSER_PATH_TO_LOGIN_FORM` | [selector](authentication.md#finding-an-elements-selector) |  | A comma-separated list of selectors representing elements to click on prior to entering the `DAST_USERNAME` and `DAST_PASSWORD` into the login form. Example: `"css:.navigation-menu,css:.login-menu-item"`. [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/326633) in GitLab 14.1. |
| `DAST_BROWSER_ACTION_STABILITY_TIMEOUT`     | [Duration string](https://pkg.go.dev/time#ParseDuration) | `800ms`                                | The maximum amount of time to wait for a browser to consider a page loaded and ready for analysis after completing an action.                                                                                                                                                 |
| `DAST_BROWSER_ACTION_TIMEOUT`               | [Duration string](https://pkg.go.dev/time#ParseDuration) | `7s`                                   | The maximum amount of time to wait for a browser to complete an action.                                                                                                                                                                                                       |
| `DAST_BROWSER_ALLOWED_HOSTS`                | List of strings                                          | `site.com,another.com`                 | Hostnames included in this variable are considered in scope when crawled. By default the `DAST_WEBSITE` hostname is included in the allowed hosts list. Headers set using `DAST_REQUEST_HEADERS` are added to every request made to these hostnames.                          |
| `DAST_BROWSER_COOKIES`                      | dictionary                                               | `abtesting_group:3,region:locked`      | A cookie name and value to be added to every request.                                                                                                                                                                                                                         |
| `DAST_BROWSER_CRAWL_GRAPH`                  | boolean                                                  | `true`                                 | Set to `true` to generate an SVG graph of navigation paths visited during crawl phase of the scan. You must also define `gl-dast-crawl-graph.svg` as a CI job artifact to be able to access the generated graph.                                                              |
| `DAST_BROWSER_CRAWL_TIMEOUT`                | [Duration string](https://pkg.go.dev/time#ParseDuration) | `5m`                                   | The maximum amount of time to wait for the crawl phase of the scan to complete. Defaults to `24h`.                                                                                                                                                                            |
| `DAST_BROWSER_DEVTOOLS_LOG`                 | string                                                   | `Default:messageAndBody,truncate:2000` | Set to log protocol messages between DAST and the Chromium browser.                                                                                                                                                                                                           |
| `DAST_BROWSER_DOM_READY_AFTER_TIMEOUT`      | [Duration string](https://pkg.go.dev/time#ParseDuration) | `200ms`                                | Define how long to wait for updates to the DOM before checking a page is stable. Defaults to `500ms`.                                                                                                                                                                         |
| `DAST_BROWSER_ELEMENT_TIMEOUT`              | [Duration string](https://pkg.go.dev/time#ParseDuration) | `600ms`                                | The maximum amount of time to wait for an element before determining it is ready for analysis.                                                                                                                                                                                |
| `DAST_BROWSER_EXCLUDED_ELEMENTS`            | selector                                                 | `a[href='2.html'],css:.no-follow`      | Comma-separated list of selectors that are ignored when scanning.                                                                                                                                                                                                             |
| `DAST_BROWSER_EXCLUDED_HOSTS`               | List of strings                                          | `site.com,another.com`                 | Hostnames included in this variable are considered excluded and connections are forcibly dropped.                                                                                                                                                                             |
| `DAST_BROWSER_EXTRACT_ELEMENT_TIMEOUT`      | [Duration string](https://pkg.go.dev/time#ParseDuration) | `5s`                                   | The maximum amount of time to allow the browser to extract newly found elements or navigations.                                                                                                                                                                               |
| `DAST_BROWSER_FILE_LOG`                     | List of strings                                          | `brows:debug,auth:debug`               | A list of modules and their intended logging level for use in the file log.                                                                                                                                                                                                   |
| `DAST_BROWSER_FILE_LOG_PATH`                | string                                                   | `/output/browserker.log`               | Set to the path of the file log.                                                                                                                                                                                                                                              |
| `DAST_BROWSER_IGNORED_HOSTS`                | List of strings                                          | `site.com,another.com`                 | Hostnames included in this variable are accessed, not attacked, and not reported against.                                                                                                                                                                                     |
| `DAST_BROWSER_INCLUDE_ONLY_RULES`           | List of strings                                          | `16.1,16.2,16.3`                       | Comma-separated list of check identifiers to use for the scan.                                                                                                                                                                                                                |
| `DAST_BROWSER_LOG`                          | List of strings                                          | `brows:debug,auth:debug`               | A list of modules and their intended logging level for use in the console log.                                                                                                                                                                                                |
| `DAST_BROWSER_LOG_CHROMIUM_OUTPUT`          | boolean                                                  | `true`                                 | Set to `true` to log Chromium `STDOUT` and `STDERR`.                                                                                                                                                                                                                          |
| `DAST_BROWSER_MAX_ACTIONS`                  | number                                                   | `10000`                                | The maximum number of actions that the crawler performs. For example, selecting a link, or filling a form.                                                                                                                                                                    |
| `DAST_BROWSER_MAX_DEPTH`                    | number                                                   | `10`                                   | The maximum number of chained actions that the crawler takes. For example, `Click -> Form Fill -> Click` is a depth of three.                                                                                                                                                 |
| `DAST_BROWSER_MAX_RESPONSE_SIZE_MB`         | number                                                   | `15`                                   | The maximum size of a HTTP response body. Responses with bodies larger than this are blocked by the browser. Defaults to 10 MB.                                                                                                                                               |
| `DAST_BROWSER_NAVIGATION_STABILITY_TIMEOUT` | [Duration string](https://pkg.go.dev/time#ParseDuration) | `7s`                                   | The maximum amount of time to wait for a browser to consider a page loaded and ready for analysis after a navigation completes. Defaults to `800ms`.|
| `DAST_BROWSER_NAVIGATION_TIMEOUT`           | [Duration string](https://pkg.go.dev/time#ParseDuration) | `15s`                                  | The maximum amount of time to wait for a browser to navigate from one page to another.                                                                                                                                                                                        |
| `DAST_BROWSER_NUMBER_OF_BROWSERS`           | number                                                   | `3`                                    | The maximum number of concurrent browser instances to use. For instance runners on GitLab.com, we recommended a maximum of three. Private runners with more resources may benefit from a higher number, but are likely to produce little benefit after five to seven instances. |
| `DAST_BROWSER_PAGE_LOADING_SELECTOR`        | selector                                                 | `css:#page-is-loading`                 | Selector that when is no longer visible on the page, indicates to the analyzer that the page has finished loading and the scan can continue. Cannot be used with `DAST_BROWSER_PAGE_READY_SELECTOR`.                                                                          |
| `DAST_BROWSER_PAGE_READY_SELECTOR`          | selector                                                 | `css:#page-is-ready`                   | Selector that when detected as visible on the page, indicates to the analyzer that the page has finished loading and the scan can continue. Cannot be used with `DAST_BROWSER_PAGE_LOADING_SELECTOR`.                                                                         |
| `DAST_BROWSER_PASSIVE_CHECK_WORKERS`        | int                                                      | `5`                                    | Number of workers that passive scan in parallel. Recommend setting to the number of available CPUs.                                                                                                                                                                           |
| `DAST_BROWSER_SCAN`                         | boolean                                                  | `true`                                 | Required to be `true` to run a browser-based scan.                                                                                                                                                                                                                            |
| `DAST_BROWSER_SEARCH_ELEMENT_TIMEOUT`       | [Duration string](https://pkg.go.dev/time#ParseDuration) | `3s`                                   | The maximum amount of time to allow the browser to search for new elements or user actions.                                                                                                                                                                                   |
| `DAST_BROWSER_STABILITY_TIMEOUT`            | [Duration string](https://pkg.go.dev/time#ParseDuration) | `7s`                                   | The maximum amount of time to wait for a browser to consider a page loaded and ready for analysis.                                                                                                                                                                            |
| `DAST_EXCLUDE_RULES`                        | string                                                   | `10020,10026`                          | Set to a comma-separated list of ZAP Vulnerability Rule IDs to exclude them from running during the scan. Rule IDs are numbers and can be found from the DAST log or on the [ZAP project](https://www.zaproxy.org/docs/alerts/).                                              |
| `DAST_EXCLUDE_URLS`                         | URLs                                                     | `https://example.com/.*/sign-out`      | The URLs to skip during the authenticated scan; comma-separated. Regular expression syntax can be used to match multiple URLs. For example, `.*` matches an arbitrary character sequence.                                                                                     |
| `DAST_FF_ENABLE_BAS`                        | boolean                                                  | `true`                                 | Set to `true` to [enable Breach and Attack Simulation](../../../breach_and_attack_simulation/index.md#extend-dynamic-application-security-testing-dast) during this DAST scan. |
| `DAST_FIRST_SUBMIT_FIELD`                      | [selector](authentication.md#finding-an-elements-selector) |  | A selector describing the element that is clicked on to submit the username form of a multi-page login process. For example, `css:button[type='user-submit']`. [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/9894) in GitLab 12.4.                                                 |
| `DAST_FULL_SCAN_ENABLED`                    | boolean                                                  | `true`                                 | Set to `true` to run both passive and active checks. Default: `false`                                                                                                                                                                                                         |
| `DAST_PASSWORD`                    | string                                    |  | The password to authenticate to in the website. Example: `P@55w0rd!`                                                                                                                                                                                                                            |
| `DAST_PASSWORD_FIELD`                          | [selector](authentication.md#finding-an-elements-selector) |  | A selector describing the element used to enter the password on the login form. Example: `id:password`                                                                                                                                                                                      |
| `DAST_PATHS`                                | string                                                   | `/page1.html,/category1/page3.html`    | Limit the paths scanned to a provided list. Set to a comma-separated list of URL paths relative to `DAST_WEBSITE`.                                                                                                                                                                                       |
| `DAST_PATHS_FILE`                           | string                                                   | `/builds/project/urls.txt`             | Limit the paths scanned to a provided list. Set to a file path containing a list of URL paths relative to `DAST_WEBSITE`. The file must be plain text with one path per line.                                                                                                                            |
| `DAST_PKCS12_CERTIFICATE_BASE64`            | string                                                   | `ZGZkZ2p5NGd...`                       | The PKCS12 certificate used for sites that require Mutual TLS. Must be encoded as base64 text.                                                                                                                                                                                |
| `DAST_PKCS12_PASSWORD`                      | string                                                   | `password`                             | The password of the certificate used in `DAST_PKCS12_CERTIFICATE_BASE64`. Create sensitive [custom CI/CI variables](../../../../../ci/variables/index.md#define-a-cicd-variable-in-the-ui) using the GitLab UI.                                                                     |
| `DAST_REQUEST_HEADERS`                      | string                                                   | `Cache-control:no-cache`               | Set to a comma-separated list of request header names and values.                                                                                                                                                                                                             |
| `DAST_SKIP_TARGET_CHECK`                    | boolean                                                  | `true`                                 | Set to `true` to prevent DAST from checking that the target is available before scanning. Default: `false`.                                                                                                                                                                   |
| `DAST_SUBMIT_FIELD`                            | [selector](authentication.md#finding-an-elements-selector) |  | A selector describing the element clicked on to submit the login form for a single-page login form, or the password form for a multi-page login form. For example, `css:button[type='submit']`. [Introduced](https://gitlab.com/gitlab-org/gitlab/-/issues/9894) in GitLab 12.4.                |
| `DAST_TARGET_AVAILABILITY_TIMEOUT`          | number                                                   | `60`                                   | Time limit in seconds to wait for target availability.                                                                                                                                                                                                                        |
| `DAST_USERNAME`                    | string                                    |  | The username to authenticate to in the website. Example: `admin`                                                                                                                                                                                                                                |
| `DAST_USERNAME_FIELD`              | [selector](authentication.md#finding-an-elements-selector) |  | A selector describing the element used to enter the username on the login form. Example: `name:username`                                                                                                                                                                                    |
| `DAST_WEBSITE`                              | URL                                                      | `https://example.com`                  | The URL of the website to scan.                                                                                                                                                                                                                                               |
| `SECURE_ANALYZERS_PREFIX`                   | URL                                                      | `registry.organization.com`            | Set the Docker registry base address from which to download the analyzer.                                                                                                                                                                                                     |
