# xtem version is set here
#
# Copyright (C) 2004  G. Lamprecht, W. Lotz, R. Weibezahn; IWD, Bremen University
#
###################################################################

set version "8.26"		;# sets xtem version; xtem-Version
set version_incompatible "5.04"	;# sets .vst-file compatibility
set status ""			;# xtem status ("-alpha" | "-beta" | "")
set patches ""			;# xtem applied patches

proc setTclVersions {mode} {
 global vv tclversion patchlevel email www InstDir
 global NeedsMinimumTclOlderXtem NeedsMinimumTclThisXtem UpgradeRecommendedTclOlder
 global TestedUpToTcl SeemsToBeRunningTcl stt noWarnTcl

 set NeedsMinimumTclOlderXtem   7.0
 set NeedsMinimumTclThisXtem    8.0
 set UpgradeRecommendedTclOlder 8.0
 set TestedUpToTcl              8.3.3
 set SeemsToBeRunningTcl        8.9
 set tclversion [info tclversion]; set patchlevel [info patchlevel]; # the "real version"

 if {($tclversion<$NeedsMinimumTclOlderXtem)} {

   # < 7.0:  will never run with this tcl version
   puts stdout \
	"xtem doesn't run with your old Tcl Version ($tclversion), see Installation Guide!"
   exit

 } elseif {($tclversion>=$NeedsMinimumTclOlderXtem)&&($tclversion<$NeedsMinimumTclThisXtem)} {

   puts stdout "This version of xtem presumes Tcl-version >= $NeedsMinimumTclThisXtem"
   exit

 } elseif {$tclversion<$UpgradeRecommendedTclOlder} {# upgrade of Tcl/Tk is recommended

   if {![info exists noWarnTcl]||($noWarnTcl!=$tclversion)} {
     set stt "${stt}$vv(xtq5)\n\n"
   }

 } elseif {$tclversion<=$TestedUpToTcl} {# OK

   ### for {set i 0} {$i<=1} {incr i} {after 100; mybell 3}

 } elseif {$tclversion<=$SeemsToBeRunningTcl} {# couldn't test it for myself with this Tcl/Tk!

   if {"$mode"!="startrun"} {
    if {![info exists noWarnTcl]||($noWarnTcl!=$tclversion)} {
     set stt "${stt}$vv(xtq21) $tclversion $vv(xtq22)\n$vv(xtq23)\n$vv(xtq24)\n$www\n$email\n"
    }
    mybell 1
   }

 } else {#  no information

   if {"$mode"!="startrun"} {
    if {![info exists noWarnTcl]||($noWarnTcl!=$tclversion)} {
     set stt "${stt}*** $vv(xtq21) $tclversion $vv(xtq22)\n$vv(xtq24):\n$www\n$email\n"
     set stt "${stt}\n$vv(xtq25)\n $InstDir/install.vst\n$vv(xtq26)\n noWarnTcl $tclversion\n"
    }
    mybell 4
   }

 }

 set shell ""
 if {[info commands set]!=""}	{set shell "${shell}Tcl"}
 if {[info commands pack]!=""}	{set shell "${shell}/Tk"}
 if {([info procs XiExit]=="XiExit")} {
   return "$shell"
 } elseif {($shell!="Tcl/Tk")} {
   puts stdout "\n***** Error: `wish' (Tcl/Tk) cannot be started correctly; reasons may be:"
   puts stdout "- DISPLAY variable missing or wrong, or"
   puts stdout "- X-access problems (e.g. MAGIC COOKIE, see man xauth), or"
   puts stdout "- installation error (check variable WISHCALL in file xteminstall,"
   puts stdout "                      see `Installation Guide'), or ... (?)"
   exit
 }
 
}
