/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.PacksPanelInterface;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.table.AbstractTableModel;

class PacksModel
extends AbstractTableModel {
    private static final long serialVersionUID = 3258128076746733110L;
    private List packs;
    private List packsToInstall;
    private PacksPanelInterface panel;
    private LocaleDatabase langpack;
    private int[] checkValues;
    Map namesObj;
    Map namesPos;
    private RulesEngine rules;
    private Properties variables;

    public PacksModel(PacksPanelInterface panel, InstallData idata, RulesEngine rules) {
        this(idata.availablePacks, idata.selectedPacks, panel);
        this.rules = rules;
        this.variables = idata.getVariables();
        this.updateConditions(true);
    }

    public PacksModel(List packs, List packsToInstall, PacksPanelInterface panel) {
        this.packs = packs;
        this.packsToInstall = packsToInstall;
        this.panel = panel;
        this.langpack = panel.getLangpack();
        this.checkValues = new int[packs.size()];
        this.reverseDeps();
        this.initvalues();
    }

    public void updateConditions() {
        this.updateConditions(false);
    }

    private void updateConditions(boolean initial) {
        for (int i = 0; i < this.packs.size(); ++i) {
            Pack pack = (Pack)this.packs.get(i);
            int pos = this.getPos(pack.name);
            Debug.trace("Conditions fulfilled for: " + pack.name + "?");
            if (this.rules.canInstallPack(pack.id, this.variables)) continue;
            Debug.trace("no");
            if (this.rules.canInstallPackOptional(pack.id, this.variables)) {
                Debug.trace("optional");
                Debug.trace(pack.id + " can be installed optionally.");
                if (!initial) continue;
                this.checkValues[pos] = 0;
                continue;
            }
            Debug.trace(pack.id + " can not be installed.");
            this.checkValues[pos] = -2;
        }
        this.refreshPacksToInstall();
    }

    private void reverseDeps() {
        Pack pack;
        int i;
        this.namesObj = new HashMap();
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            this.namesObj.put(pack.name, pack);
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            List deps = pack.dependencies;
            for (int j = 0; deps != null && j < deps.size(); ++j) {
                String name = (String)deps.get(j);
                Pack parent = (Pack)this.namesObj.get(name);
                parent.addRevDep(pack.name);
            }
        }
    }

    private void initvalues() {
        Pack pack;
        int i;
        this.namesPos = new HashMap();
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            this.namesPos.put(pack.name, new Integer(i));
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            if (!this.packsToInstall.contains(pack)) continue;
            this.checkValues[i] = 1;
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            if (this.checkValues[i] == 0) {
                List deps = pack.revDependencies;
                for (int j = 0; deps != null && j < deps.size(); ++j) {
                    String name = (String)deps.get(j);
                    int pos = this.getPos(name);
                    this.checkValues[pos] = -2;
                }
            }
            if (this.checkValues[i] <= 0 || pack.excludeGroup == null) continue;
            for (int q = 0; q < this.packs.size(); ++q) {
                if (q == i) continue;
                Pack otherpack = (Pack)this.packs.get(q);
                if (!pack.excludeGroup.equals(otherpack.excludeGroup) || this.checkValues[q] != 1) continue;
                this.checkValues[q] = 0;
            }
        }
        for (i = 0; i < this.packs.size(); ++i) {
            pack = (Pack)this.packs.get(i);
            if (!pack.required) continue;
            this.propRequirement(pack.name);
        }
        this.refreshPacksToInstall();
    }

    private void propRequirement(String name) {
        int pos = this.getPos(name);
        this.checkValues[pos] = -1;
        List deps = ((Pack)this.packs.get((int)pos)).dependencies;
        for (int i = 0; deps != null && i < deps.size(); ++i) {
            String s = (String)deps.get(i);
            this.propRequirement(s);
        }
    }

    private int getPos(String name) {
        return (Integer)this.namesPos.get(name);
    }

    public int getRowCount() {
        return this.packs.size();
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
        }
        return String.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.checkValues[rowIndex] < 0) {
            return false;
        }
        return columnIndex == 0;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Pack pack = (Pack)this.packs.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return new Integer(this.checkValues[rowIndex]);
            }
            case 1: {
                if (this.langpack == null || pack.id == null || pack.id.equals("")) {
                    return pack.name;
                }
                return this.langpack.getString(pack.id);
            }
            case 2: {
                return Pack.toByteUnitsString((int)pack.nbytes);
            }
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0 && aValue instanceof Integer) {
            Pack pack = (Pack)this.packs.get(rowIndex);
            if ((Integer)aValue == 1) {
                String packid = pack.id;
                if (packid != null) {
                    if (this.rules.canInstallPack(packid, this.variables) || this.rules.canInstallPackOptional(packid, this.variables)) {
                        this.checkValues[rowIndex] = pack.required ? -1 : 1;
                    }
                } else {
                    this.checkValues[rowIndex] = pack.required ? -1 : 1;
                }
            } else {
                this.checkValues[rowIndex] = 0;
            }
            this.updateExcludes(rowIndex);
            this.updateDeps();
            this.updateConditions();
            this.updateBytes();
            this.fireTableDataChanged();
            this.refreshPacksToInstall();
            this.panel.showSpaceRequired();
        }
    }

    private void refreshPacksToInstall() {
        this.packsToInstall.clear();
        for (int i = 0; i < this.packs.size(); ++i) {
            Pack pack = (Pack)this.packs.get(i);
            if (Math.abs(this.checkValues[i]) != 1) continue;
            String packid = pack.id;
            if (packid != null && this.rules != null && (this.rules.canInstallPack(packid, this.variables) || this.rules.canInstallPackOptional(packid, this.variables))) {
                this.packsToInstall.add(pack);
                continue;
            }
            this.packsToInstall.add(pack);
        }
    }

    private void updateDeps() {
        int i;
        int[] statusArray = new int[this.packs.size()];
        for (i = 0; i < statusArray.length; ++i) {
            statusArray[i] = 0;
        }
        this.dfs(statusArray);
        for (i = 0; i < statusArray.length; ++i) {
            if (statusArray[i] == 0 && this.checkValues[i] < 0) {
                int n = i;
                this.checkValues[n] = this.checkValues[n] + 2;
            }
            if (statusArray[i] != 1 || this.checkValues[i] < 0) continue;
            this.checkValues[i] = -2;
        }
        for (i = 0; i < this.packs.size(); ++i) {
            Pack pack = (Pack)this.packs.get(i);
            if (!pack.required) continue;
            String packid = pack.id;
            if (packid != null) {
                if (!this.rules.canInstallPack(packid, this.variables) && this.rules.canInstallPackOptional(packid, this.variables)) continue;
                this.propRequirement(pack.name);
                continue;
            }
            this.propRequirement(pack.name);
        }
    }

    private void updateExcludes(int rowindex) {
        int value = this.checkValues[rowindex];
        Pack pack = (Pack)this.packs.get(rowindex);
        if (value > 0 && pack.excludeGroup != null) {
            for (int q = 0; q < this.packs.size(); ++q) {
                if (rowindex == q) continue;
                Pack otherpack = (Pack)this.packs.get(q);
                String name2 = pack.excludeGroup;
                String name1 = otherpack.excludeGroup;
                if (!name2.equals(name1) || this.checkValues[q] != 1) continue;
                this.checkValues[q] = 0;
            }
        }
    }

    private void updateBytes() {
        int bytes = 0;
        for (int q = 0; q < this.packs.size(); ++q) {
            if (Math.abs(this.checkValues[q]) != 1) continue;
            Pack pack = (Pack)this.packs.get(q);
            bytes = (int)((long)bytes + pack.nbytes);
        }
        this.panel.setBytes(bytes);
    }

    private int dfs(int[] status) {
        for (int i = 0; i < this.packs.size(); ++i) {
            boolean wipe;
            for (int j = 0; j < this.packs.size(); ++j) {
                ((Pack)this.packs.get((int)j)).color = 0;
            }
            Pack pack = (Pack)this.packs.get(i);
            if (this.dfsVisit(pack, status, wipe = false) == 0) continue;
            return -1;
        }
        return 0;
    }

    private int dfsVisit(Pack u, int[] status, boolean wipe) {
        List deps;
        u.color = 1;
        int check = this.checkValues[this.getPos(u.name)];
        if (Math.abs(check) != 1) {
            wipe = true;
        }
        if ((deps = u.revDependencies) != null) {
            for (int i = 0; i < deps.size(); ++i) {
                int result;
                String name = (String)deps.get(i);
                Pack v = (Pack)this.namesObj.get(name);
                if (wipe) {
                    status[this.getPos((String)v.name)] = 1;
                }
                if (v.color != 0 || (result = this.dfsVisit(v, status, wipe)) == 0) continue;
                return result;
            }
        }
        u.color = 2;
        return 0;
    }
}

