## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup-pipeline, message = FALSE, warning = FALSE-------------------------
library(rbmiUtils)
library(rbmi)
library(dplyr)

data("ADMI", package = "rbmiUtils")
ADMI <- ADMI |>
  mutate(
    TRT = factor(TRT, levels = c("Placebo", "Drug A")),
    USUBJID = factor(USUBJID),
    AVISIT = factor(AVISIT)
  )

vars <- set_vars(
  subjid = "USUBJID", visit = "AVISIT", group = "TRT",
  outcome = "CHG", covariates = c("BASE", "STRATA", "REGION")
)
method <- method_bayes(
  n_samples = 100,
  control = control_bayes(warmup = 200, thin = 5)
)

ana_obj <- analyse_mi_data(ADMI, vars, method, fun = ancova)
pool_obj <- pool(ana_obj)

## ----describe-draws-code, eval = FALSE----------------------------------------
# data("ADEFF", package = "rbmiUtils")
# ADEFF <- ADEFF |>
#   mutate(
#     TRT = factor(TRT01P, levels = c("Placebo", "Drug A")),
#     USUBJID = factor(USUBJID),
#     AVISIT = factor(AVISIT, levels = c("Week 24", "Week 48"))
#   )
# 
# vars <- set_vars(
#   subjid = "USUBJID", visit = "AVISIT", group = "TRT",
#   outcome = "CHG", covariates = c("BASE", "STRATA", "REGION")
# )
# method <- method_bayes(
#   n_samples = 100,
#   control = control_bayes(warmup = 200, thin = 2)
# )
# 
# dat <- ADEFF |> select(USUBJID, STRATA, REGION, TRT, BASE, CHG, AVISIT)
# draws_obj <- draws(data = dat, vars = vars, method = method)
# desc <- describe_draws(draws_obj)
# print(desc)

## ----describe-imputation-code, eval = FALSE-----------------------------------
# impute_obj <- impute(
#   draws_obj,
#   references = c("Placebo" = "Placebo", "Drug A" = "Placebo")
# )
# desc <- describe_imputation(impute_obj)
# print(desc)

## ----ard-base-vs-enriched, eval = requireNamespace("cards", quietly = TRUE)----
# Base ARD (no diagnostics)
ard <- pool_to_ard(pool_obj)

# Enriched ARD with MI diagnostics
ard_enriched <- pool_to_ard(pool_obj, analysis_obj = ana_obj)

## ----ard-diagnostics, eval = requireNamespace("cards", quietly = TRUE)--------
ard_enriched |>
  dplyr::filter(stat_name %in% c("fmi", "lambda", "riv", "df.adjusted", "re")) |>
  dplyr::select(group1_level, variable_level, stat_name, stat)

