/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.common.io.text;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import uno.informatics.common.io.TextFileHandler;

public abstract class AbstractTextFileHandler
implements TextFileHandler {
    public static final int NO_OPTIONS = 0;
    protected static final DateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssZ");
    private String pathReference;
    private Path path;
    private String commentString;
    private String escapeString;
    private int currentRowSize = -1;
    private int rowPosition = -1;
    private int rowIndex = -1;
    private int columnIndex = -1;
    private boolean rowSizeSetExternally = false;
    private String delimiterString;
    private int options = 0;
    private DateFormat dateFormat = DEFAULT_DATE_FORMAT;

    protected AbstractTextFileHandler() {
    }

    public AbstractTextFileHandler(String reference) throws IOException, FileNotFoundException {
        if (reference == null) {
            throw new FileNotFoundException("File undefined");
        }
        this.setPathReference(reference);
    }

    public AbstractTextFileHandler(Path path) throws IOException, FileNotFoundException {
        if (path == null) {
            throw new FileNotFoundException("Path undefined");
        }
        this.setPath(path);
    }

    public boolean ready() {
        return true;
    }

    public final int getRowCount() {
        if (!this.ready()) {
            return -1;
        }
        return this.getRowIndex();
    }

    public final int getColumnCount() {
        if (this.getCurrentRowSize() > -1) {
            return this.getCurrentRowSize();
        }
        return -1;
    }

    public final String getCommentString() {
        return this.commentString;
    }

    public final synchronized void setCommentString(String comment) throws IOException {
        if (comment == null || comment.equals("")) {
            comment = "#";
        }
        if (!comment.equals(this.commentString)) {
            if (this.isInUse()) {
                throw new IOException("Comment string can not be set while reader/writer is in use");
            }
            this.commentString = comment;
        }
    }

    public final String getEscapeString() {
        return this.escapeString;
    }

    public final synchronized void setEscapeString(String escapeString) throws IOException {
        if (escapeString == null || escapeString.equals("")) {
            escapeString = "\\";
        }
        if (!escapeString.equals(this.escapeString)) {
            if (this.isInUse()) {
                throw new IOException("Escape string can not be set while reader/writer is in use");
            }
            this.escapeString = escapeString;
            this.escapeStringUpdated();
        }
    }

    public final String getPathReference() {
        return this.pathReference;
    }

    public final void setPathReference(String pathReference) throws IOException {
        if (this.pathReference != pathReference) {
            if (this.isInUse()) {
                throw new IOException("Path can not be changed while reader/writer is in use");
            }
            this.pathReference = pathReference;
            this.path = null;
        }
    }

    public final int getOptions() {
        return this.options;
    }

    public final void setOptions(int options) throws IOException {
        if (options != this.options) {
            if (this.isInUse()) {
                throw new IOException("Options can not be changed while reader is in use");
            }
            if (options > this.getValidOptions() || (options & this.getValidOptions()) == 0) {
                throw new IOException("One or more options were invalid : " + (options ^ this.getValidOptions()));
            }
            this.options = options;
            this.optionsUpdated();
        }
    }

    @Override
    public final Path getPath() {
        return this.path;
    }

    public final void setPath(Path path) throws IOException {
        if (this.path != path) {
            if (this.isInUse()) {
                throw new IOException("Path can not be changed while reader/writer is in use");
            }
            this.pathReference = null;
            this.path = path;
        }
    }

    public final String getDelimiterString() {
        return this.delimiterString;
    }

    public final synchronized void setDelimiterString(String delimiter) throws IOException {
        if (delimiter == null || delimiter.equals("")) {
            delimiter = "\t";
        }
        if (!delimiter.equals(this.delimiterString)) {
            if (this.isInUse()) {
                throw new IOException("Delimiter string can not be set while reader/writer is in use");
            }
            this.delimiterString = delimiter;
            this.delimeterStringUpdated();
        }
    }

    protected void initialise() throws FileNotFoundException, IOException {
        this.rowPosition = -1;
        this.rowIndex = -1;
        this.columnIndex = -1;
        this.commentString = "#";
        if (this.delimiterString == null || this.delimiterString.equals("")) {
            this.delimiterString = "\t";
        }
    }

    protected final boolean hasOption(int option) {
        return (this.options & option) > 0;
    }

    protected final void updateRowFromSize(List<Object> row) throws IOException {
        if (row != null && row.size() < this.getCurrentRowSize()) {
            for (int i = 0; i < row.size() - this.getCurrentRowSize(); ++i) {
                row.add(null);
            }
        }
    }

    public final int getCurrentRowSize() {
        return this.currentRowSize;
    }

    public final void setFixedRowSize(int rowSize) throws IOException {
        if (this.currentRowSize != rowSize) {
            if (this.isInUse()) {
                throw new IOException("Row size can not be set while reader/writer is in use");
            }
            this.setCurrentRowSize(rowSize);
        }
        this.rowSizeSetExternally = rowSize >= 0;
    }

    public final DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public final void setDateFormat(DateFormat dateFormat) throws IOException {
        if (!dateFormat.equals(this.dateFormat)) {
            if (this.isInUse()) {
                throw new IOException("Date format can not be set while reader/writer is in use");
            }
            this.dateFormat = dateFormat;
        }
    }

    protected void escapeStringUpdated() {
    }

    protected void optionsUpdated() {
    }

    protected int getValidOptions() {
        return 0;
    }

    protected void delimeterStringUpdated() {
    }

    protected final void setCurrentRowSize(int rowSize) {
        this.currentRowSize = rowSize;
    }

    protected void updateRowSize(int rowSize) {
        if (!this.rowSizeSetExternally) {
            this.setCurrentRowSize(rowSize);
        }
    }

    protected final int getRowIndex() {
        return this.rowIndex;
    }

    protected final void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }

    protected final void incrementRowIndex() {
        ++this.rowIndex;
    }

    protected final int getRowPosition() {
        return this.rowPosition;
    }

    protected final void setRowPosition(int rowPosition) {
        this.rowPosition = rowPosition;
    }

    protected final void incrementRowPosition() {
        ++this.rowPosition;
    }

    protected final boolean isInUse() {
        return this.rowIndex > -1;
    }

    protected final int getColumnIndex() {
        return this.columnIndex;
    }

    protected final void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    protected final void incrementColumnIndex() {
        ++this.columnIndex;
    }

    protected final void resetCellIndex() {
        this.columnIndex = -1;
    }

    protected final boolean isRowSizeSetExternally() {
        return this.rowSizeSetExternally;
    }
}

