## ----echo = FALSE, message = FALSE, warning = FALSE---------------------------
library(YEAB)

## ----tidy = FALSE, message = FALSE, warning = FALSE---------------------------
data("fi60_raw_from_med")
temp_file <- tempfile(fileext = ".txt")
writeLines(fi60_raw_from_med, temp_file)

example_processed <- read_med(
  fname = temp_file, save_file = FALSE,
  path_save = path_to_save, col_r = "C:", out = TRUE,
  col_names = c("time", "event"), num_col = 6, time_dot_event = TRUE
)

head(example_processed, 10)

## -----------------------------------------------------------------------------
extracted_FI15 <- event_extractor(
  data_df = example_processed,
  ev0 = 5, ev1 = 3,
  evname = "IF15"
)

head(extracted_FI15, 30)

## -----------------------------------------------------------------------------
extracted_trials_df <- list() # A list to store the resulting data frames.

param_list <- list( # A list of parameters for each trial type.
  list(ev0 = 5, ev1 = 3, evname = "IF15"),
  list(ev0 = 55, ev1 = 33, evname = "IF30")
)

for (parameters in param_list) {
  trial_df <- event_extractor(
    data_df = example_processed,
    ev0 = parameters$ev0,
    ev1 = parameters$ev1,
    evname = parameters$evname
  )
  extracted_trials_df[[length(extracted_trials_df) + 1]] <- trial_df # Store the extracted data frame in the data frames list.
}

## ----echo = FALSE-------------------------------------------------------------
for (i in seq_along(extracted_trials_df)) {
  cat("Data frame", i, ":\n")
  print(head(extracted_trials_df[[i]], 5))
}

