/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix2DTest;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseCCLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseCCMLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseRCLongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseRCMLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;

public class SparseLongMatrix2DTest
extends LongMatrix2DTest {
    public SparseLongMatrix2DTest(String string) {
        super(string);
    }

    protected void createMatrices() throws Exception {
        this.A = new SparseLongMatrix2D(this.NROWS, this.NCOLUMNS);
        this.B = new SparseLongMatrix2D(this.NROWS, this.NCOLUMNS);
        this.Bt = new SparseLongMatrix2D(this.NCOLUMNS, this.NROWS);
    }

    public void testGetRowCompressed() {
        int n;
        int n2;
        int n3 = this.NROWS * this.NCOLUMNS;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        long[] lArray = new long[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Math.abs(this.rand.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(this.rand.nextInt() % this.NCOLUMNS);
            lArray[i] = this.rand.nextLong();
        }
        SparseLongMatrix2D sparseLongMatrix2D = new SparseLongMatrix2D(this.NROWS, this.NCOLUMNS, nArray, nArray2, lArray);
        SparseRCLongMatrix2D sparseRCLongMatrix2D = sparseLongMatrix2D.getRowCompressed(false);
        for (n2 = 0; n2 < sparseLongMatrix2D.rows(); ++n2) {
            for (n = 0; n < sparseLongMatrix2D.columns(); ++n) {
                SparseLongMatrix2DTest.assertEquals((long)sparseLongMatrix2D.getQuick(n2, n), (long)sparseRCLongMatrix2D.getQuick(n2, n));
            }
        }
        sparseRCLongMatrix2D = sparseLongMatrix2D.getRowCompressed(true);
        for (n2 = 0; n2 < sparseLongMatrix2D.rows(); ++n2) {
            for (n = 0; n < sparseLongMatrix2D.columns(); ++n) {
                SparseLongMatrix2DTest.assertEquals((long)sparseLongMatrix2D.getQuick(n2, n), (long)sparseRCLongMatrix2D.getQuick(n2, n));
            }
        }
    }

    public void testGetRowCompressedModified() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Math.abs(this.rand.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(this.rand.nextInt() % this.NCOLUMNS);
            lArray[i] = this.rand.nextLong();
        }
        SparseLongMatrix2D sparseLongMatrix2D = new SparseLongMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, lArray);
        SparseRCMLongMatrix2D sparseRCMLongMatrix2D = sparseLongMatrix2D.getRowCompressedModified();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseLongMatrix2DTest.assertEquals((long)sparseLongMatrix2D.getQuick(i, j), (long)sparseRCMLongMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testGetColumnCompressed() {
        int n;
        int n2;
        int n3 = this.A.rows() * this.A.columns();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        long[] lArray = new long[n3];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = Math.abs(this.rand.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(this.rand.nextInt() % this.NCOLUMNS);
            lArray[i] = this.rand.nextLong();
        }
        SparseLongMatrix2D sparseLongMatrix2D = new SparseLongMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, lArray);
        SparseCCLongMatrix2D sparseCCLongMatrix2D = sparseLongMatrix2D.getColumnCompressed(false);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                SparseLongMatrix2DTest.assertEquals((long)sparseLongMatrix2D.getQuick(n2, n), (long)sparseCCLongMatrix2D.getQuick(n2, n));
            }
        }
        sparseCCLongMatrix2D = sparseLongMatrix2D.getColumnCompressed(true);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                SparseLongMatrix2DTest.assertEquals((long)sparseLongMatrix2D.getQuick(n2, n), (long)sparseCCLongMatrix2D.getQuick(n2, n));
            }
        }
    }

    public void testGetColumnCompressedModified() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = Math.abs(this.rand.nextInt() % this.NROWS);
            nArray2[i] = Math.abs(this.rand.nextInt() % this.NCOLUMNS);
            lArray[i] = this.rand.nextLong();
        }
        SparseLongMatrix2D sparseLongMatrix2D = new SparseLongMatrix2D(this.A.rows(), this.A.columns(), nArray, nArray2, lArray);
        SparseCCMLongMatrix2D sparseCCMLongMatrix2D = sparseLongMatrix2D.getColumnCompressedModified();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseLongMatrix2DTest.assertEquals((long)sparseLongMatrix2D.getQuick(i, j), (long)sparseCCMLongMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testAssignIntArrayIntArrayLongArrayLongLongFunction() {
        int n = this.A.rows() * this.A.columns();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        long[] lArray = new long[n];
        DenseLongMatrix2D denseLongMatrix2D = new DenseLongMatrix2D(this.A.rows(), this.A.columns());
        for (int i = 0; i < n; ++i) {
            nArray[i] = i % this.A.rows();
            nArray2[i] = i % this.A.columns();
            lArray[i] = this.rand.nextLong();
            ((LongMatrix2D)denseLongMatrix2D).setQuick(nArray[i], nArray2[i], lArray[i]);
        }
        SparseLongMatrix2D sparseLongMatrix2D = new SparseLongMatrix2D(this.A.rows(), this.A.columns());
        sparseLongMatrix2D.assign(nArray, nArray2, lArray, LongFunctions.multSecond(2L));
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                SparseLongMatrix2DTest.assertEquals((long)(2L * ((LongMatrix2D)denseLongMatrix2D).getQuick(i, j)), (long)sparseLongMatrix2D.getQuick(i, j));
            }
        }
    }
}

