/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;

class SelectedDenseLongMatrix1D
extends LongMatrix1D {
    private static final long serialVersionUID = 1L;
    protected long[] elements;
    protected int[] offsets;
    protected int offset;

    protected SelectedDenseLongMatrix1D(long[] lArray, int[] nArray) {
        this(nArray.length, lArray, 0, 1, nArray, 0);
    }

    protected SelectedDenseLongMatrix1D(int n, long[] lArray, int n2, int n3, int[] nArray, int n4) {
        this.setUp(n, n2, n3);
        this.elements = lArray;
        this.offsets = nArray;
        this.offset = n4;
        this.isNoView = false;
    }

    public long[] elements() {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public long getQuick(int n) {
        return this.elements[this.offset + this.offsets[this.zero + n * this.stride]];
    }

    public long index(int n) {
        return this.offset + this.offsets[this.zero + n * this.stride];
    }

    public LongMatrix1D like(int n) {
        return new DenseLongMatrix1D(n);
    }

    public LongMatrix2D like2D(int n, int n2) {
        return new DenseLongMatrix2D(n, n2);
    }

    public LongMatrix2D reshape(int n, int n2) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public LongMatrix3D reshape(int n, int n2, int n3) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    public void setQuick(int n, long l) {
        this.elements[this.offset + this.offsets[this.zero + n * this.stride]] = l;
    }

    protected int _offset(int n) {
        return this.offsets[n];
    }

    protected boolean haveSharedCellsRaw(LongMatrix1D longMatrix1D) {
        if (longMatrix1D instanceof SelectedDenseLongMatrix1D) {
            SelectedDenseLongMatrix1D selectedDenseLongMatrix1D = (SelectedDenseLongMatrix1D)longMatrix1D;
            return this.elements == selectedDenseLongMatrix1D.elements;
        }
        if (longMatrix1D instanceof DenseLongMatrix1D) {
            DenseLongMatrix1D denseLongMatrix1D = (DenseLongMatrix1D)longMatrix1D;
            return this.elements == denseLongMatrix1D.elements;
        }
        return false;
    }

    protected void setUp(int n) {
        super.setUp(n);
        this.stride = 1;
        this.offset = 0;
    }

    protected LongMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedDenseLongMatrix1D(this.elements, nArray);
    }
}

