/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.reification;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.constraints.ImpliedConstraint;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

public class PropImplied
extends Propagator<Variable> {
    private final BoolVar bVar;
    private final Constraint trueCons;
    private ImpliedConstraint reifCons;

    public PropImplied(Variable[] allVars, Constraint consIfBoolTrue) {
        super(allVars, (Priority)PropImplied.computePrority(consIfBoolTrue), false);
        this.bVar = (BoolVar)this.vars[0];
        this.trueCons = consIfBoolTrue;
    }

    public void setReifCons(ImpliedConstraint reifCons) {
        assert (this.reifCons == null) : "cannot change the ReificationConstraint of a PropReif";
        this.reifCons = reifCons;
    }

    private static PropagatorPriority computePrority(Constraint consIfBoolTrue) {
        int p = consIfBoolTrue.computeMaxPriority().priority;
        return PropagatorPriority.get(Math.max(p, PropagatorPriority.TERNARY.priority));
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        if (this.bVar.isInstantiated()) {
            this.setPassive();
            if (this.bVar.getBooleanValue() == ESat.TRUE) {
                this.reifCons.activate(0);
            }
        } else {
            ESat sat = this.trueCons.isSatisfied();
            if (sat == ESat.FALSE) {
                this.bVar.setToFalse(this);
                this.setPassive();
            }
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.bVar.isInstantiated()) {
            if (this.bVar.getValue() == 1) {
                return this.trueCons.isSatisfied();
            }
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return this.bVar.toString() + "=>" + this.trueCons.toString();
    }
}

