/*
 * Decompiled with CFR 0.152.
 */
package bartMachine;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import jdk.incubator.vector.DoubleVector;
import jdk.incubator.vector.IntVector;
import jdk.incubator.vector.Vector;
import jdk.incubator.vector.VectorOperators;
import jdk.incubator.vector.VectorSpecies;

public class Tools {
    public static String StringJoin(ArrayList arrayList, String string) {
        if (arrayList == null) {
            return " NULL ARRAY ";
        }
        return Tools.StringJoin(arrayList.toArray(), string);
    }

    public static String StringJoin(IntArrayList intArrayList, String string) {
        if (intArrayList == null) {
            return " NULL ARRAY ";
        }
        return Tools.StringJoin(intArrayList.toIntArray(), string);
    }

    public static String StringJoin(double[] dArray, String string) {
        if (dArray == null) {
            return " NULL ARRAY ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < dArray.length; ++i) {
            stringBuilder.append(dArray[i]);
            if (i >= dArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String StringJoin(int[] nArray, String string) {
        if (nArray == null) {
            return " NULL ARRAY ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            if (i >= nArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String StringJoin(IntArrayList intArrayList) {
        return Tools.StringJoin(intArrayList.toIntArray(), ", ");
    }

    public static String StringJoin(boolean[] blArray) {
        int[] nArray = new int[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            nArray[i] = blArray[i] ? 1 : 0;
        }
        return Tools.StringJoin(nArray, ", ");
    }

    public static String StringJoin(int[] nArray) {
        return Tools.StringJoin(nArray, ", ");
    }

    public static String StringJoin(DoubleArrayList doubleArrayList) {
        return Tools.StringJoin(doubleArrayList.toDoubleArray(), ", ");
    }

    public static String StringJoin(double[] dArray) {
        return Tools.StringJoin(dArray, ", ");
    }

    public static String StringJoin(ArrayList<Object> arrayList) {
        return Tools.StringJoin(arrayList, ", ");
    }

    public static String StringJoin(Object[] objectArray, String string) {
        if (objectArray == null) {
            return " NULL ARRAY ";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuilder.append(objectArray[i]);
            if (i >= objectArray.length - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String StringJoin(Object[] objectArray) {
        return Tools.StringJoin(objectArray, ", ");
    }

    public static String StringJoinStrings(Collection<String> collection, String string) {
        Object[] objectArray = collection.toArray();
        Object object = "";
        for (int i = 0; i < objectArray.length; ++i) {
            object = (String)object + (String)objectArray[i];
            if (i >= objectArray.length - 1) continue;
            object = (String)object + string;
        }
        return object;
    }

    public static String StringJoin(Collection<String> collection) {
        return Tools.StringJoinStrings(collection, ", ");
    }

    public static double max(double[] dArray) {
        int n;
        if (dArray == null || dArray.length == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        DoubleVector doubleVector = DoubleVector.broadcast((VectorSpecies)vectorSpecies, (double)Double.NEGATIVE_INFINITY);
        int n2 = vectorSpecies.loopBound(dArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            DoubleVector doubleVector2 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            doubleVector = doubleVector.max((Vector)doubleVector2);
        }
        double d = doubleVector.reduceLanes(VectorOperators.MAX);
        while (n < dArray.length) {
            if (dArray[n] > d) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static double sum_array(double[] dArray) {
        int n;
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        DoubleVector doubleVector = DoubleVector.zero((VectorSpecies)vectorSpecies);
        int n2 = vectorSpecies.loopBound(dArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            DoubleVector doubleVector2 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            doubleVector = doubleVector.add((Vector)doubleVector2);
        }
        double d = doubleVector.reduceLanes(VectorOperators.ADD);
        while (n < dArray.length) {
            d += dArray[n];
            ++n;
        }
        return d;
    }

    public static int sum_array(boolean[] blArray) {
        int n = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n;
        }
        return n;
    }

    public static double sum_inv_array(double[] dArray) {
        int n;
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        DoubleVector doubleVector = DoubleVector.zero((VectorSpecies)vectorSpecies);
        DoubleVector doubleVector2 = DoubleVector.broadcast((VectorSpecies)vectorSpecies, (double)1.0);
        int n2 = vectorSpecies.loopBound(dArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            DoubleVector doubleVector3 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            doubleVector = doubleVector.add((Vector)doubleVector2.div((Vector)doubleVector3));
        }
        double d = doubleVector.reduceLanes(VectorOperators.ADD);
        while (n < dArray.length) {
            d += 1.0 / dArray[n];
            ++n;
        }
        return d;
    }

    public static void normalize_array(double[] dArray) {
        int n;
        double d = Tools.sum_array(dArray);
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        int n2 = vectorSpecies.loopBound(dArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            DoubleVector doubleVector = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            doubleVector.div(d).intoArray(dArray, n);
        }
        while (n < dArray.length) {
            dArray[n] = dArray[n] / d;
            ++n;
        }
    }

    public static void weight_arr(double[] dArray, double d) {
        int n;
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        int n2 = vectorSpecies.loopBound(dArray.length);
        for (n = 0; n < n2; n += vectorSpecies.length()) {
            DoubleVector doubleVector = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            doubleVector.div(d).intoArray(dArray, n);
        }
        while (n < dArray.length) {
            dArray[n] = dArray[n] / d;
            ++n;
        }
    }

    public static double[] subtract_arrays(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        double[] dArray3 = new double[n2];
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        int n3 = vectorSpecies.loopBound(n2);
        for (n = 0; n < n3; n += vectorSpecies.length()) {
            DoubleVector doubleVector = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            DoubleVector doubleVector2 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray2, (int)n);
            doubleVector.sub((Vector)doubleVector2).intoArray(dArray3, n);
        }
        while (n < n2) {
            dArray3[n] = dArray[n] - dArray2[n];
            ++n;
        }
        return dArray3;
    }

    public static double[] add_arrays(double[] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        double[] dArray3 = new double[n2];
        VectorSpecies vectorSpecies = DoubleVector.SPECIES_PREFERRED;
        int n3 = vectorSpecies.loopBound(n2);
        for (n = 0; n < n3; n += vectorSpecies.length()) {
            DoubleVector doubleVector = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray, (int)n);
            DoubleVector doubleVector2 = DoubleVector.fromArray((VectorSpecies)vectorSpecies, (double[])dArray2, (int)n);
            doubleVector.add((Vector)doubleVector2).intoArray(dArray3, n);
        }
        while (n < n2) {
            dArray3[n] = dArray[n] + dArray2[n];
            ++n;
        }
        return dArray3;
    }

    public static double[] add_arrays(double[] dArray, int[] nArray) {
        int n = dArray.length;
        double[] dArray2 = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] + (double)nArray[i];
        }
        return dArray2;
    }

    public static int[] add_arrays(int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray.length;
        int[] nArray3 = new int[n2];
        VectorSpecies vectorSpecies = IntVector.SPECIES_PREFERRED;
        int n3 = vectorSpecies.loopBound(n2);
        for (n = 0; n < n3; n += vectorSpecies.length()) {
            IntVector intVector = IntVector.fromArray((VectorSpecies)vectorSpecies, (int[])nArray, (int)n);
            IntVector intVector2 = IntVector.fromArray((VectorSpecies)vectorSpecies, (int[])nArray2, (int)n);
            intVector.add((Vector)intVector2).intoArray(nArray3, n);
        }
        while (n < n2) {
            nArray3[n] = nArray[n] + nArray2[n];
            ++n;
        }
        return nArray3;
    }

    public static int[] binary_add_arrays(int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray.length;
        int[] nArray3 = new int[n2];
        VectorSpecies vectorSpecies = IntVector.SPECIES_PREFERRED;
        IntVector intVector = IntVector.zero((VectorSpecies)vectorSpecies);
        int n3 = vectorSpecies.loopBound(n2);
        for (n = 0; n < n3; n += vectorSpecies.length()) {
            IntVector intVector2 = IntVector.fromArray((VectorSpecies)vectorSpecies, (int[])nArray, (int)n);
            IntVector intVector3 = IntVector.fromArray((VectorSpecies)vectorSpecies, (int[])nArray2, (int)n);
            IntVector intVector4 = intVector.add(1, intVector2.compare(VectorOperators.GE, 1));
            IntVector intVector5 = intVector.add(1, intVector3.compare(VectorOperators.GE, 1));
            intVector4.add((Vector)intVector5).intoArray(nArray3, n);
        }
        while (n < n2) {
            nArray3[n] = (nArray[n] >= 1 ? 1 : 0) + (nArray2[n] >= 1 ? 1 : 0);
            ++n;
        }
        return nArray3;
    }
}

