## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  out.width = "100%"
)
library(typstable)

# Pre-built figures in vignettes/figures/
# since svg rendering requires Typst CLI
fig_counter <- 0
render_table <- function(tbl) {
  fig_counter <<- fig_counter + 1
  knitr::include_graphics(paste0("figures/table-", fig_counter, ".svg"))
}

## ----table-1------------------------------------------------------------------
library(typstable)
sans_font <- '#set text(font: "Arial")'
tbl <- tt(mtcars[1:5, 1:3], preamble = sans_font)
tbl

## ----fig-1, echo = FALSE------------------------------------------------------
render_table(tbl)

## ----table-2------------------------------------------------------------------
tbl <- tt(mtcars[1:5, 1:3], preamble = sans_font) |>
  tt_column(2:4, align = "center") |>
  tt_row(3, fill = "yellow") |>
  tt_cell(2, 2, bold = TRUE, rotate = 45, fill = "lightgrey")
tbl

## ----fig-2, echo = FALSE------------------------------------------------------
render_table(tbl)

## ----table-3------------------------------------------------------------------
tbl <- tt(mtcars[1:5, 1:3],
          col_names = c("", "Miles/Gallon", "Cylinders", "Displacement"),
          preamble = sans_font) |>
  tt_style(
    striped = TRUE,
    inset = "4pt"
  )
tbl

## ----fig-3, echo = FALSE------------------------------------------------------
render_table(tbl)

## ----table-4------------------------------------------------------------------
tbl <- tt(mtcars[1:5, 1:3], preamble = sans_font) |>
  tt_style(stroke = TRUE) |>
  tt_widths(.rownames=8,mpg=1,cyl=1,disp=1)

## ----fig-4, echo = FALSE------------------------------------------------------
render_table(tbl)

## ----table-5------------------------------------------------------------------
tbl <- tt(mtcars[1:6, c("mpg", "qsec", "cyl", "disp", "hp", "wt")], preamble = sans_font) |>
  tt_header_above(c(" " = 1, "Performance" = 2, "Characteristics" = 4), gap='5pt') |>
  tt_column(1, width = "25%")
tbl

## ----fig-5, echo = FALSE------------------------------------------------------
render_table(tbl)

## ----table-6------------------------------------------------------------------
cars <- mtcars[order(mtcars$cyl), c("mpg", "disp", "hp", "wt", "cyl")]
cars <- do.call(dplyr::bind_rows, lapply(split(cars, cars$cyl), head, 3))
groups <- table(cars$cyl)
groups <- setNames(as.integer(groups), paste(names(groups), "Cylinders"))
tbl <- tt(cars, cols = c(.rownames, mpg, disp, hp, wt), preamble = sans_font) |>
  tt_pack_rows(index = groups) |>
  tt_column(1, width = "30%")
tbl

## ----fig-6, echo = FALSE------------------------------------------------------
render_table(tbl)

