/*
 * Decompiled with CFR 0.152.
 */
package dmLab.utils.cmatrix;

import dmLab.utils.GeneralUtils;
import dmLab.utils.cmatrix.QualityMeasure;

public final class ConfusionMatrix {
    private String decision;
    private double[][] confusionMatrix;
    private String[] decValuesStr;
    private String[] decValuesStrDict;
    private float[] decValuesDbl;
    private boolean printAttrDictList;
    private int maxSize = 10;

    public final double[][] getMatrix() {
        return this.confusionMatrix;
    }

    /*
     * WARNING - void declaration
     */
    public ConfusionMatrix(String decision, float[] decisionValuesDbl, String[] decisionValuesStr) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.decision = var1_1;
        this.decValuesDbl = var2_2;
        this.decValuesStr = decisionValuesStr;
        this.decValuesStrDict = new String[((void)var3_3).length];
        this.printAttrDictList = false;
        this.createDecValuesStrDict();
        this.confusionMatrix = new double[this.decValuesDbl.length + 1][this.decValuesDbl.length + 1];
    }

    /*
     * WARNING - void declaration
     */
    public ConfusionMatrix(String decision, String[] decisionValuesStr) {
        void var2_2;
        void var1_1;
        this.decision = var1_1;
        this.decValuesDbl = null;
        this.decValuesStr = decisionValuesStr;
        this.decValuesStrDict = new String[decisionValuesStr.length];
        this.printAttrDictList = false;
        this.createDecValuesStrDict();
        this.confusionMatrix = new double[decisionValuesStr.length + 1][((void)var2_2).length + 1];
    }

    private void createDecValuesStrDict() {
        for (int i = 0; i < this.decValuesStrDict.length; ++i) {
            if (this.decValuesStr[i].length() < this.maxSize) {
                this.decValuesStrDict[i] = this.decValuesStr[i];
                continue;
            }
            this.decValuesStrDict[i] = "val_" + i;
            this.printAttrDictList = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private String labelsToString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("Captions:\n");
        for (int i = 0; i < this.decValuesStrDict.length; ++i) {
            if (this.decValuesStrDict[i].equalsIgnoreCase(this.decValuesStr[i])) continue;
            tmp.append(this.decValuesStrDict[i] + "=" + this.decValuesStr[i]).append("\n");
        }
        tmp.append("\n");
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void add(double realDecision, double predictedDecision) {
        void var3_2;
        void var1_1;
        double[] dArray = this.confusionMatrix[this.findIndex((double)var1_1)];
        int n = this.findIndex((double)var3_2);
        dArray[n] = dArray[n] + 1.0;
    }

    /*
     * WARNING - void declaration
     */
    public final void add(String realDecision, String predictedDecision) {
        void var2_2;
        void var1_1;
        double[] dArray = this.confusionMatrix[this.findIndex((String)var1_1)];
        int n = this.findIndex((String)var2_2);
        dArray[n] = dArray[n] + 1.0;
    }

    public final void add(ConfusionMatrix SourceConfusionMatrix) {
        for (int i = 0; i < this.confusionMatrix.length; ++i) {
            for (int j = 0; j < this.confusionMatrix.length; ++j) {
                double[] dArray = this.confusionMatrix[i];
                int n = j;
                dArray[n] = dArray[n] + SourceConfusionMatrix.confusionMatrix[i][j];
            }
        }
    }

    private int findIndex(String decisionValue) {
        for (int i = 0; i < this.decValuesStr.length; ++i) {
            if (!this.decValuesStr[i].equalsIgnoreCase(decisionValue)) continue;
            return i;
        }
        return this.decValuesStr.length;
    }

    private int findIndex(double decisionValue) {
        if (decisionValue == -1.0) {
            return this.decValuesDbl.length;
        }
        for (int index = 0; index < this.decValuesDbl.length; ++index) {
            if ((double)this.decValuesDbl[index] != decisionValue) continue;
            return index;
        }
        return this.decValuesDbl.length;
    }

    public final String toString() {
        return this.toString(true, false, true, "\t");
    }

    public final String toString(boolean header, boolean fullClassLabels, boolean showOther, String sep) {
        StringBuffer tmp = new StringBuffer();
        if (this.printAttrDictList && !fullClassLabels) {
            tmp.append(this.labelsToString());
        }
        if (header) {
            tmp.append("Confusion Matrix\n");
            tmp.append("\t\t\tpredicted\n");
        }
        String[] decValuesTmp = this.decValuesStrDict;
        if (fullClassLabels) {
            decValuesTmp = this.decValuesStr;
        }
        tmp.append(this.decision);
        for (int i = 0; i < decValuesTmp.length; ++i) {
            tmp.append(sep).append(decValuesTmp[i]);
        }
        if (showOther) {
            tmp.append(sep).append("other");
        }
        tmp.append("\n");
        int size = this.confusionMatrix.length;
        if (!showOther) {
            size = this.confusionMatrix.length - 1;
        }
        for (int i = 0; i < size; ++i) {
            if (i < decValuesTmp.length) {
                tmp.append(decValuesTmp[i]);
            } else {
                tmp.append("other");
            }
            for (int j = 0; j < size; ++j) {
                tmp.append(sep).append("" + this.confusionMatrix[i][j]);
            }
            tmp.append("\n");
        }
        tmp.append("\n");
        return tmp.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final String statsToString(int precision, boolean extended) {
        void var3_3;
        StringBuffer tmp = new StringBuffer();
        if (extended) {
            int i;
            tmp.append("Accuracy = " + GeneralUtils.formatFloat(QualityMeasure.calcAcc(this.confusionMatrix), precision)).append("\n");
            tmp.append("WeightedAccuracy = " + GeneralUtils.formatFloat(QualityMeasure.calcWAcc(this.confusionMatrix), precision)).append("\n");
            tmp.append("True Positive Rate\n");
            for (i = 0; i < this.decValuesStr.length; ++i) {
                tmp.append("\t" + this.decValuesStr[i] + ": " + GeneralUtils.formatFloat(QualityMeasure.calcTPRate(this.confusionMatrix, i), precision)).append("\n");
            }
            tmp.append("False Positive Rate\n");
            for (i = 0; i < this.decValuesStr.length; ++i) {
                tmp.append("\t" + this.decValuesStr[i] + ": " + GeneralUtils.formatFloat(QualityMeasure.calcFPRate(this.confusionMatrix, i), precision)).append("\n");
            }
        } else {
            void var1_1;
            tmp.append("Accuracy = " + GeneralUtils.formatFloat(100.0 * QualityMeasure.calcAcc(this.confusionMatrix), precision)).append("%\n");
            tmp.append("WeightedAccuracy = " + GeneralUtils.formatFloat(100.0 * QualityMeasure.calcWAcc(this.confusionMatrix), (int)var1_1)).append("%\n");
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final float calcMeasure(int measure) {
        void var1_1;
        if (measure == QualityMeasure.ACC) {
            return (float)QualityMeasure.calcAcc(this.confusionMatrix);
        }
        if (var1_1 == QualityMeasure.WACC) {
            return (float)QualityMeasure.calcWAcc(this.confusionMatrix);
        }
        return Float.NaN;
    }

    public final void cleanMatrix() {
        this.confusionMatrix = new double[this.decValuesStr.length + 1][this.decValuesStr.length + 1];
    }
}

