/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.table;

import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.LinesKt;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.rendering.WidthRange;
import com.github.ajalt.mordant.table.Borders;
import com.github.ajalt.mordant.table.Cell;
import com.github.ajalt.mordant.table.ColumnWidth;
import com.github.ajalt.mordant.table.TableBuilderInstance;
import com.github.ajalt.mordant.table.TableDslKt;
import com.github.ajalt.mordant.table.TableLayout;
import com.github.ajalt.mordant.table.VerticalLayoutCell;
import com.github.ajalt.mordant.terminal.Terminal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B5\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/mordant/table/VerticalLayout;", "Lcom/github/ajalt/mordant/rendering/Widget;", "cells", "", "Lcom/github/ajalt/mordant/table/VerticalLayoutCell;", "spacing", "", "columnWidth", "Lcom/github/ajalt/mordant/table/ColumnWidth;", "textAlign", "Lcom/github/ajalt/mordant/rendering/TextAlign;", "hasAlignedCells", "", "(Ljava/util/List;ILcom/github/ajalt/mordant/table/ColumnWidth;Lcom/github/ajalt/mordant/rendering/TextAlign;Z)V", "measure", "Lcom/github/ajalt/mordant/rendering/WidthRange;", "t", "Lcom/github/ajalt/mordant/terminal/Terminal;", "width", "render", "Lcom/github/ajalt/mordant/rendering/Lines;", "Companion", "mordant"})
@SourceDebugExtension(value={"SMAP\nVerticalLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerticalLayout.kt\ncom/github/ajalt/mordant/table/VerticalLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 WidthRange.kt\ncom/github/ajalt/mordant/rendering/WidthRangeKt\n*L\n1#1,84:1\n1#2:85\n27#3,12:86\n*S KotlinDebug\n*F\n+ 1 VerticalLayout.kt\ncom/github/ajalt/mordant/table/VerticalLayout\n*L\n53#1:86,12\n*E\n"})
public final class VerticalLayout
implements Widget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<VerticalLayoutCell> cells;
    private final int spacing;
    @NotNull
    private final ColumnWidth columnWidth;
    @NotNull
    private final TextAlign textAlign;
    private final boolean hasAlignedCells;

    private VerticalLayout(List<VerticalLayoutCell> cells2, int spacing, ColumnWidth columnWidth, TextAlign textAlign2, boolean hasAlignedCells) {
        this.cells = cells2;
        this.spacing = spacing;
        this.columnWidth = columnWidth;
        this.textAlign = textAlign2;
        this.hasAlignedCells = hasAlignedCells;
        if (!(this.spacing >= 0)) {
            boolean bl = false;
            String string = "layout spacing cannot be negative";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public WidthRange measure(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        Iterable $this$maxWidthRange_u24default$iv = this.cells;
        int paddingWidth$iv = 0;
        boolean $i$f$maxWidthRange = false;
        int max$iv = 0;
        int min$iv = 0;
        for (Object it$iv : $this$maxWidthRange_u24default$iv) {
            WidthRange range$iv;
            VerticalLayoutCell it = (VerticalLayoutCell)it$iv;
            boolean bl = false;
            if (it.getContent().measure(t, width) == null) continue;
            max$iv = Math.max(max$iv, range$iv.getMax());
            min$iv = Math.max(min$iv, range$iv.getMin());
        }
        return new WidthRange(min$iv + paddingWidth$iv, max$iv + paddingWidth$iv);
    }

    @Override
    @NotNull
    public Lines render(@NotNull Terminal t, int width) {
        Intrinsics.checkNotNullParameter(t, "t");
        int renderWidth = this.columnWidth instanceof ColumnWidth.Expand ? width : (this.hasAlignedCells ? this.measure(t, width).getMax() : width);
        List lines = new ArrayList();
        Line spacingLine = WhenMappings.$EnumSwitchMapping$0[this.textAlign.ordinal()] == 1 ? ConstantsKt.getEMPTY_LINE() : new Line(CollectionsKt.listOf(Span.Companion.space$default(Span.Companion, renderWidth, null, 2, null)), ConstantsKt.getDEFAULT_STYLE());
        Iterator<VerticalLayoutCell> iterator2 = this.cells.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            List<Line> list;
            int i = n++;
            VerticalLayoutCell cell2 = iterator2.next();
            if (i > 0) {
                int n2 = this.spacing;
                int n3 = 0;
                while (n3 < n2) {
                    int it = n3++;
                    boolean bl = false;
                    ((Collection)lines).add(spacingLine);
                }
            }
            Lines rendered = cell2.getContent().render(t, renderWidth).withStyle(cell2.getStyle());
            ColumnWidth.Custom w = TableDslKt.toCustom(this.columnWidth);
            rendered = w.getExpandWeight() != null ? LinesKt.setSize$default(rendered, width, 0, null, cell2.getTextAlign(), 0, 0, 54, null) : (w.getWidth() != null ? LinesKt.setSize$default(rendered, w.getWidth(), 0, null, cell2.getTextAlign(), 0, 0, 54, null) : (cell2.getTextAlign() != TextAlign.NONE ? LinesKt.setSize$default(rendered, renderWidth, 0, null, cell2.getTextAlign(), 0, 0, 54, null) : rendered));
            Collection collection = lines;
            Iterable<Line> iterable = rendered.getLines();
            if (iterable.isEmpty()) {
                boolean bl = false;
                list = CollectionsKt.listOf(ConstantsKt.getEMPTY_LINE());
            } else {
                list = iterable;
            }
            iterable = list;
            CollectionsKt.addAll(collection, iterable);
        }
        return new Lines(lines);
    }

    public /* synthetic */ VerticalLayout(List cells2, int spacing, ColumnWidth columnWidth, TextAlign textAlign2, boolean hasAlignedCells, DefaultConstructorMarker $constructor_marker) {
        this(cells2, spacing, columnWidth, textAlign2, hasAlignedCells);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/github/ajalt/mordant/table/VerticalLayout$Companion;", "", "()V", "fromTableBuilder", "Lcom/github/ajalt/mordant/table/VerticalLayout;", "builder", "Lcom/github/ajalt/mordant/table/TableBuilderInstance;", "spacing", "", "columnWidth", "Lcom/github/ajalt/mordant/table/ColumnWidth;", "mordant"})
    @SourceDebugExtension(value={"SMAP\nVerticalLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerticalLayout.kt\ncom/github/ajalt/mordant/table/VerticalLayout$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,84:1\n1549#2:85\n1620#2,3:86\n*S KotlinDebug\n*F\n+ 1 VerticalLayout.kt\ncom/github/ajalt/mordant/table/VerticalLayout$Companion\n*L\n32#1:85\n32#1:86,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final VerticalLayout fromTableBuilder(@NotNull TableBuilderInstance builder2, int spacing, @NotNull ColumnWidth columnWidth) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(builder2, "builder");
            Intrinsics.checkNotNullParameter(columnWidth, "columnWidth");
            builder2.padding(0);
            builder2.setCellBorders(Borders.NONE);
            builder2.setTableBorders(Borders.NONE);
            boolean aligned = false;
            Iterable $this$map$iv = new TableLayout(builder2).buildTable().getRows();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TextAlign[] textAlignArray;
                void it;
                List list = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (!(it.size() == 1)) {
                    textAlignArray = "Check failed.";
                    throw new IllegalStateException(textAlignArray.toString());
                }
                Object e = it.get(0);
                Intrinsics.checkNotNull(e, "null cannot be cast to non-null type com.github.ajalt.mordant.table.Cell.Content");
                Cell.Content cell2 = (Cell.Content)e;
                aligned = aligned || !CollectionsKt.listOf(textAlignArray = new TextAlign[]{null, TextAlign.NONE}).contains((Object)cell2.getTextAlign());
                collection.add(new VerticalLayoutCell(cell2.getContent(), cell2.getStyle(), cell2.getTextAlign()));
            }
            List cells2 = (List)destination$iv$iv;
            TextAlign textAlign2 = builder2.getAlign();
            if (textAlign2 == null) {
                textAlign2 = TextAlign.NONE;
            }
            return new VerticalLayout(cells2, spacing, columnWidth, textAlign2, aligned, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextAlign.values().length];
            try {
                nArray[TextAlign.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

