/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationContainer;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.BuildTreeLocalComponentProvider;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.LocalComponentCache;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchemaFactory;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.internal.Describables;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveStateFactory;
import org.gradle.internal.model.InMemoryCacheFactory;
import org.gradle.internal.model.InMemoryLoadingCache;
import org.gradle.internal.model.ModelContainer;
import org.gradle.util.Path;

public class DefaultBuildTreeLocalComponentProvider
implements BuildTreeLocalComponentProvider,
HoldsProjectState {
    private final LocalComponentCache localComponentCache;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildStateRegistry buildStateRegistry;
    private final ImmutableAttributesSchemaFactory attributesSchemaFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final LocalComponentGraphResolveStateFactory resolveStateFactory;
    private final InMemoryLoadingCache<Path, LocalComponentGraphResolveState> components;
    private final Set<Path> configuredBuilds = ConcurrentHashMap.newKeySet();

    @Inject
    public DefaultBuildTreeLocalComponentProvider(InMemoryCacheFactory cacheFactory, LocalComponentCache localComponentCache, ProjectStateRegistry projectStateRegistry, BuildStateRegistry buildStateRegistry, ImmutableAttributesSchemaFactory attributesSchemaFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, LocalComponentGraphResolveStateFactory resolveStateFactory) {
        this.localComponentCache = localComponentCache;
        this.projectStateRegistry = projectStateRegistry;
        this.buildStateRegistry = buildStateRegistry;
        this.attributesSchemaFactory = attributesSchemaFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.resolveStateFactory = resolveStateFactory;
        this.components = cacheFactory.createCalculatedValueCache(Describables.of((Object)"project components"), this::loadOrCreateLocalComponentState);
    }

    public LocalComponentGraphResolveState getComponent(ProjectIdentity targetProjectId, Path sourceBuild) {
        Path projectIdentityPath = targetProjectId.getBuildTreePath();
        this.ensureBuildConfigured(targetProjectId.getBuildPath(), sourceBuild);
        return (LocalComponentGraphResolveState)this.components.get((Object)projectIdentityPath);
    }

    private LocalComponentGraphResolveState loadOrCreateLocalComponentState(Path projectIdentityPath) {
        return this.localComponentCache.computeIfAbsent(projectIdentityPath, path -> {
            ProjectState projectState = this.projectStateRegistry.stateFor(path);
            projectState.ensureConfigured();
            return (LocalComponentGraphResolveState)projectState.fromMutableState(this::createLocalComponentState);
        });
    }

    private LocalComponentGraphResolveState createLocalComponentState(ProjectInternal project) {
        ProjectState projectState = project.getOwner();
        Module module = ((DependencyMetaDataProvider)project.getServices().get(DependencyMetaDataProvider.class)).getModule();
        ModuleVersionIdentifier moduleVersionIdentifier = this.moduleIdentifierFactory.moduleWithVersion(module.getGroup(), module.getName(), module.getVersion());
        ProjectComponentIdentifier componentIdentifier = projectState.getComponentIdentifier();
        AttributesSchemaInternal mutableSchema = (AttributesSchemaInternal)project.getDependencies().getAttributesSchema();
        ImmutableAttributesSchema schema = this.attributesSchemaFactory.create(mutableSchema);
        LocalComponentGraphResolveMetadata metadata = new LocalComponentGraphResolveMetadata(moduleVersionIdentifier, (ComponentIdentifier)componentIdentifier, module.getStatus(), schema);
        DefaultConfigurationContainer configurations = (DefaultConfigurationContainer)project.getConfigurations();
        return this.resolveStateFactory.stateFor((ModelContainer)projectState, metadata, (ConfigurationsProvider)configurations);
    }

    public void discardAll() {
        this.components.invalidate();
    }

    private void ensureBuildConfigured(Path targetBuild, Path sourceBuild) {
        if (!this.configuredBuilds.contains(targetBuild)) {
            if (!sourceBuild.equals((Object)targetBuild)) {
                BuildState buildState = this.buildStateRegistry.getBuild((BuildIdentifier)new DefaultBuildIdentifier(targetBuild));
                buildState.ensureProjectsConfigured();
            }
            this.configuredBuilds.add(targetBuild);
        }
    }
}

