/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.workspace.impl;

import java.io.Closeable;
import java.io.File;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.gradle.api.internal.cache.CacheConfigurationsInternal;
import org.gradle.api.provider.Provider;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheCleanupStrategyFactory;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.cache.internal.FilesFinder;
import org.gradle.cache.internal.LeastRecentlyUsedCacheCleanup;
import org.gradle.cache.internal.SingleDepthFilesFinder;
import org.gradle.internal.execution.workspace.ImmutableWorkspaceProvider;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.gradle.internal.file.impl.SingleDepthFileAccessTracker;

public class CacheBasedImmutableWorkspaceProvider
implements ImmutableWorkspaceProvider,
Closeable {
    private static final int DEFAULT_FILE_TREE_DEPTH_TO_TRACK_AND_CLEANUP = 1;
    private final SingleDepthFileAccessTracker fileAccessTracker;
    private final File baseDirectory;
    private final PersistentCache cache;
    private final UnscopedCacheBuilderFactory unscopedCacheBuilderFactory;
    private final Map<String, CacheContainer> keyCaches = new ConcurrentHashMap<String, CacheContainer>();

    public static CacheBasedImmutableWorkspaceProvider createWorkspaceProvider(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, CacheConfigurationsInternal cacheConfigurations, CacheCleanupStrategyFactory cacheCleanupStrategyFactory, UnscopedCacheBuilderFactory unscopedCacheBuilderFactory) {
        return CacheBasedImmutableWorkspaceProvider.createWorkspaceProvider(cacheBuilder, fileAccessTimeJournal, 1, cacheConfigurations, cacheCleanupStrategyFactory, unscopedCacheBuilderFactory);
    }

    public static CacheBasedImmutableWorkspaceProvider createWorkspaceProvider(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, int treeDepthToTrackAndCleanup, CacheConfigurationsInternal cacheConfigurations, CacheCleanupStrategyFactory cacheCleanupStrategyFactory, UnscopedCacheBuilderFactory unscopedCacheBuilderFactory) {
        return new CacheBasedImmutableWorkspaceProvider(cacheBuilder, fileAccessTimeJournal, treeDepthToTrackAndCleanup, cacheConfigurations, cacheCleanupStrategyFactory, unscopedCacheBuilderFactory);
    }

    private CacheBasedImmutableWorkspaceProvider(CacheBuilder cacheBuilder, FileAccessTimeJournal fileAccessTimeJournal, int treeDepthToTrackAndCleanup, CacheConfigurationsInternal cacheConfigurations, CacheCleanupStrategyFactory cacheCleanupStrategyFactory, UnscopedCacheBuilderFactory unscopedCacheBuilderFactory) {
        PersistentCache cache;
        this.cache = cache = cacheBuilder.withCleanupStrategy(cacheCleanupStrategyFactory.create(CacheBasedImmutableWorkspaceProvider.createCleanupAction(fileAccessTimeJournal, treeDepthToTrackAndCleanup, cacheConfigurations), () -> ((Provider)cacheConfigurations.getCleanupFrequency()).get())).withInitialLockMode(FileLockManager.LockMode.None).open();
        this.baseDirectory = cache.getBaseDir();
        this.fileAccessTracker = new SingleDepthFileAccessTracker(fileAccessTimeJournal, this.baseDirectory, treeDepthToTrackAndCleanup);
        this.unscopedCacheBuilderFactory = unscopedCacheBuilderFactory;
    }

    private static CleanupAction createCleanupAction(FileAccessTimeJournal fileAccessTimeJournal, int treeDepthToTrackAndCleanup, CacheConfigurationsInternal cacheConfigurations) {
        return new LeastRecentlyUsedCacheCleanup((FilesFinder)new SingleDepthFilesFinder(treeDepthToTrackAndCleanup), fileAccessTimeJournal, cacheConfigurations.getCreatedResources().getEntryRetentionTimestampSupplier());
    }

    @Override
    public ImmutableWorkspaceProvider.AtomicMoveImmutableWorkspace getAtomicMoveWorkspace(final String path) {
        final File immutableWorkspace = new File(this.baseDirectory, path);
        this.fileAccessTracker.markAccessed(immutableWorkspace);
        return new ImmutableWorkspaceProvider.AtomicMoveImmutableWorkspace(){

            @Override
            public File getImmutableLocation() {
                return immutableWorkspace;
            }

            @Override
            public <T> T withTemporaryWorkspace(ImmutableWorkspaceProvider.AtomicMoveImmutableWorkspace.TemporaryWorkspaceAction<T> action) {
                String temporaryLocation = path + "-" + UUID.randomUUID();
                File temporaryWorkspace = new File(CacheBasedImmutableWorkspaceProvider.this.baseDirectory, temporaryLocation);
                return action.executeInTemporaryWorkspace(temporaryWorkspace);
            }
        };
    }

    @Override
    public ImmutableWorkspaceProvider.LockingImmutableWorkspace getLockingWorkspace(final String path) {
        final File workspaceBaseDir = new File(this.baseDirectory, path);
        this.fileAccessTracker.markAccessed(workspaceBaseDir);
        final File workspace = new File(workspaceBaseDir, "workspace");
        return new ImmutableWorkspaceProvider.LockingImmutableWorkspace(){

            @Override
            public File getImmutableLocation() {
                return workspace;
            }

            @Override
            public <T> T withWorkspaceLock(Supplier<T> supplier) {
                CacheContainer cacheContainer = CacheBasedImmutableWorkspaceProvider.this.keyCaches.computeIfAbsent(path, cache -> new CacheContainer(CacheBasedImmutableWorkspaceProvider.this.unscopedCacheBuilderFactory.cache(workspaceBaseDir).withInitialLockMode(FileLockManager.LockMode.OnDemand).open()));
                return cacheContainer.withFileLock(supplier);
            }
        };
    }

    @Override
    public void close() {
        this.keyCaches.forEach((id, cache) -> cache.close());
        this.cache.close();
    }

    private static class CacheContainer {
        private final ReentrantLock lock = new ReentrantLock();
        private final PersistentCache cache;

        CacheContainer(PersistentCache cache) {
            this.cache = cache;
        }

        public <T> T withFileLock(Supplier<T> supplier) {
            return (T)this.cache.withFileLock(() -> {
                this.lock.lock();
                try {
                    Object t = supplier.get();
                    return t;
                }
                finally {
                    this.lock.unlock();
                }
            });
        }

        public void close() {
            this.cache.close();
        }
    }
}

