/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.exceptions.DefaultMultiCauseException;

public class CompositeStoppable
implements Stoppable {
    public static final Stoppable NO_OP_STOPPABLE = new Stoppable(){

        @Override
        public void stop() {
        }
    };
    private final List<Stoppable> elements = new ArrayList<Stoppable>();

    public static CompositeStoppable stoppable(Object ... elements) {
        return new CompositeStoppable().add(elements);
    }

    public static CompositeStoppable stoppable(Iterable<?> elements) {
        return new CompositeStoppable().add(elements);
    }

    public CompositeStoppable addFailure(final Throwable failure) {
        this.add((Object)new Closeable(){

            @Override
            public void close() {
                throw UncheckedException.throwAsUncheckedException((Throwable)failure);
            }
        });
        return this;
    }

    public CompositeStoppable add(Iterable<?> elements) {
        for (Object closeable : elements) {
            this.add(closeable);
        }
        return this;
    }

    public CompositeStoppable add(Object ... elements) {
        for (Object closeable : elements) {
            this.add(closeable);
        }
        return this;
    }

    public synchronized CompositeStoppable add(Object closeable) {
        this.elements.add(CompositeStoppable.toStoppable(closeable));
        return this;
    }

    private static Stoppable toStoppable(Object object) {
        if (object instanceof Stoppable) {
            return (Stoppable)object;
        }
        if (object instanceof Closeable) {
            final Closeable closeable = (Closeable)object;
            return new Stoppable(){

                public String toString() {
                    return closeable.toString();
                }

                @Override
                public void stop() {
                    try {
                        closeable.close();
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException((Throwable)e);
                    }
                }
            };
        }
        return NO_OP_STOPPABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stop() {
        ArrayList<Throwable> failures = null;
        try {
            for (Stoppable element : this.elements) {
                try {
                    element.stop();
                }
                catch (Throwable throwable) {
                    if (failures == null) {
                        failures = new ArrayList<Throwable>();
                    }
                    failures.add(throwable);
                }
            }
        }
        finally {
            this.elements.clear();
        }
        if (failures != null) {
            if (failures.size() == 1) {
                throw UncheckedException.throwAsUncheckedException((Throwable)((Throwable)failures.get(0)));
            }
            throw new DefaultMultiCauseException("Could not stop all services.", failures);
        }
    }
}

