from typing import Optional

from pydantic import BaseModel
from sqlalchemy import Column, Integer, String, Double, ForeignKey, UniqueConstraint
from sqlalchemy.orm import relationship

from ..base import Base


class ApplicationStats(Base):
    __tablename__ = 'application_stats'
    id = Column(Integer, primary_key=True, index=True)
    process_name = Column(String, default='')
    total_thread_count = Column(Integer, nullable=True)
    active_thread_count = Column(Integer, nullable=True)
    job_thread_count = Column(Integer, nullable=True)
    serial_thread_count = Column(Integer, nullable=True)
    concurrency_of_active_threads = Column(Integer, nullable=True)
    start_time_s = Column(Double, nullable=True)
    end_time_s = Column(Double, nullable=True)
    average_cpu_frametime_ms = Column(Double, nullable=True)
    average_gpu_frametime_ms = Column(Double, nullable=True)
    cpu_idle_pct = Column(Double, nullable=True)
    gpu_idle_pct = Column(Double, nullable=True)
    total_thread_utilisation_pct = Column(Double, nullable=True)
    busiest_thread_util_pct = Column(Double, nullable=True)
    median_job_thread_util_pct = Column(Double, nullable=True)
    serial_work_util_pct = Column(Double, nullable=True)
    one_thread_active_pct = Column(Double, nullable=True)
    two_threads_active_pct = Column(Double, nullable=True)

    report_id = Column(Integer, ForeignKey('report.id'))
    report = relationship('Report', back_populates='application_stats')

    __table_args__ = (UniqueConstraint("report_id", name="application_stats_report_id_key"),)


class ApplicationStatsInDB(BaseModel):
    process_name: str
    total_thread_count: Optional[int]
    active_thread_count: Optional[int]
    job_thread_count: Optional[int]
    serial_thread_count: Optional[int]
    concurrency_of_active_threads: Optional[int]
    start_time_s: Optional[float]
    end_time_s: Optional[float]
    average_cpu_frametime_ms: Optional[float]
    average_gpu_frametime_ms: Optional[float]
    cpu_idle_pct: Optional[float]
    gpu_idle_pct: Optional[float]
    total_thread_utilisation_pct: Optional[float]
    busiest_thread_util_pct: Optional[float]
    median_job_thread_util_pct: Optional[float]
    serial_work_util_pct: Optional[float]
    one_thread_active_pct: Optional[float]
    two_threads_active_pct: Optional[float]

    class Config:
        from_attributes = True


class ApplicationStatsCreate(BaseModel):
    process_name: Optional[str]
    total_thread_count: Optional[int]
    active_thread_count: Optional[int]
    job_thread_count: Optional[int]
    serial_thread_count: Optional[int]
    concurrency_of_active_threads: Optional[int]
    start_time_s: Optional[float]
    end_time_s: Optional[float]
    average_cpu_frametime_ms: Optional[float]
    average_gpu_frametime_ms: Optional[float]
    cpu_idle_pct: Optional[float]
    gpu_idle_pct: Optional[float]
    total_thread_utilisation_pct: Optional[float]
    busiest_thread_util_pct: Optional[float]
    median_job_thread_util_pct: Optional[float]
    serial_work_util_pct: Optional[float]
    one_thread_active_pct: Optional[float]
    two_threads_active_pct: Optional[float]

    class Config:
        from_attributes = True
