import os
from typing import Literal

from pydantic_settings import BaseSettings, SettingsConfigDict

current_dir = os.path.dirname(os.path.abspath(__file__))


class Config(BaseSettings):
    model_config = SettingsConfigDict(env_prefix='NSYS_CPU_STATS_', case_sensitive=False, extra='ignore')

    app_name: str = 'nsys-cpu-stats-server'
    database_provider: Literal['sqlite', 'postgresql'] = 'sqlite'
    database_host: str = 'nsys_cpu_stats.sqlite'
    database_port: int = 0
    database_username: str = ''
    database_password: str = ''
    database_name: str = 'nsys_cpu_stats'
    static_path: str = os.path.join(current_dir, 'static')
    standalone: bool = True


# @lru_cache()
def get_config() -> Config:
    return Config()


def get_database_url() -> str:
    config = get_config()
    if config.database_provider == 'sqlite':
        return f'sqlite:///{config.database_host}'
    if config.database_provider == 'postgresql':
        return f'postgresql://{config.database_username}:{config.database_password}@{config.database_host}:{config.database_port}/{config.database_name}'
    raise ValueError(f'Unsupported database provider: {config.database_provider}')
