/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionCategoryDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;

public class AIFunctionRegistry {
    private static final Log log = Log.getLog(AIFunctionRegistry.class);
    private static AIFunctionRegistry instance;
    private final Map<String, AIFunctionDescriptor> functionsById = new LinkedHashMap<String, AIFunctionDescriptor>();
    private final Map<String, AIFunctionCategoryDescriptor> categoriesById = new LinkedHashMap<String, AIFunctionCategoryDescriptor>();

    public static synchronized AIFunctionRegistry getInstance() {
        if (instance == null) {
            instance = new AIFunctionRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public AIFunctionRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("com.dbeaver.ai.function");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if ("category".equals(el.getName())) {
                AIFunctionCategoryDescriptor cd = new AIFunctionCategoryDescriptor(el);
                this.categoriesById.put(cd.getId(), cd);
            }
            ++n2;
        }
        iConfigurationElementArray = extElements;
        n = extElements.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("function".equals(ext.getName())) {
                AIFunctionDescriptor fd = new AIFunctionDescriptor(ext);
                this.functionsById.put(fd.getId(), fd);
            }
            ++n2;
        }
    }

    @Nullable
    public AIFunctionDescriptor getFunction(@NotNull String id) {
        return this.functionsById.get(id);
    }

    @NotNull
    public List<AIFunctionDescriptor> getAllFunctions() {
        return new ArrayList<AIFunctionDescriptor>(this.functionsById.values());
    }

    @NotNull
    public List<AIFunctionCategoryDescriptor> getAllCategories() {
        return new ArrayList<AIFunctionCategoryDescriptor>(this.categoriesById.values());
    }

    @NotNull
    public Map<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>> getFunctionsByCategory() {
        LinkedHashMap<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>> map = new LinkedHashMap<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>>();
        for (AIFunctionCategoryDescriptor cat : this.categoriesById.values()) {
            map.put(cat, new ArrayList());
        }
        for (AIFunctionDescriptor f : this.functionsById.values()) {
            AIFunctionCategoryDescriptor cat = this.categoriesById.get(f.getCategoryId());
            if (cat == null) continue;
            ((List)map.get((Object)cat)).add(f);
        }
        return map;
    }

    @NotNull
    public Set<String> getDefaultEnabledCategoryIds() {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (AIFunctionCategoryDescriptor c : this.categoriesById.values()) {
            if (!c.isEnabledByDefault()) continue;
            ids.add(c.getId());
        }
        return ids;
    }

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull AIFunctionDescriptor descriptor, @NotNull Map<String, Object> arguments) throws DBException {
        AIFunction function = descriptor.createInstance();
        return function.callFunction(context, arguments);
    }
}

