/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core.groups.observer;

import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;

public class StreamObserver
implements Runnable {
    private final String stringPattern;
    private final IProcess process;
    private final CountDownLatch countDownLatch;
    private final IProgressMonitor pMonitor;

    public StreamObserver(IProgressMonitor monitor, IProcess process, String pattern, CountDownLatch countDownLatch) {
        this.process = process;
        this.pMonitor = monitor;
        this.stringPattern = pattern;
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {
        StringBuilder patternBuilder = new StringBuilder();
        if (!this.stringPattern.startsWith(".*")) {
            patternBuilder.append(".*");
        }
        patternBuilder.append(this.stringPattern);
        if (!this.stringPattern.endsWith(".*")) {
            patternBuilder.append(".*");
        }
        final Pattern pattern = Pattern.compile(patternBuilder.toString(), 8);
        final IStreamMonitor outputStreamMonitor = this.process.getStreamsProxy().getOutputStreamMonitor();
        outputStreamMonitor.addListener(new IStreamListener(){

            @Override
            public void streamAppended(String text, IStreamMonitor monitor) {
                if (StreamObserver.this.countDownLatch.getCount() == 0L) {
                    outputStreamMonitor.removeListener(this);
                    return;
                }
                Matcher matcher = pattern.matcher(text);
                if (!matcher.find() && !StreamObserver.this.pMonitor.isCanceled()) {
                    return;
                }
                StreamObserver.this.countDownLatch.countDown();
            }
        });
    }
}

