/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.text.MessageFormat;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PreferenceLinkArea {
    private final Link pageLink;

    public PreferenceLinkArea(Composite parent, int style, String pageId, String message, IWorkbenchPreferenceContainer pageContainer, Object pageData) {
        String result;
        this.pageLink = new Link(parent, style);
        IPreferenceNode node = this.getPreferenceNode(pageId);
        if (node == null) {
            result = NLS.bind((String)WorkbenchMessages.PreferenceNode_NotFound, (Object)pageId);
        } else {
            result = MessageFormat.format(message, node.getLabelText());
            this.pageLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
                boolean bl = pageContainer.openPage(pageId, pageData);
            }));
        }
        this.pageLink.setText(result);
    }

    private IPreferenceNode getPreferenceNode(String pageId) {
        for (IPreferenceNode next : PlatformUI.getWorkbench().getPreferenceManager().getElements(0)) {
            if (!next.getId().equals(pageId)) continue;
            return next;
        }
        return null;
    }

    public Control getControl() {
        return this.pageLink;
    }
}

