/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.diff.IDiffChangeEvent;
import org.eclipse.team.core.diff.IDiffChangeListener;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.MergeAllOperation;
import org.eclipse.team.ui.mapping.MergeActionHandler;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.ide.IDE;

public class MergeAllActionHandler
extends MergeActionHandler
implements IDiffChangeListener {
    private MergeAllOperation operation;

    public MergeAllActionHandler(ISynchronizePageConfiguration configuration) {
        super(configuration);
        this.getContext().getDiffTree().addDiffChangeListener((IDiffChangeListener)this);
    }

    @Override
    protected synchronized SynchronizationOperation getOperation() {
        if (this.operation == null) {
            this.operation = this.createOperation();
        }
        return this.operation;
    }

    protected MergeAllOperation createOperation() {
        return new MergeAllOperation(this.getJobName(), this.getConfiguration(), this.getMappings(), this.getContext());
    }

    private IMergeContext getContext() {
        return (IMergeContext)this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    private ResourceMapping[] getMappings() {
        return ((ISynchronizationScope)this.getConfiguration().getProperty("org.eclipse.team.ui.synchronizationScope")).getMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diffsChanged(IDiffChangeEvent event, IProgressMonitor monitor) {
        MergeAllActionHandler mergeAllActionHandler = this;
        synchronized (mergeAllActionHandler) {
            this.operation = null;
        }
        this.setEnabled(event.getTree().countFor(512, 768) > 0L || event.getTree().countFor(768, 768) > 0L);
    }

    public void propertyChanged(IDiffTree tree, int property, IPath[] paths) {
    }

    @Override
    public void dispose() {
        this.getContext().getDiffTree().removeDiffChangeListener((IDiffChangeListener)this);
        super.dispose();
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.saveDirtyEditors() && this.promptToUpdate()) {
            return super.execute(event);
        }
        return null;
    }

    public final boolean saveDirtyEditors() {
        return !this.needsToSaveDirtyEditors() || this.saveAllEditors(this.getTargetResources(), this.confirmSaveOfDirtyEditor());
    }

    private IResource[] getTargetResources() {
        return this.getContext().getDiffTree().getAffectedResources();
    }

    public final boolean saveAllEditors(IResource[] resources, boolean confirm) {
        return IDE.saveAllEditors((IResource[])resources, (boolean)confirm);
    }

    protected boolean needsToSaveDirtyEditors() {
        return true;
    }

    protected boolean confirmSaveOfDirtyEditor() {
        return true;
    }

    protected String getJobName() {
        String name = this.getConfiguration().getParticipant().getName();
        return NLS.bind((String)TeamUIMessages.MergeAllActionHandler_0, (Object)Utils.shortenText(100, name));
    }

    protected boolean promptToUpdate() {
        IResourceDiffTree tree = this.getContext().getDiffTree();
        if (tree.isEmpty()) {
            return false;
        }
        long count = tree.countFor(512, 768) + tree.countFor(768, 768);
        if (count == 0L) {
            return false;
        }
        boolean[] result = new boolean[]{true};
        TeamUIPlugin.getStandardDisplay().syncExec(() -> {
            String sizeString = Long.toString(count);
            String message = tree.size() > 1 ? NLS.bind((String)TeamUIMessages.MergeAllActionHandler_1, (Object)sizeString) : NLS.bind((String)TeamUIMessages.MergeAllActionHandler_2, (Object)sizeString);
            blArray[0] = MessageDialog.openQuestion((Shell)this.getConfiguration().getSite().getShell(), (String)NLS.bind((String)TeamUIMessages.MergeAllActionHandler_3, (Object)sizeString), (String)message);
        });
        return result[0];
    }
}

