/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth.keyprovider;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.schmizz.sshj.common.Base64Decoder;
import net.schmizz.sshj.common.Base64DecodingException;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.ByteArrayUtils;
import net.schmizz.sshj.common.ECDSACurve;
import net.schmizz.sshj.common.ECDSAKeyFactory;
import net.schmizz.sshj.common.Ed25519KeyFactory;
import net.schmizz.sshj.common.Factory;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.userauth.keyprovider.BaseFileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.V1PuTTYSecretKeyDerivationFunction;
import net.schmizz.sshj.userauth.keyprovider.V3PuTTYSecretKeyDerivationFunction;
import net.schmizz.sshj.userauth.password.PasswordUtils;

public class PuTTYKeyFile
extends BaseFileKeyProvider {
    private static final String KEY_DERIVATION_HEADER = "Key-Derivation";
    private Integer keyFileVersion;
    private byte[] privateKey;
    private byte[] publicKey;
    private byte[] verifyHmac;
    private final Map<String, String> payload = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();

    @Override
    public KeyType getType() throws IOException {
        String headerName = String.format("PuTTY-User-Key-File-%d", this.keyFileVersion);
        return KeyType.fromString(this.headers.get(headerName));
    }

    public boolean isEncrypted() throws IOException {
        String encryption = this.headers.get("Encryption");
        if ("none".equals(encryption)) {
            return false;
        }
        if ("aes256-cbc".equals(encryption)) {
            return true;
        }
        throw new IOException(String.format("Unsupported encryption: %s", encryption));
    }

    @Override
    protected KeyPair readKeyPair() throws IOException {
        ECDSACurve ecdsaCurve;
        this.parseKeyPair();
        Buffer.PlainBuffer publicKeyReader = new Buffer.PlainBuffer(this.publicKey);
        Buffer.PlainBuffer privateKeyReader = new Buffer.PlainBuffer(this.privateKey);
        KeyType keyType = this.getType();
        publicKeyReader.readBytes();
        if (KeyType.RSA.equals((Object)keyType)) {
            KeyFactory factory;
            BigInteger e = publicKeyReader.readMPInt();
            BigInteger n = publicKeyReader.readMPInt();
            BigInteger d = privateKeyReader.readMPInt();
            try {
                factory = KeyFactory.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException s) {
                throw new IOException(s.getMessage(), s);
            }
            try {
                return new KeyPair(factory.generatePublic(new RSAPublicKeySpec(n, e)), factory.generatePrivate(new RSAPrivateKeySpec(n, d)));
            }
            catch (InvalidKeySpecException i) {
                throw new IOException(i.getMessage(), i);
            }
        }
        if (KeyType.DSA.equals((Object)keyType)) {
            KeyFactory factory;
            BigInteger p = publicKeyReader.readMPInt();
            BigInteger q = publicKeyReader.readMPInt();
            BigInteger g = publicKeyReader.readMPInt();
            BigInteger y = publicKeyReader.readMPInt();
            BigInteger x = privateKeyReader.readMPInt();
            try {
                factory = KeyFactory.getInstance("DSA");
            }
            catch (NoSuchAlgorithmException s) {
                throw new IOException(s.getMessage(), s);
            }
            try {
                return new KeyPair(factory.generatePublic(new DSAPublicKeySpec(y, p, q, g)), factory.generatePrivate(new DSAPrivateKeySpec(x, p, q, g)));
            }
            catch (InvalidKeySpecException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        if (KeyType.ED25519.equals((Object)keyType)) {
            try {
                byte[] publicKeyEncoded = publicKeyReader.readBytes();
                PublicKey edPublicKey = Ed25519KeyFactory.getPublicKey(publicKeyEncoded);
                byte[] privateKeyEncoded = privateKeyReader.readBytes();
                PrivateKey edPrivateKey = Ed25519KeyFactory.getPrivateKey(privateKeyEncoded);
                return new KeyPair(edPublicKey, edPrivateKey);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Reading Ed25519 Keys failed", e);
            }
        }
        switch (keyType) {
            case ECDSA256: {
                ecdsaCurve = ECDSACurve.SECP256R1;
                break;
            }
            case ECDSA384: {
                ecdsaCurve = ECDSACurve.SECP384R1;
                break;
            }
            case ECDSA521: {
                ecdsaCurve = ECDSACurve.SECP521R1;
                break;
            }
            default: {
                ecdsaCurve = null;
            }
        }
        if (ecdsaCurve != null) {
            BigInteger s = new BigInteger(1, privateKeyReader.readBytes());
            try {
                PrivateKey privateKey = ECDSAKeyFactory.getPrivateKey(s, ecdsaCurve);
                return new KeyPair(keyType.readPubKeyFromBuffer(publicKeyReader), privateKey);
            }
            catch (GeneralSecurityException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        throw new IOException(String.format("Unknown key type %s", new Object[]{this.getType()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseKeyPair() throws IOException {
        block15: {
            this.keyFileVersion = null;
            try (BufferedReader r = new BufferedReader(this.resource.getReader());){
                String line;
                String headerName = null;
                while ((line = r.readLine()) != null) {
                    int idx = line.indexOf(": ");
                    if (idx > 0) {
                        headerName = line.substring(0, idx);
                        this.headers.put(headerName, line.substring(idx + 2));
                        if (!headerName.startsWith("PuTTY-User-Key-File-")) continue;
                        this.keyFileVersion = Integer.parseInt(headerName.substring(20));
                        continue;
                    }
                    String s = this.payload.get(headerName);
                    s = s == null ? line : s + line;
                    this.payload.put(headerName, s);
                }
            }
            if (this.keyFileVersion == null) {
                throw new IOException("Invalid key file format: missing \"PuTTY-User-Key-File-?\" entry");
            }
            try {
                this.publicKey = Base64Decoder.decode(this.payload.get("Public-Lines"));
                if (this.isEncrypted()) {
                    char[] passphrase = this.pwdf != null ? this.pwdf.reqPassword(this.resource) : "".toCharArray();
                    try {
                        this.privateKey = this.decrypt(Base64Decoder.decode(this.payload.get("Private-Lines")), passphrase);
                        Mac mac = this.keyFileVersion <= 2 ? this.prepareVerifyMacV2(passphrase) : this.prepareVerifyMacV3();
                        this.verify(mac);
                        break block15;
                    }
                    finally {
                        PasswordUtils.blankOut(passphrase);
                    }
                }
                this.privateKey = Base64Decoder.decode(this.payload.get("Private-Lines"));
            }
            catch (Base64DecodingException e) {
                throw new IOException("PuTTY key decoding failed", e);
            }
        }
    }

    private void initCipher(char[] passphrase, Cipher cipher) throws InvalidAlgorithmParameterException, InvalidKeyException {
        IvParameterSpec ivParameterSpec;
        SecretKey secretKey;
        String keyDerivationHeader = this.headers.get(KEY_DERIVATION_HEADER);
        if (keyDerivationHeader == null) {
            V1PuTTYSecretKeyDerivationFunction keyDerivationFunction = new V1PuTTYSecretKeyDerivationFunction();
            secretKey = keyDerivationFunction.deriveSecretKey(passphrase);
            ivParameterSpec = new IvParameterSpec(new byte[16]);
        } else {
            V3PuTTYSecretKeyDerivationFunction keyDerivationFunction = new V3PuTTYSecretKeyDerivationFunction(this.headers);
            SecretKey derivedSecretKey = keyDerivationFunction.deriveSecretKey(passphrase);
            byte[] derivedSecretKeyEncoded = derivedSecretKey.getEncoded();
            byte[] secretKeyEncoded = new byte[32];
            System.arraycopy(derivedSecretKeyEncoded, 0, secretKeyEncoded, 0, secretKeyEncoded.length);
            secretKey = new SecretKeySpec(secretKeyEncoded, derivedSecretKey.getAlgorithm());
            byte[] iv = new byte[16];
            System.arraycopy(derivedSecretKeyEncoded, secretKeyEncoded.length, iv, 0, iv.length);
            ivParameterSpec = new IvParameterSpec(iv);
            byte[] tag = new byte[32];
            int tagSourcePosition = secretKeyEncoded.length + iv.length;
            System.arraycopy(derivedSecretKeyEncoded, tagSourcePosition, tag, 0, tag.length);
            this.verifyHmac = tag;
        }
        cipher.init(2, (Key)secretKey, ivParameterSpec);
    }

    private void verify(Mac mac) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        DataOutputStream data = new DataOutputStream(out);
        String keyType = this.getType().toString();
        data.writeInt(keyType.length());
        data.writeBytes(keyType);
        data.writeInt(this.headers.get("Encryption").length());
        data.writeBytes(this.headers.get("Encryption"));
        data.writeInt(this.headers.get("Comment").length());
        data.writeBytes(this.headers.get("Comment"));
        data.writeInt(this.publicKey.length);
        data.write(this.publicKey);
        data.writeInt(this.privateKey.length);
        data.write(this.privateKey);
        String encoded = ByteArrayUtils.toHex(mac.doFinal(out.toByteArray()));
        String reference = this.headers.get("Private-MAC");
        if (!encoded.equals(reference)) {
            throw new IOException("Invalid passphrase");
        }
    }

    private Mac prepareVerifyMacV2(char[] passphrase) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update("putty-private-key-file-mac-key".getBytes());
            if (passphrase != null) {
                byte[] encodedPassphrase = PasswordUtils.toByteArray(passphrase);
                digest.update(encodedPassphrase);
                Arrays.fill(encodedPassphrase, (byte)0);
            }
            byte[] key = digest.digest();
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key, 0, 20, mac.getAlgorithm()));
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private Mac prepareVerifyMacV3() throws IOException {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(this.verifyHmac, 0, 32, mac.getAlgorithm()));
            return mac;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private byte[] decrypt(byte[] privateKey, char[] passphrase) throws IOException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            this.initCipher(passphrase, cipher);
            return cipher.doFinal(privateKey);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public int getKeyFileVersion() {
        return this.keyFileVersion;
    }

    public static class Factory
    implements Factory.Named<FileKeyProvider> {
        @Override
        public FileKeyProvider create() {
            return new PuTTYKeyFile();
        }

        @Override
        public String getName() {
            return "PuTTY";
        }
    }
}

