/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPDataSourceOriginExternal;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataSourcePermissionOwner;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.access.DBAAuthProfile;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConfigurationProfile;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfigurationMigrator;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.secret.DBSValueEncryptor;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceFolder;
import org.jkiss.dbeaver.registry.DataSourceMemoryStorage;
import org.jkiss.dbeaver.registry.DataSourceNavigatorSettings;
import org.jkiss.dbeaver.registry.DataSourceOriginLazy;
import org.jkiss.dbeaver.registry.DataSourceOriginLocal;
import org.jkiss.dbeaver.registry.DataSourceParseResults;
import org.jkiss.dbeaver.registry.DataSourcePreferenceStore;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.registry.DataSourceSerializer;
import org.jkiss.dbeaver.registry.FilterMapping;
import org.jkiss.dbeaver.registry.SecureCredentials;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptorSerializerModern;
import org.jkiss.dbeaver.registry.internal.RegistryMessages;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.runtime.DBInterruptedException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DataSourceSerializerModern<T extends DataSourceDescriptor>
implements DataSourceSerializer<T> {
    static final String ATTR_NAVIGATOR_SHOW_SYSTEM_OBJECTS = "show-system-objects";
    static final String ATTR_NAVIGATOR_SHOW_UTIL_OBJECTS = "show-util-objects";
    static final String ATTR_NAVIGATOR_SHOW_ONLY_ENTITIES = "navigator-show-only-entities";
    static final String ATTR_NAVIGATOR_HIDE_FOLDERS = "navigator-hide-folders";
    static final String ATTR_NAVIGATOR_HIDE_SCHEMAS = "navigator-hide-schemas";
    static final String ATTR_NAVIGATOR_HIDE_VIRTUAL = "navigator-hide-virtual";
    static final String ATTR_NAVIGATOR_MERGE_ENTITIES = "navigator-merge-entities";
    private static final String ATTR_ORIGINAL_PROVIDER = "original-provider";
    private static final String ATTR_ORIGINAL_DRIVER = "original-driver";
    private static final String ATTR_DRIVER_SUBSTITUTION = "driver-substitution";
    public static final String TAG_ORIGIN = "origin";
    private static final String ATTR_ORIGIN_TYPE = "$type";
    private static final String ATTR_ORIGIN_CONFIGURATION = "$configuration";
    public static final String ATTR_DPI_ENABLED = "dpi-enabled";
    private static final Log log = Log.getLog(DataSourceSerializerModern.class);
    private static final String NODE_CONNECTION = "#connection";
    private static final String USE_PROJECT_PASSWORD = "useProjectPassword";
    private static final String CONFIGURATION_FOLDERS = "folders";
    private static final String ENCRYPTED_CONFIGURATION = "secureProject";
    protected static final Gson CONFIG_GSON = new GsonBuilder().setStrictness(Strictness.LENIENT).serializeNulls().create();
    @NotNull
    private final DataSourceRegistry<T> registry;
    private final Map<String, Map<String, Map<String, String>>> secureProperties = new LinkedHashMap<String, Map<String, Map<String, String>>>();
    private final boolean isDetachedProcess = DBWorkbench.getPlatform().getApplication().isDetachedProcess();

    protected DataSourceSerializerModern(@NotNull DataSourceRegistry<T> registry) {
        this.registry = registry;
    }

    @Override
    public void saveDataSources(@NotNull DBRProgressMonitor monitor, @NotNull DataSourceConfigurationManager configurationManager, @NotNull DBPDataSourceConfigurationStorage configurationStorage, @NotNull List<T> localDataSources) throws DBException, IOException {
        ByteArrayOutputStream dsConfigBuffer = new ByteArrayOutputStream(10000);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)dsConfigBuffer, StandardCharsets.UTF_8);){
                Throwable throwable2 = null;
                Object var10_14 = null;
                try (JsonWriter jsonWriter = CONFIG_GSON.newJsonWriter((Writer)osw);){
                    jsonWriter.setIndent("\t");
                    jsonWriter.beginObject();
                    if (configurationStorage.isDefault()) {
                        jsonWriter.name(CONFIGURATION_FOLDERS);
                        jsonWriter.beginObject();
                        Set<DBPDataSourceFolder> globalFolders = this.registry.getTemporaryFolders();
                        for (DataSourceFolder folder : this.registry.getAllFolders()) {
                            if (globalFolders.contains(folder)) continue;
                            DataSourceSerializerModern.saveFolder(jsonWriter, folder);
                        }
                        jsonWriter.endObject();
                    }
                    LinkedHashMap<String, DBVModel> virtualModels = new LinkedHashMap<String, DBVModel>();
                    LinkedHashMap<String, DBPConnectionType> connectionTypes = new LinkedHashMap<String, DBPConnectionType>();
                    LinkedHashMap<String, Map> drivers = new LinkedHashMap<String, Map>();
                    LinkedHashMap<String, DBPExternalConfiguration> externalConfigurations = new LinkedHashMap<String, DBPExternalConfiguration>();
                    jsonWriter.name("connections");
                    jsonWriter.beginObject();
                    for (DataSourceDescriptor dataSource : localDataSources) {
                        if (dataSource.isDetached()) continue;
                        this.saveDataSource(configurationManager, jsonWriter, dataSource, externalConfigurations);
                        if (dataSource.getVirtualModel().hasValuableData()) {
                            virtualModels.put(dataSource.getVirtualModel().getId(), dataSource.getVirtualModel());
                        }
                        DBPConnectionType connectionType = dataSource.getConnectionConfiguration().getConnectionType();
                        connectionTypes.put(connectionType.getId(), connectionType);
                        DBPDriver dBPDriver = dataSource.getDriver();
                        if (!dBPDriver.isCustom() || dBPDriver.getProviderDescriptor().isTemporary()) continue;
                        Map driverMap = drivers.computeIfAbsent(dBPDriver.getProviderId(), s -> new LinkedHashMap());
                        driverMap.put(dBPDriver.getId(), dBPDriver);
                    }
                    jsonWriter.endObject();
                    if (configurationStorage.isDefault()) {
                        List<DBSObjectFilter> savedFilters;
                        List<DBAAuthProfile> authProfiles;
                        List<DBWNetworkProfile> profiles;
                        if (!virtualModels.isEmpty()) {
                            jsonWriter.name("virtual-models");
                            jsonWriter.beginObject();
                            jsonWriter.setIndent("");
                            for (DBVModel model : virtualModels.values()) {
                                model.serialize(monitor, jsonWriter);
                            }
                            jsonWriter.endObject();
                            jsonWriter.setIndent("\t");
                        }
                        if (!CommonUtils.isEmpty(profiles = this.registry.getNetworkProfiles())) {
                            this.saveNetworkProfiles(configurationManager, jsonWriter, profiles);
                        }
                        if (!CommonUtils.isEmpty(authProfiles = this.registry.getAllAuthProfiles())) {
                            this.saveAuthProfiles(configurationManager, jsonWriter, authProfiles);
                        }
                        if (!CommonUtils.isEmpty(savedFilters = this.registry.getSavedFilters())) {
                            jsonWriter.name("saved-filters");
                            jsonWriter.beginArray();
                            for (DBSObjectFilter dBSObjectFilter : savedFilters) {
                                if (dBSObjectFilter.isEmpty()) continue;
                                DataSourceSerializerModern.saveObjectFiler(jsonWriter, null, null, dBSObjectFilter);
                            }
                            jsonWriter.endArray();
                        }
                        if (!CommonUtils.isEmpty(connectionTypes)) {
                            jsonWriter.name("connection-types");
                            jsonWriter.beginObject();
                            for (DBPConnectionType dBPConnectionType : connectionTypes.values()) {
                                jsonWriter.name(dBPConnectionType.getId());
                                jsonWriter.beginObject();
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"name", (String)dBPConnectionType.getName());
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"color", (String)dBPConnectionType.getColor());
                                JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"description", (String)dBPConnectionType.getDescription());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"auto-commit", (boolean)dBPConnectionType.isAutocommit());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"confirm-execute", (boolean)dBPConnectionType.isConfirmExecute());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"confirm-data-change", (boolean)dBPConnectionType.isConfirmDataChange());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"smart-commit", (boolean)dBPConnectionType.isSmartCommit());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"smart-commit-recover", (boolean)dBPConnectionType.isSmartCommitRecover());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"auto-close-transactions", (boolean)dBPConnectionType.isAutoCloseTransactions());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"close-transactions-period", (long)dBPConnectionType.getCloseIdleTransactionPeriod());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"auto-close-connections", (boolean)dBPConnectionType.isAutoCloseConnections());
                                JSONUtils.field((JsonWriter)jsonWriter, (String)"close-connections-period", (long)dBPConnectionType.getCloseIdleConnectionPeriod());
                                this.serializeModifyPermissions(jsonWriter, (DBPDataSourcePermissionOwner)dBPConnectionType);
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        if (!CommonUtils.isEmpty(drivers)) {
                            jsonWriter.name("drivers");
                            jsonWriter.beginObject();
                            for (Map.Entry entry : drivers.entrySet()) {
                                jsonWriter.name((String)entry.getKey());
                                jsonWriter.beginObject();
                                for (DBPDriver driver : ((Map)entry.getValue()).values()) {
                                    new DriverDescriptorSerializerModern().serializeDriver(jsonWriter, (DriverDescriptor)driver, true);
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endObject();
                        }
                        if (!(DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser() || CommonUtils.isEmpty(externalConfigurations))) {
                            jsonWriter.name("external-configurations");
                            jsonWriter.beginObject();
                            for (Map.Entry entry : externalConfigurations.entrySet()) {
                                jsonWriter.name((String)entry.getKey());
                                JSONUtils.serializeMap((JsonWriter)jsonWriter, (Map)((DBPExternalConfiguration)entry.getValue()).getProperties());
                            }
                            jsonWriter.endObject();
                        }
                    }
                    jsonWriter.endObject();
                    jsonWriter.flush();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"IO error while saving datasources configuration", (Throwable)e);
        }
        String jsonString = dsConfigBuffer.toString(StandardCharsets.UTF_8);
        this.saveConfigFile(configurationManager, configurationStorage.getStorageName(), jsonString, this.registry.getProject().isEncryptedProject());
        if (!configurationManager.isSecure()) {
            this.saveSecureCredentialsFile(configurationManager, configurationStorage);
        }
    }

    private void saveNetworkProfiles(DataSourceConfigurationManager configurationManager, JsonWriter jsonWriter, List<DBWNetworkProfile> profiles) throws IOException {
        jsonWriter.name("network-profiles");
        jsonWriter.beginObject();
        for (DBWNetworkProfile np : profiles) {
            jsonWriter.name(np.getProfileId());
            jsonWriter.beginObject();
            JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"name", (String)np.getProfileName());
            JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"description", (String)np.getProfileDescription());
            jsonWriter.name("handlers");
            jsonWriter.beginObject();
            for (DBWHandlerConfiguration configuration : np.getConfigurations()) {
                if (!configuration.hasValuableInfo()) continue;
                this.saveNetworkHandlerConfiguration(configurationManager, jsonWriter, null, np, configuration, false);
            }
            jsonWriter.endObject();
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
    }

    private void saveAuthProfiles(DataSourceConfigurationManager configurationManager, JsonWriter jsonWriter, List<DBAAuthProfile> authProfiles) throws IOException {
        jsonWriter.name("auth-profiles");
        jsonWriter.beginObject();
        for (DBAAuthProfile authProfile : authProfiles) {
            jsonWriter.name(authProfile.getProfileId());
            jsonWriter.beginObject();
            JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"name", (String)authProfile.getProfileName());
            JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"description", (String)authProfile.getProfileDescription());
            JSONUtils.fieldNE((JsonWriter)jsonWriter, (String)"auth-model", (String)authProfile.getAuthModelId());
            if (authProfile.isSavePassword()) {
                JSONUtils.field((JsonWriter)jsonWriter, (String)"save-password", (boolean)authProfile.isSavePassword());
            }
            SecureCredentials credentials = new SecureCredentials(authProfile);
            if (configurationManager.isSecure()) {
                this.savePlainCredentials(jsonWriter, credentials);
            } else {
                this.saveSecuredCredentials(null, (DBPConfigurationProfile)authProfile, null, credentials);
            }
            jsonWriter.endObject();
        }
        jsonWriter.endObject();
    }

    private String loadConfigFile(InputStream stream, boolean decrypt) throws DBException, IOException {
        ByteArrayOutputStream credBuffer = new ByteArrayOutputStream();
        try {
            IOUtils.copyStream((InputStream)stream, (OutputStream)credBuffer);
        }
        catch (Exception e) {
            log.error((Object)"Error reading secure credentials file", (Throwable)e);
        }
        if (!decrypt) {
            return credBuffer.toString(StandardCharsets.UTF_8);
        }
        DBSValueEncryptor encryptor = this.registry.getProject().getValueEncryptor();
        try {
            return new String(encryptor.decryptValue(credBuffer.toByteArray()), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new IOException("Error decrypting encrypted file", e);
        }
    }

    private void saveConfigFile(DataSourceConfigurationManager configurationManager, String name, String contents, boolean encrypt) throws DBException, IOException {
        byte[] binaryContents = null;
        if (contents != null) {
            if (encrypt) {
                DBSValueEncryptor valueEncryptor = this.registry.getProject().getValueEncryptor();
                binaryContents = valueEncryptor.encryptValue(contents.getBytes(StandardCharsets.UTF_8));
            } else {
                binaryContents = contents.getBytes(StandardCharsets.UTF_8);
            }
        }
        configurationManager.writeConfiguration(name, binaryContents);
    }

    private void saveSecureCredentialsFile(DataSourceConfigurationManager configurationManager, DBPDataSourceConfigurationStorage storage) {
        String credFile = "credentials-config" + storage.getStorageSubId() + ".json";
        try {
            if (this.secureProperties.isEmpty()) {
                this.saveConfigFile(configurationManager, credFile, null, true);
            } else {
                String jsonString = CONFIG_GSON.toJson(this.secureProperties, Map.class);
                this.saveConfigFile(configurationManager, credFile, jsonString, true);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error saving secure credentials", (Throwable)e);
        }
    }

    @Override
    public boolean parseDataSources(@NotNull DBPDataSourceConfigurationStorage configurationStorage, @NotNull DataSourceConfigurationManager configurationManager, @NotNull DataSourceParseResults parseResults, @Nullable Collection<String> dataSourceIds) throws DBException, IOException {
        boolean connectionConfigurationChanged = false;
        Map<String, Map<String, Map<String, String>>> secureCredentialsMap = null;
        Map<String, Object> configurationMap = null;
        if (!DBWorkbench.getPlatform().getApplication().isHeadlessMode() && DBWorkbench.getPlatform().getApplication().isCommunity() && CommonUtils.toBoolean((Object)this.registry.getProject().getProjectProperty(ENCRYPTED_CONFIGURATION))) {
            DBWorkbench.getPlatformUI().showWarningMessageBox(RegistryMessages.project_open_cannot_read_configuration_title, NLS.bind((String)RegistryMessages.project_open_cannot_read_configuration_message, (Object)this.registry.getProject().getName()));
            throw new DBInterruptedException("Project secure credentials read canceled by user.");
        }
        try {
            configurationMap = this.readConfiguration(configurationStorage, configurationManager, dataSourceIds);
        }
        catch (DBInterruptedException e) {
            throw e;
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        if (!DBWorkbench.getPlatform().getApplication().isHeadlessMode() && DBWorkbench.getPlatform().getApplication().isCommunity() && CommonUtils.toBoolean((Object)this.registry.getProject().getProjectProperty(USE_PROJECT_PASSWORD))) {
            if (Boolean.parseBoolean(this.registry.getProject().getRuntimeProperty("user.decline.project.decryption"))) {
                throw new DBInterruptedException("Project secure credentials read canceled by user.");
            }
            if (DBWorkbench.getPlatformUI().confirmAction(RegistryMessages.project_open_cannot_read_credentials_title, NLS.bind((String)RegistryMessages.project_open_cannot_read_credentials_message, (Object)this.registry.getProject().getName()), RegistryMessages.project_open_cannot_read_credentials_button_text, true)) {
                log.info((Object)"The user agreed lost project credentials.");
                this.registry.getProject().setRuntimeProperty("user.decline.project.decryption", Boolean.FALSE.toString());
            } else {
                this.registry.getProject().setRuntimeProperty("user.decline.project.decryption", Boolean.TRUE.toString());
                throw new DBInterruptedException("Project secure credentials read canceled by user.");
            }
        }
        try {
            secureCredentialsMap = this.readSecureCredentials(configurationStorage, configurationManager, dataSourceIds);
        }
        catch (DBInterruptedException e) {
            throw e;
        }
        catch (DBException e) {
            log.error((Object)e);
        }
        if (secureCredentialsMap != null) {
            this.secureProperties.putAll(secureCredentialsMap);
        }
        if (configurationMap != null) {
            for (Map.Entry folderMap : JSONUtils.getNestedObjects(configurationMap, (String)CONFIGURATION_FOLDERS)) {
                DataSourceFolder folder;
                String name = (String)folderMap.getKey();
                String description = (String)JSONUtils.getObjectProperty(folderMap.getValue(), (String)"description");
                String parentFolder = (String)JSONUtils.getObjectProperty(folderMap.getValue(), (String)"parent");
                DataSourceFolder parent = parentFolder == null ? null : this.registry.findFolderByPath(parentFolder, true, parseResults);
                DataSourceFolder dataSourceFolder = folder = parent == null ? this.registry.findFolderByPath(name, true, parseResults) : parent.getChild(name);
                if (folder == null) {
                    folder = new DataSourceFolder(this.registry, parent, name, description);
                    parseResults.addedFolders.add(folder);
                    continue;
                }
                folder.setDescription(description);
                parseResults.updatedFolders.add(folder);
            }
            for (Map.Entry ctMap : JSONUtils.getNestedObjects(configurationMap, (String)"connection-types")) {
                String id = (String)ctMap.getKey();
                Map ctConfig = (Map)ctMap.getValue();
                String name = (String)JSONUtils.getObjectProperty((Object)ctConfig, (String)"name");
                String description = (String)JSONUtils.getObjectProperty((Object)ctConfig, (String)"description");
                String color = (String)JSONUtils.getObjectProperty((Object)ctConfig, (String)"color");
                Boolean autoCommit = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"auto-commit");
                Boolean confirmExecute = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"confirm-execute");
                Boolean confirmDataChange = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"confirm-data-change");
                Boolean smartCommit = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"smart-commit");
                Boolean smartCommitRecover = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"smart-commit-recover");
                Boolean autoCloseTransactions = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"auto-close-transactions");
                Object closeTransactionsPeriod = JSONUtils.getObjectProperty((Object)ctConfig, (String)"close-transactions-period");
                Boolean autoCloseConnections = (Boolean)JSONUtils.getObjectProperty((Object)ctConfig, (String)"auto-close-connections");
                Object closeConnectionsPeriod = JSONUtils.getObjectProperty((Object)ctConfig, (String)"close-connections-period");
                DBPConnectionType ct = DBWorkbench.getPlatform().getDataSourceProviderRegistry().getConnectionType(id, null);
                if (ct == null) {
                    ct = new DBPConnectionType(id, name, color, description, CommonUtils.toBoolean((Object)autoCommit), CommonUtils.toBoolean((Object)confirmExecute), CommonUtils.toBoolean((Object)confirmDataChange), CommonUtils.toBoolean((Object)smartCommit), CommonUtils.toBoolean((Object)smartCommitRecover), CommonUtils.toBoolean((Object)autoCloseTransactions), CommonUtils.toInt((Object)closeTransactionsPeriod), CommonUtils.toBoolean((Object)autoCloseConnections), CommonUtils.toInt((Object)closeConnectionsPeriod));
                    DBWorkbench.getPlatform().getDataSourceProviderRegistry().addConnectionType(ct);
                }
                this.deserializeModifyPermissions(ctConfig, (DBPDataSourcePermissionOwner)ct);
            }
            LinkedHashMap externalConfigurations = new LinkedHashMap();
            if (!DBWorkbench.isDistributed()) {
                for (Map.Entry ctMap : JSONUtils.getNestedObjects(configurationMap, (String)"external-configurations")) {
                    Iterator id = (String)ctMap.getKey();
                    Map configMap = (Map)ctMap.getValue();
                    externalConfigurations.put(id, new DBPExternalConfiguration(id, () -> configMap));
                }
            }
            LinkedHashMap<String, DBVModel> modelMap = new LinkedHashMap<String, DBVModel>();
            for (Map.Entry vmMap : JSONUtils.getNestedObjects(configurationMap, (String)"virtual-models")) {
                String id = (String)vmMap.getKey();
                DBVModel model = new DBVModel(id, (Map)vmMap.getValue());
                modelMap.put(id, model);
            }
            for (Map.Entry vmMap : JSONUtils.getNestedObjects(configurationMap, (String)"network-profiles")) {
                String profileId = (String)vmMap.getKey();
                Map profileMap = (Map)vmMap.getValue();
                DBWNetworkProfile profile = new DBWNetworkProfile(this.registry.getProject());
                profile.setProfileName(profileId);
                profile.setProfileName(profileId);
                profile.setProperties(JSONUtils.deserializeStringMap((Map)profileMap, (String)"properties"));
                for (Map.Entry handlerMap : JSONUtils.getNestedObjects((Map)profileMap, (String)"handlers")) {
                    DBWHandlerConfiguration configuration = this.parseNetworkHandlerConfig(configurationManager, null, profile, handlerMap);
                    if (configuration == null) continue;
                    profile.updateConfiguration(configuration);
                }
                this.registry.updateNetworkProfile(profile);
            }
            ArrayList<DBAAuthProfile> profiles = new ArrayList<DBAAuthProfile>();
            for (Map.Entry vmMap : JSONUtils.getNestedObjects(configurationMap, (String)"auth-profiles")) {
                String profileId = (String)vmMap.getKey();
                Map profileMap = (Map)vmMap.getValue();
                DBAAuthProfile profile = new DBAAuthProfile(this.registry.getProject());
                profile.setProfileId(profileId);
                profile.setProfileName(JSONUtils.getString((Map)profileMap, (String)"name"));
                profile.setAuthModelId(JSONUtils.getString((Map)profileMap, (String)"auth-model"));
                profile.setSavePassword(JSONUtils.getBoolean((Map)profileMap, (String)"save-password"));
                SecureCredentials authCreds = configurationManager.isSecure() ? this.readPlainCredentials(profileMap) : this.readSecuredCredentials(null, (DBPConfigurationProfile)profile, null);
                profile.setUserName(authCreds.getUserName());
                profile.setUserPassword(authCreds.getUserPassword());
                profile.setProperties(authCreds.getProperties());
                profiles.add(profile);
            }
            this.registry.setAuthProfiles(profiles);
            for (Map.Entry conMap : JSONUtils.getNestedObjects(configurationMap, (String)"connections")) {
                DBPConnectionConfigurationMigrator migrator;
                DBPDataSourceProvider dataSourceProvider;
                int keepAlive;
                String colorValue;
                String userPassword;
                boolean savePasswordApplicable;
                DriverDescriptor substitutedDriver;
                DriverDescriptor originalDriver;
                String id = (String)conMap.getKey();
                Map conObject = (Map)conMap.getValue();
                String originalProviderId = CommonUtils.toString(conObject.get(ATTR_ORIGINAL_PROVIDER));
                String originalDriverId = CommonUtils.toString(conObject.get(ATTR_ORIGINAL_DRIVER));
                String substitutedProviderId = CommonUtils.toString(conObject.get("provider"));
                String substitutedDriverId = CommonUtils.toString(conObject.get("driver"));
                if (CommonUtils.isEmpty((String)originalProviderId) || CommonUtils.isEmpty((String)originalDriverId)) {
                    substitutedDriver = originalDriver = DataSourceSerializerModern.parseDriver(id, substitutedProviderId, substitutedDriverId, !this.isDetachedProcess);
                } else {
                    originalDriver = DataSourceSerializerModern.parseDriver(id, originalProviderId, originalDriverId, !this.isDetachedProcess);
                    substitutedDriver = DataSourceSerializerModern.parseDriver(id, substitutedProviderId, substitutedDriverId, false);
                }
                if (originalDriver == null) continue;
                if (substitutedDriver == null || substitutedDriver.isTemporary()) {
                    substitutedDriver = originalDriver;
                }
                if (DataSourceSerializerModern.getReplacementDriver(substitutedDriver) == originalDriver) {
                    DriverDescriptor original = originalDriver;
                    originalDriver = substitutedDriver;
                    substitutedDriver = original;
                }
                substitutedDriver = DataSourceSerializerModern.getReplacementDriver(substitutedDriver);
                DBPDataSourceContainer dataSource = this.registry.getDataSource(id);
                boolean newDataSource = dataSource == null;
                DataSourceDescriptor oldDataSource = null;
                if (newDataSource) {
                    Object origin;
                    Map originProperties = JSONUtils.deserializeProperties((Map)conObject, (String)TAG_ORIGIN);
                    if (CommonUtils.isEmpty((Map)originProperties) || !originProperties.containsKey(ATTR_ORIGIN_TYPE)) {
                        origin = DataSourceOriginLocal.INSTANCE;
                    } else {
                        String originID = CommonUtils.toString(originProperties.remove(ATTR_ORIGIN_TYPE));
                        String extConfigID = CommonUtils.toString(originProperties.remove(ATTR_ORIGIN_CONFIGURATION));
                        DBPExternalConfiguration extConfig = null;
                        if (!CommonUtils.isEmpty((String)extConfigID)) {
                            extConfig = (DBPExternalConfiguration)externalConfigurations.get(extConfigID);
                        }
                        origin = new DataSourceOriginLazy(originID, originProperties, extConfig);
                    }
                    dataSource = (DataSourceDescriptor)this.registry.createDataSource(configurationStorage.isVirtual() ? this.registry.getDefaultStorage() : configurationStorage, (DBPDataSourceOrigin)origin, id, originalDriver, substitutedDriver, new DBPConnectionConfiguration());
                } else {
                    oldDataSource = (DataSourceDescriptor)this.registry.createDataSource(dataSource);
                    oldDataSource.setId(id);
                    dataSource.getConnectionConfiguration().setProperties(Collections.emptyMap());
                    dataSource.getConnectionConfiguration().setHandlers(Collections.emptyList());
                    dataSource.clearFilters();
                }
                this.deserializeDataSource(parseResults, dataSource, conObject);
                Map cfgObject = JSONUtils.getObject((Map)conObject, (String)"configuration");
                DBPConnectionConfiguration config = dataSource.getConnectionConfiguration();
                config.setHostName(JSONUtils.getString((Map)cfgObject, (String)"host"));
                config.setHostPort(JSONUtils.getString((Map)cfgObject, (String)"port"));
                config.setServerName(JSONUtils.getString((Map)cfgObject, (String)"server"));
                config.setDatabaseName(JSONUtils.getString((Map)cfgObject, (String)"database"));
                config.setUrl(JSONUtils.getString((Map)cfgObject, (String)"url"));
                SecureCredentials creds = configurationManager.isSecure() ? this.readPlainCredentials(cfgObject) : this.readSecuredCredentials((DataSourceDescriptor)dataSource, null, null);
                config.setUserName(creds.getUserName());
                if (dataSource.isSavePassword() || !CommonUtils.isEmpty((String)creds.getUserPassword())) {
                    config.setUserPassword(creds.getUserPassword());
                } else {
                    config.setUserPassword(null);
                }
                boolean bl = savePasswordApplicable = !dataSource.getProject().isUseSecretStorage() || dataSource.isSharedCredentials();
                if (savePasswordApplicable && !CommonUtils.isEmpty((String)creds.getUserPassword())) {
                    dataSource.setSavePassword(true);
                }
                dataSource.getConnectionConfiguration().setAuthProperties(creds.getProperties());
                dataSource.resetAllSecrets();
                String userName = JSONUtils.getString((Map)cfgObject, (String)"user");
                if (!CommonUtils.isEmpty((String)userName)) {
                    config.setUserName(userName);
                }
                if (!CommonUtils.isEmpty((String)(userPassword = JSONUtils.getString((Map)cfgObject, (String)"password")))) {
                    config.setUserPassword(userPassword);
                }
                config.setClientHomeId(JSONUtils.getString((Map)cfgObject, (String)"home"));
                config.setConfigProfileSource(JSONUtils.getString((Map)cfgObject, (String)"config-profile-source"));
                config.setConfigProfileName(JSONUtils.getString((Map)cfgObject, (String)"config-profile"));
                config.setConnectionType(DataSourceProviderRegistry.getInstance().getConnectionType(JSONUtils.getString((Map)cfgObject, (String)"type"), DBPConnectionType.DEFAULT_TYPE));
                String configurationType = JSONUtils.getString((Map)cfgObject, (String)"configurationType");
                if (!CommonUtils.isEmpty((String)configurationType)) {
                    config.setConfigurationType((DBPDriverConfigurationType)CommonUtils.valueOf(DBPDriverConfigurationType.class, (String)configurationType, (Enum)DBPDriverConfigurationType.MANUAL));
                }
                if (!CommonUtils.isEmpty((String)(colorValue = JSONUtils.getString((Map)cfgObject, (String)"color")))) {
                    config.setConnectionColor(colorValue);
                }
                if ((keepAlive = JSONUtils.getInteger((Map)cfgObject, (String)"keepAlive")) > 0) {
                    config.setKeepAliveInterval(keepAlive);
                }
                boolean closeIdleEnabled = JSONUtils.getBoolean((Map)cfgObject, (String)"closeIdleConnection");
                config.setCloseIdleConnection(closeIdleEnabled);
                int closeIdle = JSONUtils.getInteger((Map)cfgObject, (String)"closeIdle");
                if (closeIdle > 0) {
                    config.setCloseIdleInterval(closeIdle);
                }
                config.setProperties(JSONUtils.deserializeStringMap((Map)cfgObject, (String)"properties"));
                config.setProviderProperties(JSONUtils.deserializeStringMap((Map)cfgObject, (String)"provider-properties"));
                config.setAuthModelId(JSONUtils.getString((Map)cfgObject, (String)"auth-model"));
                if (cfgObject.containsKey("auth-properties")) {
                    config.setAuthProperties(JSONUtils.deserializeStringMapOrNull((Map)cfgObject, (String)"auth-properties"));
                }
                for (Map.Entry eventObject : JSONUtils.getNestedObjects((Map)cfgObject, (String)"events")) {
                    DBPConnectionEventType eventType = (DBPConnectionEventType)CommonUtils.valueOf(DBPConnectionEventType.class, (String)((String)eventObject.getKey()), (Enum)DBPConnectionEventType.BEFORE_CONNECT);
                    Map eventCfg = (Map)eventObject.getValue();
                    DBRShellCommand command = new DBRShellCommand("");
                    command.setEnabled(JSONUtils.getBoolean((Map)eventCfg, (String)"enabled"));
                    command.setShowProcessPanel(JSONUtils.getBoolean((Map)eventCfg, (String)"show-panel"));
                    command.setWaitProcessFinish(JSONUtils.getBoolean((Map)eventCfg, (String)"wait-process"));
                    if (command.isWaitProcessFinish()) {
                        command.setWaitProcessTimeoutMs(JSONUtils.getInteger((Map)eventCfg, (String)"wait-process-timeout"));
                    }
                    command.setTerminateAtDisconnect(JSONUtils.getBoolean((Map)eventCfg, (String)"terminate-at-disconnect"));
                    command.setPauseAfterExecute(JSONUtils.getInteger((Map)eventCfg, (String)"pauseAfterExecute"));
                    command.setWorkingDirectory(JSONUtils.getString((Map)eventCfg, (String)"workingDirectory"));
                    command.setCommand(JSONUtils.getString((Map)eventCfg, (String)"command"));
                    config.setEvent(eventType, command);
                }
                for (Map.Entry handlerObject : JSONUtils.getNestedObjects((Map)cfgObject, (String)"handlers")) {
                    DBWHandlerConfiguration configuration = this.parseNetworkHandlerConfig(configurationManager, (DataSourceDescriptor)dataSource, null, handlerObject);
                    if (configuration == null) continue;
                    dataSource.getConnectionConfiguration().updateHandler(configuration);
                }
                Map bootstrapCfg = JSONUtils.getObject((Map)cfgObject, (String)"bootstrap");
                if (!bootstrapCfg.isEmpty()) {
                    DBPConnectionBootstrap bootstrap = config.getBootstrap();
                    if (bootstrapCfg.containsKey("autocommit")) {
                        bootstrap.setDefaultAutoCommit(Boolean.valueOf(JSONUtils.getBoolean((Map)bootstrapCfg, (String)"autocommit")));
                    }
                    if (bootstrapCfg.containsKey("txnIsolation")) {
                        bootstrap.setDefaultTransactionIsolation(Integer.valueOf(JSONUtils.getInteger((Map)bootstrapCfg, (String)"txnIsolation")));
                    }
                    bootstrap.setDefaultCatalogName(JSONUtils.getString((Map)bootstrapCfg, (String)"defaultCatalog"));
                    bootstrap.setDefaultSchemaName(JSONUtils.getString((Map)bootstrapCfg, (String)"defaultSchema"));
                    String defObjectName = JSONUtils.getString((Map)bootstrapCfg, (String)"defaultObject");
                    if (!CommonUtils.isEmpty((String)defObjectName) && CommonUtils.isEmpty((String)bootstrap.getDefaultSchemaName())) {
                        bootstrap.setDefaultSchemaName(JSONUtils.getString((Map)bootstrapCfg, (String)defObjectName));
                    }
                    if (bootstrapCfg.containsKey("ignoreErrors")) {
                        bootstrap.setIgnoreErrors(JSONUtils.getBoolean((Map)bootstrapCfg, (String)"ignoreErrors"));
                    }
                    bootstrap.setInitQueries((Collection)JSONUtils.deserializeStringList((Map)bootstrapCfg, (String)"query"));
                }
                if (originalDriver != substitutedDriver && substitutedDriver.getProviderDescriptor().supportsDriverMigration() && (dataSourceProvider = substitutedDriver.getDataSourceProvider()) instanceof DBPConnectionConfigurationMigrator && (migrator = (DBPConnectionConfigurationMigrator)dataSourceProvider).migrationRequired(config)) {
                    DBPConnectionConfiguration migrated = new DBPConnectionConfiguration(config);
                    try {
                        migrator.migrateConfiguration(config, migrated);
                        dataSource.setConnectionInfo(migrated);
                        log.debug((Object)("Connection configuration for data source '" + id + "' was migrated successfully"));
                    }
                    catch (DBException e) {
                        log.error((Object)("Unable to migrate connection configuration for data source '" + id + "'"), (Throwable)e);
                    }
                }
                this.deserializeModifyPermissions(conObject, (DBPDataSourcePermissionOwner)dataSource);
                for (Map filterCfg : JSONUtils.getObjectList((Map)conObject, (String)"filters")) {
                    String typeName = JSONUtils.getString((Map)filterCfg, (String)"type");
                    String objectID = JSONUtils.getString((Map)filterCfg, (String)"id");
                    if (CommonUtils.isEmpty((String)typeName)) continue;
                    DBSObjectFilter filter = DataSourceSerializerModern.readObjectFiler(filterCfg);
                    dataSource.updateObjectFilter(typeName, objectID, filter);
                }
                dataSource.setTags(JSONUtils.deserializeStringMap((Map)conObject, (String)"tags"));
                Map preferenceProperties = dataSource.getPreferenceStore().getProperties();
                preferenceProperties.clear();
                preferenceProperties.putAll(JSONUtils.deserializeStringMap((Map)conObject, (String)"custom-properties"));
                LinkedHashMap extensions = null;
                if (conObject.containsKey("properties")) {
                    extensions = JSONUtils.deserializeProperties((Map)conObject, (String)"properties");
                } else if (conObject.containsKey("extensions")) {
                    extensions = JSONUtils.deserializeProperties((Map)conObject, (String)"extensions");
                }
                if (extensions == null) {
                    extensions = new LinkedHashMap();
                }
                dataSource.setExtensions(extensions);
                String vmID = CommonUtils.toString(conObject.get("virtual-model-id"), (String)id);
                DBVModel dbvModel = (DBVModel)modelMap.get(vmID);
                if (dbvModel != null) {
                    dataSource.setVirtualModel(dbvModel);
                }
                this.deserializeAdditionalProperties(dataSource, conObject);
                if (newDataSource) {
                    parseResults.addedDataSources.add(dataSource);
                    connectionConfigurationChanged = true;
                    continue;
                }
                parseResults.updatedDataSources.add(dataSource);
                if (dataSource.equalSettings(oldDataSource)) continue;
                connectionConfigurationChanged = true;
            }
            for (Map ctMap : JSONUtils.getObjectList(configurationMap, (String)"saved-filters")) {
                DBSObjectFilter filter = DataSourceSerializerModern.readObjectFiler(ctMap);
                this.registry.addSavedFilter(filter);
            }
        }
        return connectionConfigurationChanged;
    }

    protected void deserializeDataSource(@NotNull DataSourceParseResults parseResults, @NotNull T dataSource, @NotNull Map<String, Object> conObject) {
        ((DataSourceDescriptor)dataSource).setName((String)CommonUtils.notNull((Object)JSONUtils.getString(conObject, (String)"name"), (Object)"?"));
        ((DataSourceDescriptor)dataSource).setDescription(JSONUtils.getString(conObject, (String)"description"));
        ((DataSourceDescriptor)dataSource).forceSetSharedCredentials(JSONUtils.getBoolean(conObject, (String)"shared-credentials"));
        ((DataSourceDescriptor)dataSource).setSavePassword(JSONUtils.getBoolean(conObject, (String)"save-password"));
        ((DataSourceDescriptor)dataSource).setDriverSubstitution(DataSourceProviderRegistry.getInstance().getDriverSubstitution(CommonUtils.notEmpty((String)JSONUtils.getString(conObject, (String)ATTR_DRIVER_SUBSTITUTION))));
        DataSourceNavigatorSettings navSettings = ((DataSourceDescriptor)dataSource).getNavigatorSettings();
        navSettings.setShowSystemObjects(JSONUtils.getBoolean(conObject, (String)ATTR_NAVIGATOR_SHOW_SYSTEM_OBJECTS));
        navSettings.setShowUtilityObjects(JSONUtils.getBoolean(conObject, (String)ATTR_NAVIGATOR_SHOW_UTIL_OBJECTS));
        navSettings.setShowOnlyEntities(JSONUtils.getBoolean(conObject, (String)ATTR_NAVIGATOR_SHOW_ONLY_ENTITIES));
        navSettings.setHideFolders(JSONUtils.getBoolean(conObject, (String)ATTR_NAVIGATOR_HIDE_FOLDERS));
        navSettings.setHideSchemas(JSONUtils.getBoolean(conObject, (String)ATTR_NAVIGATOR_HIDE_SCHEMAS));
        navSettings.setHideVirtualModel(JSONUtils.getBoolean(conObject, (String)ATTR_NAVIGATOR_HIDE_VIRTUAL));
        navSettings.setMergeEntities(JSONUtils.getBoolean(conObject, (String)ATTR_NAVIGATOR_MERGE_ENTITIES));
        ((DataSourceDescriptor)dataSource).setConnectionReadOnly(JSONUtils.getBoolean(conObject, (String)"read-only"));
        String folderPath = JSONUtils.getString(conObject, (String)"folder");
        ((DataSourceDescriptor)dataSource).setFolder(folderPath == null ? null : this.registry.findFolderByPath(folderPath, true, parseResults));
        ((DataSourceDescriptor)dataSource).setLockPasswordHash(CommonUtils.toString((Object)conObject.get("lockPassword")));
    }

    protected void deserializeAdditionalProperties(@NotNull T dataSource, @NotNull Map<String, Object> conObject) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Map<String, Map<String, Map<String, String>>> readSecureCredentials(@NotNull DBPDataSourceConfigurationStorage configurationStorage, @NotNull DataSourceConfigurationManager configurationManager, @Nullable Collection<String> dataSourceIds) throws DBException {
        if (configurationManager.isSecure()) {
            return null;
        }
        String name = "credentials-config" + configurationStorage.getStorageSubId() + ".json";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream is = configurationManager.readConfiguration(name, dataSourceIds);){
                if (is == null) {
                    return null;
                }
                String data = this.loadConfigFile(is, true);
                return (Map)CONFIG_GSON.fromJson(data, new TypeToken<Map<String, Map<String, Map<String, String>>>>(){}.getType());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBException("Project secure credentials can not be read", (Throwable)e);
        }
    }

    @Nullable
    private Map<String, Object> readConfiguration(@NotNull DBPDataSourceConfigurationStorage configurationStorage, @NotNull DataSourceConfigurationManager configurationManager, @Nullable Collection<String> dataSourceIds) throws DBException, IOException {
        InputStream is = configurationStorage instanceof DataSourceMemoryStorage ? ((DataSourceMemoryStorage)configurationStorage).getInputStream() : configurationManager.readConfiguration(configurationStorage.getStorageName(), dataSourceIds);
        if (is == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try {
                try {
                    String data = this.loadConfigFile(is, CommonUtils.toBoolean((Object)this.registry.getProject().isEncryptedProject()));
                    return JSONUtils.parseMap((Gson)CONFIG_GSON, (Reader)new StringReader(data));
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBInterruptedException e) {
            throw e;
        }
        catch (IOException e) {
            throw new DBException(e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    private static DriverDescriptor parseDriver(@NotNull String id, @NotNull String providerId, @NotNull String driverId, boolean createIfAbsent) {
        DriverDescriptor driver;
        if (CommonUtils.isEmpty((String)providerId)) {
            log.debug((Object)("Empty datasource provider for datasource '" + id + "'"));
            return null;
        }
        if (CommonUtils.isEmpty((String)driverId)) {
            log.debug((Object)("Empty driver for datasource '" + id + "'"));
            return null;
        }
        DataSourceProviderDescriptor provider = DataSourceProviderRegistry.getInstance().getDataSourceProvider(providerId);
        if (provider == null) {
            if (createIfAbsent) {
                log.debug((Object)("Can't find datasource provider " + providerId + " for datasource '" + id + "'"));
                provider = (DataSourceProviderDescriptor)DataSourceProviderRegistry.getInstance().makeFakeProvider(providerId);
            } else {
                return null;
            }
        }
        if ((driver = provider.getOriginalDriver(driverId)) == null) {
            if (createIfAbsent) {
                log.debug((Object)("Can't find driver " + driverId + " in datasource provider " + provider.getId() + " for datasource '" + id + "'. Create new driver"));
                driver = provider.createDriver(driverId);
                driver.setName(driverId);
                driver.setDescription("Missing driver " + driverId);
                driver.setTemporary(true);
                provider.addDriver(driver);
            } else {
                return null;
            }
        }
        return driver;
    }

    private void deserializeModifyPermissions(@Nullable Map<String, Object> conObject, @NotNull DBPDataSourcePermissionOwner permissionOwner) {
        List permissionRestrictions;
        if (conObject == null) {
            return;
        }
        Map securityCfg = JSONUtils.getObject(conObject, (String)"security");
        if (!CommonUtils.isEmpty((Map)securityCfg) && !CommonUtils.isEmpty((Collection)(permissionRestrictions = JSONUtils.deserializeStringList((Map)securityCfg, (String)"permission-restrictions")))) {
            ArrayList<DBPDataSourcePermission> permissions = new ArrayList<DBPDataSourcePermission>();
            for (String perm : permissionRestrictions) {
                try {
                    permissions.add(DBPDataSourcePermission.getById((String)perm));
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)e);
                }
            }
            if (!permissions.isEmpty()) {
                permissionOwner.setModifyPermissions(permissions);
            }
        }
    }

    @Nullable
    private DBWHandlerConfiguration parseNetworkHandlerConfig(DataSourceConfigurationManager configurationManager, @Nullable DataSourceDescriptor dataSource, @Nullable DBWNetworkProfile profile, @NotNull Map.Entry<String, Map<String, Object>> handlerObject) {
        Map properties;
        String userPassword;
        String userName;
        String handlerId = handlerObject.getKey();
        Map<String, Object> handlerCfg = handlerObject.getValue();
        NetworkHandlerDescriptor handlerDescriptor = NetworkHandlerRegistry.getInstance().getDescriptor(handlerId);
        if (handlerDescriptor == null) {
            if (!this.isDetachedProcess) {
                log.warn((Object)("Can't find network handler '" + handlerId + "'"));
            }
            return null;
        }
        DBWHandlerConfiguration curNetworkHandler = new DBWHandlerConfiguration((DBWHandlerDescriptor)handlerDescriptor, (DBPDataSourceContainer)dataSource);
        curNetworkHandler.setEnabled(JSONUtils.getBoolean(handlerCfg, (String)"enabled"));
        curNetworkHandler.setSavePassword(JSONUtils.getBoolean(handlerCfg, (String)"save-password"));
        SecureCredentials creds = configurationManager.isSecure() ? this.readPlainCredentials(handlerCfg) : this.readSecuredCredentials(dataSource, (DBPConfigurationProfile)profile, "network/" + handlerId + (String)(profile == null ? "" : "/profile/" + profile.getProfileName()));
        curNetworkHandler.setUserName(creds.getUserName());
        if (curNetworkHandler.isSavePassword()) {
            curNetworkHandler.setPassword(creds.getUserPassword());
        }
        if (creds.getProperties() != null) {
            curNetworkHandler.setSecureProperties(creds.getProperties());
        }
        if (!CommonUtils.isEmpty((String)(userName = JSONUtils.getString(handlerCfg, (String)"user")))) {
            curNetworkHandler.setUserName(userName);
        }
        if (!CommonUtils.isEmpty((String)(userPassword = JSONUtils.getString(handlerCfg, (String)"password")))) {
            curNetworkHandler.setPassword(userPassword);
        }
        if ((properties = JSONUtils.deserializeProperties(handlerCfg, (String)"properties")) != null) {
            curNetworkHandler.setProperties(properties);
        }
        return curNetworkHandler;
    }

    @NotNull
    private static DBSObjectFilter readObjectFiler(@NotNull Map<String, Object> map) {
        DBSObjectFilter filter = new DBSObjectFilter();
        filter.setName(JSONUtils.getString(map, (String)"name"));
        filter.setDescription(JSONUtils.getString(map, (String)"description"));
        filter.setEnabled(JSONUtils.getBoolean(map, (String)"enabled"));
        filter.setInclude(JSONUtils.deserializeStringList(map, (String)"include"));
        filter.setExclude(JSONUtils.deserializeStringList(map, (String)"exclude"));
        return filter;
    }

    private static void saveFolder(@NotNull JsonWriter json, @NotNull DataSourceFolder folder) throws IOException {
        json.name(folder.getName());
        json.beginObject();
        if (folder.getParent() != null) {
            JSONUtils.field((JsonWriter)json, (String)"parent", (String)folder.getParent().getFolderPath());
        }
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)folder.getDescription());
        json.endObject();
    }

    protected void saveDataSource(@NotNull DataSourceConfigurationManager configurationManager, @NotNull JsonWriter json, @NotNull T dataSource, @NotNull Map<String, DBPExternalConfiguration> externalConfigurations) throws IOException {
        json.name(((DataSourceDescriptor)dataSource).getId());
        json.beginObject();
        this.serializeDataSource(configurationManager, json, dataSource, externalConfigurations);
        json.endObject();
    }

    /*
     * WARNING - void declaration
     */
    protected void serializeDataSource(@NotNull DataSourceConfigurationManager configurationManager, @NotNull JsonWriter json, @NotNull T dataSource, @NotNull Map<String, DBPExternalConfiguration> externalConfigurations) throws IOException {
        void var11_15;
        DBPConnectionBootstrap bootstrap;
        String lockPasswordHash;
        DataSourceNavigatorSettings navSettings;
        DBPDataSourceOrigin origin;
        JSONUtils.field((JsonWriter)json, (String)"provider", (String)((DataSourceDescriptor)dataSource).getDriver().getProviderDescriptor().getId());
        JSONUtils.field((JsonWriter)json, (String)"driver", (String)((DataSourceDescriptor)dataSource).getDriver().getId());
        if (((DataSourceDescriptor)dataSource).getDriver() != ((DataSourceDescriptor)dataSource).getOriginalDriver()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_ORIGINAL_PROVIDER, (String)((DataSourceDescriptor)dataSource).getOriginalDriver().getProviderDescriptor().getId());
            JSONUtils.field((JsonWriter)json, (String)ATTR_ORIGINAL_DRIVER, (String)((DataSourceDescriptor)dataSource).getOriginalDriver().getId());
        }
        if (((DataSourceDescriptor)dataSource).getDriverSubstitution() != null) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_DRIVER_SUBSTITUTION, (String)((DataSourceDescriptor)dataSource).getDriverSubstitution().getId());
        }
        if ((origin = ((DataSourceDescriptor)dataSource).getOriginSource()) != DataSourceOriginLocal.INSTANCE) {
            DBPExternalConfiguration externalConfiguration;
            LinkedHashMap<String, String> originProps = new LinkedHashMap<String, String>();
            originProps.put(ATTR_ORIGIN_TYPE, origin.getType());
            if (origin instanceof DBPDataSourceOriginExternal && (externalConfiguration = ((DBPDataSourceOriginExternal)origin).getExternalConfiguration()) != null) {
                originProps.put(ATTR_ORIGIN_CONFIGURATION, externalConfiguration.getId());
                externalConfigurations.put(externalConfiguration.getId(), externalConfiguration);
            }
            originProps.putAll(origin.getDataSourceConfiguration());
            JSONUtils.serializeProperties((JsonWriter)json, (String)TAG_ORIGIN, originProps);
        }
        JSONUtils.field((JsonWriter)json, (String)"name", (String)((DataSourceDescriptor)dataSource).getName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)((DataSourceDescriptor)dataSource).getDescription());
        if (((DataSourceDescriptor)dataSource).isSavePassword()) {
            JSONUtils.field((JsonWriter)json, (String)"save-password", (boolean)true);
        }
        if (((DataSourceDescriptor)dataSource).isSharedCredentials()) {
            JSONUtils.field((JsonWriter)json, (String)"shared-credentials", (boolean)true);
        }
        if ((navSettings = ((DataSourceDescriptor)dataSource).getNavigatorSettings()).isShowSystemObjects()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_SHOW_SYSTEM_OBJECTS, (boolean)true);
        }
        if (navSettings.isShowUtilityObjects()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_SHOW_UTIL_OBJECTS, (boolean)true);
        }
        if (navSettings.isShowOnlyEntities()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_SHOW_ONLY_ENTITIES, (boolean)true);
        }
        if (navSettings.isHideFolders()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_HIDE_FOLDERS, (boolean)true);
        }
        if (navSettings.isHideSchemas()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_HIDE_SCHEMAS, (boolean)true);
        }
        if (navSettings.isHideVirtualModel()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_HIDE_VIRTUAL, (boolean)true);
        }
        if (navSettings.isMergeEntities()) {
            JSONUtils.field((JsonWriter)json, (String)ATTR_NAVIGATOR_MERGE_ENTITIES, (boolean)true);
        }
        if (((DataSourceDescriptor)dataSource).isConnectionReadOnly()) {
            JSONUtils.field((JsonWriter)json, (String)"read-only", (boolean)true);
        }
        if (((DataSourceDescriptor)dataSource).getFolder() != null) {
            JSONUtils.field((JsonWriter)json, (String)"folder", (String)((DataSourceDescriptor)dataSource).getFolder().getFolderPath());
        }
        if (!CommonUtils.isEmpty((String)(lockPasswordHash = ((DataSourceDescriptor)dataSource).getLockPasswordHash()))) {
            JSONUtils.field((JsonWriter)json, (String)"lockPassword", (String)lockPasswordHash);
        }
        if (((DataSourceDescriptor)dataSource).hasSharedVirtualModel()) {
            JSONUtils.field((JsonWriter)json, (String)"virtual-model-id", (String)((DataSourceDescriptor)dataSource).getVirtualModel().getId());
        }
        DBPConnectionConfiguration connectionInfo = ((DataSourceDescriptor)dataSource).getConnectionConfiguration();
        json.name("configuration");
        json.beginObject();
        JSONUtils.fieldNE((JsonWriter)json, (String)"host", (String)connectionInfo.getHostName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"port", (String)connectionInfo.getHostPort());
        JSONUtils.fieldNE((JsonWriter)json, (String)"server", (String)connectionInfo.getServerName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"database", (String)connectionInfo.getDatabaseName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"url", (String)connectionInfo.getUrl());
        JSONUtils.fieldNE((JsonWriter)json, (String)"configurationType", (String)connectionInfo.getConfigurationType().toString());
        if (!((DataSourceDescriptor)dataSource).getProject().isUseSecretStorage()) {
            if (configurationManager.isSecure()) {
                this.savePlainCredentials(json, new SecureCredentials((DBPDataSourceContainer)dataSource));
            } else {
                this.saveSecuredCredentials((DataSourceDescriptor)dataSource, null, null, new SecureCredentials((DBPDataSourceContainer)dataSource));
            }
        }
        JSONUtils.fieldNE((JsonWriter)json, (String)"home", (String)connectionInfo.getClientHomeId());
        if (connectionInfo.getConnectionType() != null) {
            JSONUtils.field((JsonWriter)json, (String)"type", (String)connectionInfo.getConnectionType().getId());
        }
        JSONUtils.fieldNE((JsonWriter)json, (String)"color", (String)connectionInfo.getConnectionColor());
        if (connectionInfo.getKeepAliveInterval() > 0) {
            JSONUtils.field((JsonWriter)json, (String)"keepAlive", (long)connectionInfo.getKeepAliveInterval());
        }
        JSONUtils.field((JsonWriter)json, (String)"closeIdleConnection", (boolean)connectionInfo.isCloseIdleConnection());
        if (connectionInfo.getCloseIdleInterval() > 0) {
            JSONUtils.field((JsonWriter)json, (String)"closeIdle", (long)connectionInfo.getCloseIdleInterval());
        }
        JSONUtils.fieldNE((JsonWriter)json, (String)"config-profile-source", (String)connectionInfo.getConfigProfileSource());
        JSONUtils.fieldNE((JsonWriter)json, (String)"config-profile", (String)connectionInfo.getConfigProfileName());
        JSONUtils.serializeProperties((JsonWriter)json, (String)"properties", (Map)connectionInfo.getProperties(), (boolean)true);
        JSONUtils.serializeProperties((JsonWriter)json, (String)"provider-properties", (Map)connectionInfo.getProviderProperties(), (boolean)true);
        JSONUtils.fieldNE((JsonWriter)json, (String)"auth-model", (String)connectionInfo.getAuthModelId());
        if (!ArrayUtils.isEmpty((Object[])connectionInfo.getDeclaredEvents())) {
            json.name("events");
            json.beginObject();
            DBPConnectionEventType[] dBPConnectionEventTypeArray = connectionInfo.getDeclaredEvents();
            int n = dBPConnectionEventTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBPConnectionEventType eventType = dBPConnectionEventTypeArray[n2];
                DBRShellCommand command = connectionInfo.getEvent(eventType);
                if (command.isEnabled()) {
                    json.name(eventType.name());
                    json.beginObject();
                    JSONUtils.field((JsonWriter)json, (String)"enabled", (boolean)command.isEnabled());
                    JSONUtils.field((JsonWriter)json, (String)"show-panel", (boolean)command.isShowProcessPanel());
                    JSONUtils.field((JsonWriter)json, (String)"wait-process", (boolean)command.isWaitProcessFinish());
                    if (command.isWaitProcessFinish()) {
                        JSONUtils.field((JsonWriter)json, (String)"wait-process-timeout", (long)command.getWaitProcessTimeoutMs());
                    }
                    JSONUtils.field((JsonWriter)json, (String)"terminate-at-disconnect", (boolean)command.isTerminateAtDisconnect());
                    JSONUtils.field((JsonWriter)json, (String)"pauseAfterExecute", (long)command.getPauseAfterExecute());
                    JSONUtils.fieldNE((JsonWriter)json, (String)"workingDirectory", (String)command.getWorkingDirectory());
                    JSONUtils.fieldNE((JsonWriter)json, (String)"command", (String)command.getCommand());
                    json.endObject();
                }
                ++n2;
            }
            json.endObject();
        }
        if (!CommonUtils.isEmpty((Collection)connectionInfo.getHandlers())) {
            json.name("handlers");
            json.beginObject();
            String configProfileName = connectionInfo.getConfigProfileName();
            DBWNetworkProfile networkProfile = CommonUtils.isEmpty((String)configProfileName) ? null : this.registry.getNetworkProfile(connectionInfo.getConfigProfileSource(), configProfileName);
            for (DBWHandlerConfiguration dBWHandlerConfiguration : connectionInfo.getHandlers()) {
                if (!dBWHandlerConfiguration.isEnabled()) continue;
                DBWHandlerConfiguration profileConfig = networkProfile == null ? null : networkProfile.getConfiguration(dBWHandlerConfiguration.getHandlerDescriptor());
                this.saveNetworkHandlerConfiguration(configurationManager, json, (DataSourceDescriptor)dataSource, null, dBWHandlerConfiguration, profileConfig != null);
            }
            json.endObject();
        }
        if ((bootstrap = connectionInfo.getBootstrap()).hasData()) {
            json.name("bootstrap");
            json.beginObject();
            if (bootstrap.getDefaultAutoCommit() != null) {
                JSONUtils.field((JsonWriter)json, (String)"autocommit", (boolean)bootstrap.getDefaultAutoCommit());
            }
            if (bootstrap.getDefaultTransactionIsolation() != null) {
                JSONUtils.field((JsonWriter)json, (String)"txnIsolation", (Number)bootstrap.getDefaultTransactionIsolation());
            }
            JSONUtils.fieldNE((JsonWriter)json, (String)"defaultCatalog", (String)bootstrap.getDefaultCatalogName());
            JSONUtils.fieldNE((JsonWriter)json, (String)"defaultSchema", (String)bootstrap.getDefaultSchemaName());
            if (bootstrap.isIgnoreErrors()) {
                JSONUtils.field((JsonWriter)json, (String)"ignoreErrors", (boolean)true);
            }
            JSONUtils.serializeStringList((JsonWriter)json, (String)"query", (Collection)bootstrap.getInitQueries());
            json.endObject();
        }
        json.endObject();
        this.serializeModifyPermissions(json, (DBPDataSourcePermissionOwner)dataSource);
        Collection<FilterMapping> filterMappings = ((DataSourceDescriptor)dataSource).getObjectFilters();
        if (!CommonUtils.isEmpty(filterMappings)) {
            json.name("filters");
            json.beginArray();
            for (FilterMapping filter : filterMappings) {
                if (filter.defaultFilter != null && !filter.defaultFilter.isEmpty()) {
                    DataSourceSerializerModern.saveObjectFiler(json, filter.typeName, null, filter.defaultFilter);
                }
                for (Map.Entry entry : filter.customFilters.entrySet()) {
                    if (((DBSObjectFilter)entry.getValue()).isEmpty()) continue;
                    DataSourceSerializerModern.saveObjectFiler(json, filter.typeName, (String)entry.getKey(), (DBSObjectFilter)entry.getValue());
                }
            }
            json.endArray();
        }
        JSONUtils.serializeProperties((JsonWriter)json, (String)"tags", ((DataSourceDescriptor)dataSource).getTags(), (boolean)true);
        DataSourcePreferenceStore prefStore = ((DataSourceDescriptor)dataSource).getPreferenceStore();
        TreeMap<String, String> props = new TreeMap<String, String>();
        String[] stringArray = prefStore.preferenceNames();
        int n3 = stringArray.length;
        boolean bl = false;
        while (var11_15 < n3) {
            String propName = stringArray[var11_15];
            String propValue = prefStore.getString(propName);
            String defValue = prefStore.getDefaultString(propName);
            if (propValue != null && !CommonUtils.equalObjects((Object)propValue, (Object)defValue)) {
                props.put(propName, propValue);
            }
            ++var11_15;
        }
        if (!props.isEmpty()) {
            JSONUtils.serializeProperties((JsonWriter)json, (String)"custom-properties", props, (boolean)true);
        }
        JSONUtils.serializeProperties((JsonWriter)json, (String)"extensions", ((DataSourceDescriptor)dataSource).getExtensions(), (boolean)true);
    }

    private void serializeModifyPermissions(@NotNull JsonWriter json, @NotNull DBPDataSourcePermissionOwner permissionOwner) throws IOException {
        List permissions = permissionOwner.getModifyPermission();
        if (!CommonUtils.isEmpty((Collection)permissions)) {
            json.name("security");
            json.beginObject();
            ArrayList<String> permIds = new ArrayList<String>(permissions.size());
            for (DBPDataSourcePermission perm : permissions) {
                permIds.add(perm.getId());
            }
            JSONUtils.serializeStringList((JsonWriter)json, (String)"permission-restrictions", permIds);
            json.endObject();
        }
    }

    private void saveNetworkHandlerConfiguration(@NotNull DataSourceConfigurationManager configurationManager, @NotNull JsonWriter json, @Nullable DataSourceDescriptor dataSource, @Nullable DBWNetworkProfile profile, @NotNull DBWHandlerConfiguration configuration, boolean referenceOnly) throws IOException {
        json.name(CommonUtils.notEmpty((String)configuration.getId()));
        json.beginObject();
        JSONUtils.field((JsonWriter)json, (String)"type", (String)configuration.getType().name());
        JSONUtils.field((JsonWriter)json, (String)"enabled", (boolean)configuration.isEnabled());
        if (!referenceOnly) {
            JSONUtils.field((JsonWriter)json, (String)"save-password", (boolean)configuration.isSavePassword());
            if (!(CommonUtils.isEmpty((String)configuration.getUserName()) && CommonUtils.isEmpty((String)configuration.getPassword()) && CommonUtils.isEmpty((Map)configuration.getSecureProperties()))) {
                DBPProject project;
                SecureCredentials credentials = new SecureCredentials(configuration);
                credentials.setProperties(configuration.getSecureProperties());
                Object object = dataSource != null ? dataSource.getProject() : (project = profile != null ? profile.getProject() : null);
                if (configurationManager.isSecure() || project != null && project.isUseSecretStorage() && profile == null && dataSource.isSharedCredentials()) {
                    this.savePlainCredentials(json, credentials);
                } else {
                    this.saveSecuredCredentials(dataSource, (DBPConfigurationProfile)profile, "network/" + configuration.getId() + (String)(profile == null ? "" : "/profile/" + profile.getProfileName()), credentials);
                }
            }
            JSONUtils.serializeProperties((JsonWriter)json, (String)"properties", (Map)configuration.getProperties(), (boolean)true);
        }
        json.endObject();
    }

    private static void saveObjectFiler(@NotNull JsonWriter json, @Nullable String typeName, @Nullable String objectID, @NotNull DBSObjectFilter filter) throws IOException {
        json.beginObject();
        JSONUtils.fieldNE((JsonWriter)json, (String)"id", (String)objectID);
        JSONUtils.fieldNE((JsonWriter)json, (String)"type", (String)typeName);
        JSONUtils.fieldNE((JsonWriter)json, (String)"name", (String)filter.getName());
        JSONUtils.fieldNE((JsonWriter)json, (String)"description", (String)filter.getDescription());
        JSONUtils.field((JsonWriter)json, (String)"enabled", (boolean)filter.isEnabled());
        JSONUtils.serializeStringList((JsonWriter)json, (String)"include", (Collection)filter.getInclude());
        JSONUtils.serializeStringList((JsonWriter)json, (String)"exclude", (Collection)filter.getExclude());
        json.endObject();
    }

    private void saveSecuredCredentials(@Nullable DataSourceDescriptor dataSource, @Nullable DBPConfigurationProfile profile, @Nullable String subNode, @NotNull SecureCredentials credentials) {
        Object topNodeId;
        assert (dataSource != null || profile != null);
        if (this.registry.getProject().isUseSecretStorage()) {
            return;
        }
        Object object = topNodeId = profile != null ? "profile:" + profile.getProfileId() : dataSource.getId();
        if (subNode == null) {
            subNode = NODE_CONNECTION;
        }
        Map nodeMap = this.secureProperties.computeIfAbsent((String)topNodeId, s -> new LinkedHashMap());
        Map propMap = nodeMap.computeIfAbsent(subNode, s -> new LinkedHashMap());
        this.saveCredentialsToMap(propMap, credentials);
        if (propMap.isEmpty()) {
            nodeMap.remove(subNode);
        }
        if (nodeMap.isEmpty()) {
            this.secureProperties.remove(topNodeId);
        }
    }

    private void savePlainCredentials(@NotNull JsonWriter jsonWriter, @NotNull SecureCredentials credentials) throws IOException {
        LinkedHashMap<String, String> propMap = new LinkedHashMap<String, String>();
        this.saveCredentialsToMap(propMap, credentials);
        JSONUtils.serializeProperties((JsonWriter)jsonWriter, (String)"credentials", propMap, (boolean)true);
    }

    private void saveCredentialsToMap(@NotNull Map<String, String> propMap, @NotNull SecureCredentials credentials) {
        if (!CommonUtils.isEmpty((String)credentials.getUserName())) {
            propMap.put("user", credentials.getUserName());
        }
        if (!CommonUtils.isEmpty((String)credentials.getUserPassword())) {
            propMap.put("password", credentials.getUserPassword());
        }
        if (!CommonUtils.isEmpty(credentials.getProperties())) {
            propMap.putAll(credentials.getProperties());
        }
    }

    @NotNull
    private SecureCredentials readPlainCredentials(@NotNull Map<String, Object> propMap) {
        Map credentialsMap = JSONUtils.getObject(propMap, (String)"credentials");
        SecureCredentials creds = new SecureCredentials();
        for (Map.Entry entry : credentialsMap.entrySet()) {
            String value = CommonUtils.toString(entry.getValue(), null);
            switch ((String)entry.getKey()) {
                case "user": {
                    creds.setUserName(value);
                    break;
                }
                case "password": {
                    creds.setUserPassword(value);
                    break;
                }
                default: {
                    creds.setSecureProp((String)entry.getKey(), value);
                }
            }
        }
        return creds;
    }

    @NotNull
    private SecureCredentials readSecuredCredentials(@Nullable DataSourceDescriptor dataSource, @Nullable DBPConfigurationProfile profile, @Nullable String subNode) {
        SecureCredentials creds;
        block13: {
            Map<String, String> propMap;
            Map<String, Map<String, String>> subMap;
            Object topNodeId;
            assert (dataSource != null || profile != null);
            creds = new SecureCredentials();
            Object object = topNodeId = profile != null ? "profile:" + profile.getProfileId() : dataSource.getId();
            if (subNode == null) {
                subNode = NODE_CONNECTION;
            }
            if ((subMap = this.secureProperties.get(topNodeId)) == null || (propMap = subMap.get(subNode)) == null) break block13;
            for (Map.Entry<String, String> prop : propMap.entrySet()) {
                switch (prop.getKey()) {
                    case "user": {
                        creds.setUserName(prop.getValue());
                        break;
                    }
                    case "password": {
                        creds.setUserPassword(prop.getValue());
                        break;
                    }
                    default: {
                        creds.setSecureProp(prop.getKey(), prop.getValue());
                    }
                }
            }
        }
        return creds;
    }

    @NotNull
    private static DriverDescriptor getReplacementDriver(@NotNull DriverDescriptor driver) {
        DriverDescriptor replacement = driver;
        while (replacement.getReplacedBy() != null) {
            replacement = replacement.getReplacedBy();
        }
        return replacement;
    }
}

