/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.ConfigCommand;
import com.sun.j3d.utils.universe.ConfigDevice;
import com.sun.j3d.utils.universe.ConfigObject;
import com.sun.j3d.utils.universe.ConfigSensor;
import java.util.ArrayList;
import javax.media.j3d.InputDevice;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4d;

class ConfigPhysicalEnvironment
extends ConfigObject {
    PhysicalEnvironment j3dPhysicalEnvironment = null;
    Matrix4d coexistenceToTrackerBase = null;
    private ConfigSensor headTracker = null;
    private ArrayList inputDevices = new ArrayList();
    private int coexistenceCenterInPworldPolicy = 2;

    ConfigPhysicalEnvironment() {
    }

    @Override
    protected void initialize(ConfigCommand configCommand) {
    }

    @Override
    protected void setProperty(ConfigCommand configCommand) {
        Object[] objectArray = configCommand.argv;
        int n = configCommand.argc;
        if (n != 4) {
            this.syntaxError("Incorrect number of arguments to " + configCommand.commandName);
        }
        if (!this.isName(objectArray[1])) {
            this.syntaxError("The first argument to " + configCommand.commandName + " must be a name");
        }
        if (!this.isName(objectArray[2])) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be a property name");
        }
        String string = (String)objectArray[2];
        Object object = objectArray[3];
        if (string.equals("CoexistenceCenterInPworldPolicy")) {
            String string2;
            if (!(object instanceof String)) {
                this.syntaxError("CoexistenceCenterInPworldPolicy must be string");
            }
            if ((string2 = (String)object).equals("NOMINAL_HEAD")) {
                this.coexistenceCenterInPworldPolicy = 0;
            } else if (string2.equals("NOMINAL_SCREEN")) {
                this.coexistenceCenterInPworldPolicy = 2;
            } else if (string2.equals("NOMINAL_FEET")) {
                this.coexistenceCenterInPworldPolicy = 1;
            } else {
                this.syntaxError("Illegal value " + string2 + " for CoexistenceCenterInPworldPolicy");
            }
        } else if (string.equals("CoexistenceToTrackerBase")) {
            if (object instanceof Matrix4d) {
                this.coexistenceToTrackerBase = (Matrix4d)object;
            } else {
                this.syntaxError("CoexistenceToTrackerBase must be a Matrix4d");
            }
        } else if (string.equals("InputDevice")) {
            if (!(object instanceof String)) {
                this.syntaxError("InputDevice must be a name");
            }
            String string3 = (String)object;
            this.inputDevices.add(this.configContainer.findConfigObject("Device", string3));
        } else if (string.equals("HeadTracker")) {
            if (!(object instanceof String)) {
                this.syntaxError("HeadTracker must be a Sensor name");
            }
            String string4 = (String)object;
            this.headTracker = (ConfigSensor)this.configContainer.findConfigObject("Sensor", string4);
        } else {
            this.syntaxError("Unknown " + configCommand.commandName + " \"" + string + "\"");
        }
    }

    PhysicalEnvironment createJ3dPhysicalEnvironment() {
        this.j3dPhysicalEnvironment = new PhysicalEnvironment();
        this.j3dPhysicalEnvironment.setCoexistenceCenterInPworldPolicy(this.coexistenceCenterInPworldPolicy);
        if (this.coexistenceToTrackerBase != null) {
            this.j3dPhysicalEnvironment.setCoexistenceToTrackerBase(new Transform3D(this.coexistenceToTrackerBase));
        }
        return this.j3dPhysicalEnvironment;
    }

    void processDevices() {
        for (int i = 0; i < this.inputDevices.size(); ++i) {
            ConfigDevice configDevice = (ConfigDevice)this.inputDevices.get(i);
            InputDevice inputDevice = configDevice.j3dInputDevice;
            this.j3dPhysicalEnvironment.addInputDevice(inputDevice);
        }
        if (this.headTracker != null) {
            this.j3dPhysicalEnvironment.setHeadIndex(0);
            this.j3dPhysicalEnvironment.setSensor(0, this.headTracker.j3dSensor);
        }
    }
}

